/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.DefineMethodUtils;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.documentation.BuiltinDoc;
import org.eclipse.php.internal.ui.documentation.PHPDocumentationContentAccess;
import org.eclipse.php.internal.ui.editor.hover.PHPDocumentationHover;
import org.eclipse.php.ui.PHPElementLabels;
import org.eclipse.swt.graphics.FontData;
import org.osgi.framework.Bundle;

public class PHPDocumentationProvider
implements IScriptDocumentationProvider {
    protected static final String DL_END = "</dl>";
    protected static final String DL_START = "<dl>";
    private static String fgStyleSheet;
    private static final long LABEL_FLAGS;
    private static final long LOCAL_VARIABLE_FLAGS;

    static {
        LABEL_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L | 0x20L;
        LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    }

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        if (element instanceof FakeConstructor) {
            IType type = (IType)element.getParent();
            boolean cfr_ignored_0 = type instanceof AliasType;
            IMethod[] ctors = FakeConstructor.getConstructors((IType)type, (boolean)true);
            if (ctors != null && ctors.length == 2 && ctors[0] != null) {
                element = ctors[0];
            }
        } else {
            boolean cfr_ignored_1 = element instanceof AliasType;
        }
        StringBuffer buffer = new StringBuffer();
        String constantValue = null;
        if (element instanceof IField) {
            try {
                constantValue = this.getConstantValue((IField)element);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            if (constantValue != null) {
                constantValue = HTMLPrinter.convertToHTMLContent((String)constantValue);
            }
        }
        HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)PHPDocumentationProvider.getInfoText(element, constantValue, true));
        Reader reader = null;
        try {
            reader = PHPDocumentationProvider.getHTMLContent(element);
        }
        catch (ModelException modelException) {}
        if (reader != null) {
            HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)PHPDocumentationProvider.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new StringReader(buffer.toString());
        }
        return null;
    }

    public Reader getInfo(String keyword) {
        String builtinDoc = BuiltinDoc.getString(keyword);
        if (builtinDoc.length() > 0) {
            StringBuilder buf = new StringBuilder(DL_START);
            buf.append(builtinDoc);
            buf.append(DL_END);
            return new StringReader(buf.toString());
        }
        return null;
    }

    private static StringBuffer getInfoText(IMember member) {
        long flags = member.getElementType() == 8 ? LOCAL_VARIABLE_FLAGS : LABEL_FLAGS;
        String label = PHPElementLabels.getDefault().getElementLabel((IModelElement)member, flags);
        return new StringBuffer(label);
    }

    protected static Reader getHTMLContent(IMember curr) throws ModelException {
        String html = PHPDocumentationContentAccess.getHTMLContent(curr);
        if (html != null) {
            return new StringReader(html);
        }
        return null;
    }

    private static String getInfoText(IMember element, String constantValue, boolean allowImage) {
        URL imageUrl;
        StringBuffer label = PHPDocumentationProvider.getInfoText(element);
        if (element.getElementType() == 8 && constantValue != null) {
            label.append(' ');
            label.append('=');
            label.append(' ');
            label.append(constantValue);
        }
        String imageName = null;
        if (allowImage && (imageUrl = PHPUiPlugin.getDefault().getImagesOnFSRegistry().getImageURL((IModelElement)element)) != null) {
            imageName = imageUrl.toExternalForm();
        }
        StringBuilder buf = new StringBuilder();
        PHPDocumentationHover.addImageAndLabel(buf, imageName, 16, 16, 2, 2, label.toString(), 20, 2);
        return buf.toString();
    }

    protected static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = PHPDocumentationProvider.loadStyleSheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)PHPUiPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/PHPDocumentationHoverStyleSheet.css");
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException ex) {
                try {
                    PHPUiPlugin.log(ex);
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return "";
            }
        }
        return null;
    }

    private String getConstantValue(IField field) throws ModelException {
        ConstantDeclaration constantDeclaration;
        ASTNode argument;
        CallArgumentsList args;
        PHPCallExpression callExpression;
        if (!PHPDocumentationProvider.isFinal(field)) {
            return null;
        }
        ISourceModule sourceModule = field.getSourceModule();
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        ASTNode node = PHPModelUtils.getNodeByField((ModuleDeclaration)module, (IField)field);
        if (node == null && (callExpression = DefineMethodUtils.getDefineNodeByField((ModuleDeclaration)module, (IField)field)) != null && (args = callExpression.getArgs()) != null && args.getChilds() != null && args.getChilds().size() >= 2 && (argument = (ASTNode)args.getChilds().get(1)) instanceof Scalar) {
            String value = ASTUtils.stripQuotes((String)((Scalar)argument).getValue());
            return value;
        }
        if (!(node instanceof IPHPDocAwareDeclaration)) {
            return null;
        }
        if (node instanceof ConstantDeclaration && (constantDeclaration = (ConstantDeclaration)node).getConstantValue() instanceof Scalar) {
            Scalar scalar = (Scalar)constantDeclaration.getConstantValue();
            return scalar.getValue();
        }
        return null;
    }

    private static boolean isFinal(IField field) {
        try {
            return PHPFlags.isFinal((int)field.getFlags());
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
            return false;
        }
    }
}

