/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class StaticFieldHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new StaticFieldApply();
    }

    @Override
    public int getPriority() {
        return 110;
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setItalicByDefault(true).setDefaultTextColor(0, 0, 192);
    }

    public String getDisplayName() {
        return Messages.StaticFieldHighlighting_0;
    }

    protected class StaticFieldApply
    extends AbstractSemanticApply {
        private boolean visitField = false;

        protected StaticFieldApply() {
        }

        public boolean visit(StaticConstantAccess classConstantAccess) {
            StaticFieldHighlighting.this.highlight((ASTNode)classConstantAccess.getConstant());
            return true;
        }

        public boolean visit(FieldsDeclaration fieldsDeclaration) {
            if ((fieldsDeclaration.getModifier() & 0x80) != 0) {
                Variable[] variableArray = fieldsDeclaration.getVariableNames();
                int n = variableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable var = variableArray[n2];
                    StaticFieldHighlighting.this.highlight((ASTNode)var);
                    ++n2;
                }
            }
            return true;
        }

        public boolean visit(StaticFieldAccess fieldAccess) {
            this.visitField = true;
            fieldAccess.getMember().accept((Visitor)this);
            return false;
        }

        public boolean visit(Variable var) {
            if (this.visitField && var.isDollared()) {
                StaticFieldHighlighting.this.highlight((ASTNode)var);
                this.visitField = false;
            }
            return true;
        }

        public void endVisit(StaticFieldAccess fieldAccess) {
            this.visitField = false;
        }
    }
}

