/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.selectionactions.Messages;
import org.eclipse.php.internal.ui.editor.selectionactions.SelectionHistory;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectionAction;

public class StructureSelectNextAction
extends StructureSelectionAction {
    public StructureSelectNextAction(PHPStructuredEditor editor, SelectionHistory history) {
        super(Messages.StructureSelectNextAction_3, editor, history);
        this.setToolTipText(Messages.StructureSelectNextAction_4);
        this.setDescription(Messages.StructureSelectNextAction_5);
    }

    public StructureSelectNextAction() {
    }

    @Override
    public ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws ModelException {
        ASTNode previousNode;
        if (oldSourceRange.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = NextNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(sr, previousNode);
        }
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode lastSelectedNode = selAnalyzer.getSelectedNodes()[selAnalyzer.getSelectedNodes().length - 1];
        ASTNode nextNode = StructureSelectNextAction.getNextNode(parent, lastSelectedNode);
        if (nextNode == parent) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(sr, first.getParent());
        }
        int offset = oldSourceRange.getOffset();
        int end = Math.min(sr.getSourceRange().getLength(), nextNode.getEnd() - 1);
        return StructureSelectNextAction.createSourceRange(offset, end);
    }

    private static ASTNode getNextNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectNextAction.getSiblingNodes(node);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[siblingNodes.length - 1]) {
            return parent;
        }
        return siblingNodes[StructureSelectNextAction.findIndex(siblingNodes, node) + 1];
    }

    private static class NextNodeAnalyzer
    extends ApplyAll {
        private final int fOffset;
        private ASTNode fNextNode;

        private NextNodeAnalyzer(int offset) {
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            NextNodeAnalyzer analyzer = new NextNodeAnalyzer(offset);
            lastCoveringNode.accept((Visitor)analyzer);
            return analyzer.fNextNode;
        }

        public boolean visit(ASTNode node) {
            int start = node.getStart();
            int end = node.getEnd();
            if (start == this.fOffset) {
                this.fNextNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }

        protected boolean apply(ASTNode node) {
            int start = node.getStart();
            int end = node.getEnd();
            if (start == this.fOffset) {
                this.fNextNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }
    }
}

