/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.explorer.PHPExplorerContentProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.wst.jsdt.ui.ProjectLibraryRoot;

public class PHPNavigatorContentProvider
extends PHPExplorerContentProvider
implements IPipelinedTreeContentProvider {
    public static final String PDT_EXTENSION_ID = "org.eclipse.php.ui.phpContent";

    public PHPNavigatorContentProvider() {
        super(true);
    }

    public void init(ICommonContentExtensionSite aConfig) {
        IMemento memento = aConfig.getMemento();
        this.restoreState(memento);
        this.setIsFlatLayout(false);
        boolean showCUChildren = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.ui.packages.cuchildren");
        this.setProvideMembers(showCUChildren);
    }

    @Override
    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent instanceof IScriptModel) {
            return ((IScriptModel)parent).getWorkspace().getRoot();
        }
        if (parent instanceof IScriptProject) {
            return ((IScriptProject)parent).getProject();
        }
        if (parent instanceof ISourceModule) {
            return ((ISourceModule)parent).getResource();
        }
        return parent;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)parentElement;
            return PHPNavigatorContentProvider.filterResourceProjects(root.getProjects());
        }
        if (parentElement instanceof IProject) {
            IProject project = (IProject)parentElement;
            if (PHPNavigatorContentProvider.isPHPProject(project)) {
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                return super.getChildren(scriptProject);
            }
        } else if (!(parentElement instanceof IScriptFolder)) {
            IModelElement create;
            if (parentElement instanceof IScriptModel) {
                return PHPNavigatorContentProvider.filterResourceProjects(((IScriptModel)parentElement).getWorkspace().getRoot().getProjects());
            }
            if (parentElement instanceof IFile && (create = DLTKCore.create((IFile)((IFile)parentElement))) != null) {
                return super.getChildren(create);
            }
        }
        return super.getChildren(parentElement);
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public boolean hasChildren(Object element) {
        IModelElement create;
        if (element instanceof IProject) {
            return ((IProject)element).isAccessible();
        }
        if (element instanceof IFile && (create = DLTKCore.create((IFile)((IFile)element))) != null) {
            return super.hasChildren((Object)create);
        }
        return super.hasChildren(element);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return DLTKCore.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    private static IProject[] filterResourceProjects(IProject[] projects) {
        ArrayList<IProject> filteredProjects = new ArrayList<IProject>(projects.length);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!project.isOpen() || PHPNavigatorContentProvider.isPHPProject(project)) {
                filteredProjects.add(project);
            }
            ++i;
        }
        return filteredProjects.toArray(new IProject[filteredProjects.size()]);
    }

    private static boolean isPHPProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException e) {
            Logger.logException(e);
            return false;
        }
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        this.customize(this.getChildren(parent), currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        this.customize(this.getChildren(input), currentElements);
    }

    private void customize(Object[] phpElements, Set<Object> proposedChildren) {
        proposedChildren.clear();
        int i = 0;
        while (i < phpElements.length) {
            IResource resource;
            Object element = phpElements[i];
            if (element instanceof ISourceModule) {
                ISourceModule sourceModule = (ISourceModule)element;
                resource = sourceModule.getResource();
                if (resource != null) {
                    proposedChildren.add(resource);
                } else {
                    proposedChildren.add(sourceModule);
                }
            } else if (element instanceof IModelElement) {
                IModelElement cElement = (IModelElement)element;
                resource = cElement.getResource();
                if (resource != null) {
                    proposedChildren.remove(resource);
                }
                proposedChildren.add(element);
            } else if (!(element instanceof ProjectLibraryRoot) && element != null) {
                proposedChildren.add(element);
            }
            ++i;
        }
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return this.getParent(anObject);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        Object parent = addModification.getParent();
        if (parent instanceof IScriptProject) {
            addModification.setParent((Object)((IScriptProject)parent).getProject());
        }
        if (parent instanceof IWorkspaceRoot) {
            this.deconvertPHPProjects(addModification);
        }
        this.convertToPHPElements(addModification);
        return addModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        return removeModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return false;
    }

    private void deconvertPHPProjects(PipelinedShapeModification modification) {
        LinkedHashSet<IProject> convertedChildren = new LinkedHashSet<IProject>();
        Iterator iterator = modification.getChildren().iterator();
        while (iterator.hasNext()) {
            Object added = iterator.next();
            if (!(added instanceof IScriptProject)) continue;
            iterator.remove();
            convertedChildren.add(((IScriptProject)added).getProject());
        }
        modification.getChildren().addAll(convertedChildren);
    }

    private boolean convertToPHPElements(PipelinedShapeModification modification) {
        IModelElement element;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (element = DLTKCore.create((IResource)((IContainer)parent))) != null && element.exists()) {
            if (!(element instanceof IScriptModel) && !(element instanceof IScriptProject)) {
                modification.setParent((Object)element);
            }
            return this.convertToPHPElements(modification.getChildren());
        }
        return false;
    }

    private boolean convertToPHPElements(Set<Object> currentChildren) {
        LinkedHashSet<Object> convertedChildren = new LinkedHashSet<Object>();
        Iterator<Object> childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            Object child = childrenItr.next();
            if (child instanceof IFolder) {
                IModelElement newChild = DLTKCore.create((IResource)((IResource)child));
                if (newChild == null || !newChild.exists()) continue;
                childrenItr.remove();
                convertedChildren.add(newChild);
                continue;
            }
            if (!(child instanceof IScriptProject)) continue;
            childrenItr.remove();
            convertedChildren.add(((IScriptProject)child).getProject());
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    protected void postRefresh(List<?> toRefreshOld, boolean updateLabels, Collection<Runnable> runnables) {
        Object element;
        ArrayList toRefresh = new ArrayList(toRefreshOld);
        int size = toRefresh.size();
        int i = 0;
        while (i < size) {
            element = toRefresh.get(i);
            if (element instanceof IScriptProject) {
                toRefresh.set(i, ((IScriptProject)element).getProject());
            }
            ++i;
        }
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            element = iter.next();
            if (!(element instanceof IModelElement)) continue;
            iter.remove();
            toRefresh.add(((IModelElement)element).getModel().getWorkspace().getRoot());
            super.postRefresh(toRefresh, updateLabels, runnables);
            return;
        }
        super.postRefresh(toRefresh, updateLabels, runnables);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

