/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.sdm.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.internal.debug.core.PDebugOptions;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.internal.debug.sdm.core.messages.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDMRunner
extends Job {
    private List<String> command;
    private String workDir = null;
    private SDMMasterState sdmState = SDMMasterState.STARTING;
    private IRemoteConnection connection = null;
    private IRemoteProcess sdmProcess;
    private IPLaunch launch;

    public SDMRunner(IRemoteConnection conn) {
        super(Messages.SDMRunner_0);
        this.setPriority(30);
        this.setSystem(true);
        this.connection = conn;
        PDebugOptions.trace((String)"/debug/master/more", (String)Messages.SDMRunner_4, (String[])new String[0]);
    }

    public void setCommand(List<String> command) {
        PDebugOptions.trace((String)"/debug/master/more", (String)Messages.SDMRunner_5, (String[])new String[]{command.toString()});
        this.command = command;
    }

    public void setWorkDir(String workDir) {
        PDebugOptions.trace((String)"/debug/master/more", (String)Messages.SDMRunner_6, (String[])new String[]{workDir});
        this.workDir = workDir;
    }

    public synchronized SDMMasterState getSdmState() {
        return this.sdmState;
    }

    protected synchronized void setSdmState(SDMMasterState sdmState) {
        PDebugOptions.trace((String)"/debug/master/more", (String)Messages.SDMRunner_7, (String[])new String[]{sdmState.toString()});
        this.sdmState = sdmState;
        ((Object)((Object)this)).notifyAll();
    }

    public void setLaunch(IPLaunch launch) {
        PDebugOptions.trace((String)"/debug/master/more", (String)Messages.SDMRunner_8, (String[])new String[]{launch.getJobId()});
        this.launch = launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        assert (this.command != null);
        assert (this.sdmProcess == null);
        PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_9, (String[])new String[0]);
        if (!this.connection.hasService(IRemoteFileService.class) || !this.connection.hasService(IRemoteProcessService.class)) {
            return new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), "Failed to start: connection does not provide requisite services");
        }
        try {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            IRemoteFileService fileService = (IRemoteFileService)this.connection.getService(IRemoteFileService.class);
            IRemoteProcessService processService = (IRemoteProcessService)this.connection.getService(IRemoteProcessService.class);
            IRemoteProcessBuilder sdmProcessBuilder = processService.getProcessBuilder(this.command);
            if (this.workDir != null) {
                sdmProcessBuilder.directory(fileService.getResource(this.workDir));
            }
            PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_10, (String[])new String[0]);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            SDMRunner sDMRunner = this;
            synchronized (sDMRunner) {
                ((Object)((Object)this)).wait(3000L);
            }
            PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_11, (String[])new String[0]);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            sDMRunner = this;
            synchronized (sDMRunner) {
                this.sdmProcess = sdmProcessBuilder.start();
            }
            final BufferedReader err_reader = new BufferedReader(new InputStreamReader(this.sdmProcess.getErrorStream()));
            final BufferedReader out_reader = new BufferedReader(new InputStreamReader(this.sdmProcess.getInputStream()));
            if (PDebugOptions.isDebugging((String)"/debug/master/output")) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = out_reader.readLine()) != null) {
                                System.out.println(String.valueOf(Messages.SDMRunner_12) + output);
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            out_reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.SDMRunner_13).start();
            }
            if (PDebugOptions.isDebugging((String)"/debug/master/output")) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = err_reader.readLine()) != null) {
                                System.err.println(String.valueOf(Messages.SDMRunner_14) + line);
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            err_reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }, Messages.SDMRunner_15).start();
            }
            this.setSdmState(SDMMasterState.RUNNING);
            PDebugOptions.trace((String)"/debug/master/more", (String)Messages.SDMRunner_16, (String[])new String[0]);
            while (!this.sdmProcess.isCompleted()) {
                SDMRunner sDMRunner2 = this;
                synchronized (sDMRunner2) {
                    ((Object)((Object)this)).wait(500L);
                }
                if (!monitor.isCanceled()) continue;
                out_reader.close();
                err_reader.close();
                throw new InterruptedException();
            }
            PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_17, (String[])new String[]{Integer.toString(this.sdmProcess.exitValue())});
            if (this.sdmProcess.exitValue() != 0) {
                if (!monitor.isCanceled()) {
                    throw new CoreException((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), NLS.bind((String)Messages.SDMRunner_2, (Object)this.sdmProcess.exitValue())));
                }
                PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_18, (String[])new String[0]);
            }
            this.setSdmState(SDMMasterState.FINISHED);
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            block49: {
                block48: {
                    IStatus iStatus2;
                    try {
                        PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_19, (String[])new String[]{e.toString()});
                        SDMRunner processService = this;
                        synchronized (processService) {
                            PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_20, (String[])new String[]{e.toString()});
                            this.sdmProcess.destroy();
                        }
                        try {
                            if (this.launch != null) {
                                PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_21, (String[])new String[]{this.launch.getJobId()});
                                this.launch.getJobControl().control(this.launch.getJobId(), "TERMINATE", null);
                            }
                        }
                        catch (CoreException e1) {
                            PTPDebugCorePlugin.log((Throwable)e1);
                        }
                        if (!(e instanceof InterruptedException)) break block48;
                        this.setSdmState(SDMMasterState.FINISHED);
                        iStatus2 = Status.CANCEL_STATUS;
                    }
                    catch (Throwable throwable) {
                        PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_22, (String[])new String[0]);
                        SDMRunner sDMRunner = this;
                        synchronized (sDMRunner) {
                            this.sdmProcess = null;
                        }
                        throw throwable;
                    }
                    PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_22, (String[])new String[0]);
                    SDMRunner sDMRunner = this;
                    synchronized (sDMRunner) {
                        this.sdmProcess = null;
                    }
                    return iStatus2;
                }
                if (!(e instanceof CoreException)) break block49;
                this.setSdmState(SDMMasterState.ERROR);
                IStatus iStatus3 = ((CoreException)((Object)e)).getStatus();
                PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_22, (String[])new String[0]);
                SDMRunner sDMRunner = this;
                synchronized (sDMRunner) {
                    this.sdmProcess = null;
                }
                return iStatus3;
            }
            this.setSdmState(SDMMasterState.ERROR);
            Status status = new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), Messages.SDMRunner_3, (Throwable)e);
            PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_22, (String[])new String[0]);
            SDMRunner sDMRunner = this;
            synchronized (sDMRunner) {
                this.sdmProcess = null;
            }
            return status;
        }
        PDebugOptions.trace((String)"/debug/master", (String)Messages.SDMRunner_22, (String[])new String[0]);
        SDMRunner sDMRunner = this;
        synchronized (sDMRunner) {
            this.sdmProcess = null;
        }
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        SDMRunner sDMRunner = this;
        synchronized (sDMRunner) {
            if (this.sdmProcess != null) {
                this.sdmProcess.destroy();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SDMMasterState {
        UNKNOWN,
        STARTING,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

