/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.util.PS_Debug;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.util.PS_Environment;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcCountingReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcPCProfileReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcProfileReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_MultiHwpcProfileReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_MultiHwpcReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_Report;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_ResourceReport;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class PS_ReportParser
extends DefaultHandler {
    private static XMLReader xmlReaderValidating;
    private static XMLReader xmlReaderNonValidating;
    private PS_Report report;
    private PS_MultiHwpcReport multiReport;
    private PS_MultiHwpcProfileReport multiProfileReport;
    private int genXmlType;
    private StringBuilder xmlBuf;
    private String tmpValue = "";
    private int xmlDepth = 0;
    private static final int xmlIndent;

    static {
        String var = "PSPROCESS_XML_INDENT";
        int tmpind = PS_Environment.getNonNegativeInteger(var);
        if (tmpind != -1) {
            xmlIndent = tmpind;
        } else {
            PS_Debug.print(2, "Wrong format/value for " + var + ". Using the default value of 4...");
            xmlIndent = 4;
        }
    }

    PS_ReportParser(String filename, boolean validateDTD, int genXmlType) throws FileNotFoundException, MalformedURLException {
        this.genXmlType = genXmlType;
        this.ctorHelper(filename, validateDTD);
    }

    PS_ReportParser(String filename, boolean validateDTD) throws FileNotFoundException, MalformedURLException {
        this.ctorHelper(filename, validateDTD);
    }

    PS_ReportParser(InputStream ais, boolean validateDTD) throws IOException {
        if (ais == null) {
            throw new IllegalArgumentException("The input stream is null");
        }
        XMLReader xr = this.getXMLReader(validateDTD);
        xr.setContentHandler(this);
        xr.setEntityResolver(this);
        InputSource is = new InputSource(ais);
        try {
            xr.parse(is);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void ctorHelper(String filename, boolean validateDTD) throws FileNotFoundException, MalformedURLException {
        XMLReader xr = this.getXMLReader(validateDTD);
        xr.setContentHandler(this);
        xr.setEntityResolver(this);
        InputSource is = null;
        if (filename != null) {
            try {
                FileReader r = new FileReader(filename);
                is = new InputSource(r);
            }
            catch (FileNotFoundException fileNotFoundException) {
                is = new InputSource(filename);
            }
        } else {
            is = new InputSource(System.in);
        }
        try {
            xr.parse(is);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (NullPointerException e) {
            PS_Debug.print(2, "A NullPointerException was thrown, usually due to a malformed URL such as http:/illinois.edu, so change it to a MalformedURLException. The original NullPointerException was: \n");
            if (PS_Debug.getLevel() >= 2) {
                e.printStackTrace();
            }
            throw new MalformedURLException(filename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    PS_Report getReport() {
        if (this.multiReport != null) {
            return this.multiReport;
        }
        if (this.multiProfileReport != null) {
            return this.multiProfileReport;
        }
        return this.report;
    }

    private XMLReader getXMLReader(boolean validateDTD) {
        XMLReader xr;
        if (validateDTD && xmlReaderValidating != null) {
            return xmlReaderValidating;
        }
        if (!validateDTD && xmlReaderNonValidating != null) {
            return xmlReaderNonValidating;
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(validateDTD);
        try {
            SAXParser saxParser = spf.newSAXParser();
            xr = saxParser.getXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        xr.setErrorHandler(new MyErrorHandler(System.err));
        if (validateDTD) {
            xmlReaderValidating = xr;
        } else {
            xmlReaderNonValidating = xr;
        }
        return xr;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String filename = systemId.startsWith("file://") ? systemId.substring("file://".length()) : systemId;
        try {
            FileReader dtd = new FileReader(filename);
            return new InputSource(dtd);
        }
        catch (FileNotFoundException fileNotFoundException) {
            PS_Debug.print(2, "the DTD file \"" + filename + "\" does not exist, " + "is a directory rather than a regular file, " + "or for some other reason cannot be opened for reading." + " Ignoring the DTD file...");
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    private void fillXmlBuf(String tagname, Attributes attributes, StringBuilder xmlBuf) {
        if (this.genXmlType != 0 && xmlBuf != null) {
            String nsStr = "";
            if (tagname.equals("hwpcreport") || tagname.equals("hwpcprofilereport")) {
                nsStr = " xmlns:perfsuite=\"http://perfsuite.ncsa.uiuc.edu/\"";
            } else {
                xmlBuf.append("\n");
            }
            xmlBuf.append(this.spaces(this.xmlDepth * xmlIndent)).append("<").append(tagname).append(nsStr);
            int asize = attributes.getLength();
            if (asize > 0) {
                int aindex = 0;
                while (aindex < asize) {
                    xmlBuf.append(" ").append(attributes.getLocalName(aindex)).append("=\"").append(attributes.getValue(aindex).replace("&", "&amp;").replace("<", "&lt;")).append("\"");
                    ++aindex;
                }
            }
            xmlBuf.append(">");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String tagname = qName.trim();
        PS_Report tmpReport = null;
        if (tagname.equals("multihwpcreport")) {
            tmpReport = this.multiReport = new PS_MultiHwpcReport();
        } else if (tagname.equals("multihwpcprofilereport")) {
            this.multiProfileReport = new PS_MultiHwpcProfileReport();
            tmpReport = this.multiProfileReport;
        } else if (tagname.equals("resourcereport")) {
            this.report = new PS_ResourceReport();
            tmpReport = this.report;
        } else if (tagname.equals("hwpcprofilereport")) {
            this.report = new PS_HwpcProfileReport();
            tmpReport = this.report;
            if (this.genXmlType != 0) {
                this.xmlDepth = 0;
                if (this.genXmlType == 2) {
                    this.xmlDepth = 1;
                }
                this.xmlBuf = new StringBuilder();
                this.report.setXmlBuf(this.xmlBuf);
            }
        } else if (tagname.equals("hwpcreport")) {
            String mode = attributes.getValue("mode");
            if (this.genXmlType != 0) {
                this.xmlDepth = 0;
                if (this.genXmlType == 2) {
                    this.xmlDepth = 1;
                }
            }
            if (mode == null || mode.equals("count")) {
                this.report = new PS_HwpcCountingReport();
                if (this.genXmlType != 0) {
                    this.xmlBuf = new StringBuilder();
                    this.report.setXmlBuf(this.xmlBuf);
                }
            } else if (mode.equals("profile")) {
                this.report = new PS_HwpcPCProfileReport();
                if (this.genXmlType != 0) {
                    this.xmlBuf = new StringBuilder();
                    this.report.setXmlBuf(this.xmlBuf);
                }
            } else {
                throw new UnsupportedOperationException("mode: \"" + mode + "\" not supported for hwpc report.  Only 'count' and 'profile' modes are supported now.");
            }
            tmpReport = this.report;
        } else if (this.report != null) {
            this.report.startElement(uri, localName, qName, attributes);
        }
        if (tmpReport != null) {
            tmpReport.setVersion(attributes.getValue("version"));
            tmpReport.setGenerator(attributes.getValue("generator"));
        }
        this.fillXmlBuf(tagname, attributes, this.xmlBuf);
        if (this.genXmlType != 0) {
            this.tmpValue = "";
            ++this.xmlDepth;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        String tagname = qName.trim();
        if (this.genXmlType != 0 && this.xmlBuf != null) {
            this.xmlBuf.append(this.tmpValue);
            if (this.tmpValue.equals("") && !tagname.equals("hwpcevent")) {
                this.xmlBuf.append("\n" + this.spaces((this.xmlDepth - 1) * xmlIndent));
            }
        }
        if (tagname.equals("hwpcreport")) {
            if (this.multiReport != null) {
                this.multiReport.addReport((PS_HwpcReport)this.report);
            }
            if (this.genXmlType != 0 && this.xmlBuf != null) {
                this.xmlBuf.append("</hwpcreport>\n");
                this.xmlBuf = null;
            }
        } else if (tagname.equals("hwpcprofilereport")) {
            if (this.multiProfileReport != null) {
                this.multiProfileReport.addReport((PS_HwpcProfileReport)this.report);
            }
            if (this.genXmlType != 0 && this.xmlBuf != null) {
                this.xmlBuf.append("</hwpcprofilereport>\n");
                this.xmlBuf = null;
            }
        } else if (this.report != null) {
            this.report.endElement(uri, localName, qName);
            if (this.genXmlType != 0 && this.xmlBuf != null) {
                this.xmlBuf.append("</" + tagname + ">");
            }
        }
        if (this.genXmlType != 0) {
            this.tmpValue = "";
            --this.xmlDepth;
        }
    }

    private String spaces(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < num) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.report != null) {
            String tmpString;
            this.report.characters(ch, start, length);
            if (this.genXmlType != 0 && this.xmlBuf != null && (tmpString = new String(ch, start, length)).length() != 0) {
                this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
            }
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        MyErrorHandler(PrintStream out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String info = "Public ID: " + spe.getPublicId() + ", System ID: " + spe.getSystemId() + ", Line number: " + spe.getLineNumber() + ", Column number: " + spe.getColumnNumber() + ", Message: " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            String message = "Warning: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

