/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassRelationships;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.CyclesAnalyzer;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.QVTp2QVTg;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region2Depth;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RegionCycle;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootCompositionRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduleIndexer;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitor;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;
import org.eclipse.qvtd.pivot.schedule.AbstractDatum;
import org.eclipse.qvtd.pivot.schedule.ClassDatum;
import org.eclipse.qvtd.pivot.schedule.PropertyDatum;

public class RootScheduledRegion
extends AbstractScheduledRegion {
    private final @NonNull String name;
    protected final @NonNull CompleteModel completeModel;
    private final @NonNull Map<@NonNull Model, @NonNull DomainUsage> inputModels = new HashMap<Model, DomainUsage>();
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull Set<@NonNull Property>> containedClassDatumAnalysis2compositeProperties = new HashMap<ClassDatumAnalysis, Set<Property>>();
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull List<@NonNull Node>> consumedClassDatumAnalysis2headNodes = new HashMap<ClassDatumAnalysis, List<Node>>();
    private final @NonNull Map<@NonNull Property, @NonNull Set<@NonNull ClassDatumAnalysis>> consumedCompositeProperty2introducedClassDatumAnalyses = new HashMap<Property, Set<ClassDatumAnalysis>>();
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull List<@NonNull Node>> introducedClassDatumAnalysis2nodes = new HashMap<ClassDatumAnalysis, List<Node>>();
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull List<@NonNull Node>> producedClassDatumAnalysis2realizedNodes = new HashMap<ClassDatumAnalysis, List<Node>>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull List<@NonNull NavigationEdge>> producedPropertyDatum2realizedEdges = new HashMap<PropertyDatum, List<NavigationEdge>>();
    private final @NonNull RootCompositionRegion rootContainmentRegion = new RootCompositionRegion(this.superRegion);

    public static @NonNull BinaryOperator<@NonNull String> stringJoin(@NonNull String delimiter) {
        return (a, b) -> String.valueOf(String.valueOf(a)) + delimiter + String.valueOf(b);
    }

    public RootScheduledRegion(@NonNull String name, @NonNull Region primaryRegion) {
        super(primaryRegion.getSuperRegion());
        this.name = name;
        this.completeModel = this.getSchedulerConstants().getEnvironmentFactory().getCompleteModel();
    }

    public RootScheduledRegion(@NonNull String name, @NonNull List<Region> regions) {
        super(((Region)ClassUtil.nonNullState((Object)regions.get(0))).getSuperRegion());
        this.name = name;
        this.completeModel = this.getSchedulerConstants().getEnvironmentFactory().getCompleteModel();
        for (Region region : regions) {
            this.addRegion(region);
        }
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitRootScheduledRegion(this);
    }

    private void addConsumedNode(@NonNull Node headNode) {
        Region region = headNode.getRegion();
        ScheduledRegion invokingRegion = region.getInvokingRegion();
        assert (invokingRegion == this || invokingRegion == null);
        ClassDatumAnalysis consumedClassDatumAnalysis = headNode.getClassDatumAnalysis();
        List<@NonNull Node> nodes = this.consumedClassDatumAnalysis2headNodes.get(consumedClassDatumAnalysis);
        if (nodes == null) {
            nodes = new ArrayList<Node>();
            this.consumedClassDatumAnalysis2headNodes.put(consumedClassDatumAnalysis, nodes);
        }
        if (!nodes.contains(headNode)) {
            nodes.add(headNode);
        }
    }

    private void addIntroducedNode(@NonNull Node introducedNode) {
        ClassDatumAnalysis classDatumAnalysis = this.getElementalClassDatumAnalysis(introducedNode);
        List<@NonNull Node> nodes = this.introducedClassDatumAnalysis2nodes.get(classDatumAnalysis);
        if (nodes == null) {
            nodes = new ArrayList<Node>();
            this.introducedClassDatumAnalysis2nodes.put(classDatumAnalysis, nodes);
        }
        nodes.add(introducedNode);
    }

    private void addProducedEdge(@NonNull NavigationEdge producedEdge) {
        PropertyDatum propertyDatum = this.getPropertyDatum(producedEdge);
        if (propertyDatum == null) {
            propertyDatum = this.getPropertyDatum(producedEdge);
        }
        assert (propertyDatum != null);
        this.addProducedEdge(producedEdge, propertyDatum);
    }

    private void addProducedEdge(@NonNull NavigationEdge producedEdge, @NonNull PropertyDatum propertyDatum) {
        List<@NonNull NavigationEdge> edges = this.producedPropertyDatum2realizedEdges.get(propertyDatum);
        if (edges == null) {
            edges = new ArrayList<NavigationEdge>();
            this.producedPropertyDatum2realizedEdges.put(propertyDatum, edges);
        }
        if (!edges.contains(producedEdge)) {
            edges.add(producedEdge);
            for (AbstractDatum superAbstractDatum : ClassUtil.nullFree((EList)propertyDatum.getSuper())) {
                if (!(superAbstractDatum instanceof PropertyDatum)) continue;
                this.addProducedEdge(producedEdge, (PropertyDatum)superAbstractDatum);
            }
        }
    }

    private void addProducedNode(@NonNull Node producedNode) {
        ClassDatumAnalysis classDatumAnalysis = this.getElementalClassDatumAnalysis(producedNode);
        for (ClassDatumAnalysis superClassDatumAnalysis : classDatumAnalysis.getSuperClassDatumAnalyses()) {
            List<@NonNull Node> nodes = this.producedClassDatumAnalysis2realizedNodes.get(superClassDatumAnalysis);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                this.producedClassDatumAnalysis2realizedNodes.put(superClassDatumAnalysis, nodes);
            }
            nodes.add(producedNode);
        }
    }

    private void computeConsumedConsumedClassDatumAnalysis2headNodes() {
        for (Region region : this.getRegions()) {
            for (Node predicatedNode : region.getMatchableNodes()) {
                if (predicatedNode.isHead() || predicatedNode.isLoaded() || predicatedNode.isConstant() || predicatedNode.isInternal() || this.isOnlyCastOrRecursed(predicatedNode)) continue;
                this.addConsumedNode(predicatedNode);
            }
            for (Node headNode : region.getHeadNodes()) {
                if (!headNode.isLoaded() || headNode.isInternal()) continue;
                this.addConsumedNode(headNode);
            }
        }
    }

    private void computeContainedClassDatumAnalysis2compositeProperties() {
        DomainUsage domainUsage;
        HashMap<@NonNull Package, @NonNull DomainUsage> allPackagesSet = new HashMap<Package, DomainUsage>();
        ArrayList<@NonNull Package> allPackagesList = new ArrayList<Package>();
        for (Model asModel : this.inputModels.keySet()) {
            domainUsage = this.inputModels.get(asModel);
            assert (domainUsage != null);
            for (Package asPackage : ClassUtil.nullFree((List)asModel.getOwnedPackages())) {
                if (allPackagesSet.put(asPackage, domainUsage) != null) continue;
                allPackagesList.add(asPackage);
            }
            for (Import asImport : ClassUtil.nullFree((List)asModel.getOwnedImports())) {
                Package asPackage;
                Namespace importedObject = asImport.getImportedNamespace();
                while (importedObject != null && !(importedObject instanceof Package)) {
                    importedObject = importedObject.eContainer();
                }
                if (!(importedObject instanceof Package) || allPackagesSet.put(asPackage = (Package)importedObject, domainUsage) != null) continue;
                allPackagesList.add(asPackage);
            }
        }
        int i = 0;
        while (i < allPackagesList.size()) {
            Package asPackage = (Package)allPackagesList.get(i);
            domainUsage = (DomainUsage)ClassUtil.nonNullState((Object)((DomainUsage)allPackagesSet.get(asPackage)));
            for (Package asPackage2 : ClassUtil.nullFree((List)asPackage.getOwnedPackages())) {
                if (allPackagesSet.put(asPackage2, domainUsage) != null) continue;
                allPackagesList.add(asPackage2);
            }
            for (Class asClass : ClassUtil.nullFree((List)asPackage.getOwnedClasses())) {
                for (Property asProperty : ClassUtil.nullFree((List)asClass.getOwnedProperties())) {
                    Package asPackage2;
                    Type asType;
                    if (asProperty.isIsComposite()) {
                        this.computeContainedClassDatumAnalysis2compositeProperties3(asProperty, domainUsage);
                    }
                    if (!((asType = asProperty.getType()) instanceof Class) || (asPackage2 = ((Class)asType).getOwningPackage()) == null || allPackagesSet.put(asPackage2, domainUsage) != null) continue;
                    allPackagesList.add(asPackage2);
                }
            }
            ++i;
        }
        assert (allPackagesSet.size() == allPackagesList.size());
        assert (allPackagesSet.keySet().equals(new HashSet(allPackagesList)));
    }

    private void computeContainedClassDatumAnalysis2compositeProperties3(@NonNull Property asProperty, @NonNull DomainUsage domainUsage) {
        Type asType = QVTbaseUtil.getElementalType((Type)((Type)ClassUtil.nonNullState((Object)asProperty.getType())));
        if (asType instanceof Class) {
            ClassDatumAnalysis classDatumAnalysis = this.getSchedulerConstants().getClassDatumAnalysis((Class)asType, (TypedModel)ClassUtil.nonNullState((Object)domainUsage.getTypedModel(null)));
            Set<@NonNull Property> compositeProperties = this.containedClassDatumAnalysis2compositeProperties.get(classDatumAnalysis);
            if (compositeProperties == null) {
                compositeProperties = new HashSet<Property>();
                this.containedClassDatumAnalysis2compositeProperties.put(classDatumAnalysis, compositeProperties);
            }
            compositeProperties.add(asProperty);
        }
    }

    private void computeConsumedCompositeProperty2introducedClassDatumAnalyses() {
        HashSet<@NonNull ClassDatumAnalysis> allConsumedClassDatumAnalyses = new HashSet<ClassDatumAnalysis>(this.consumedClassDatumAnalysis2headNodes.keySet());
        ArrayList<@NonNull ClassDatumAnalysis> allConsumedClassDatumAnalysesList = new ArrayList<ClassDatumAnalysis>(allConsumedClassDatumAnalyses);
        int i = 0;
        while (i < allConsumedClassDatumAnalysesList.size()) {
            ClassDatumAnalysis consumedClassDatumAnalysis = (ClassDatumAnalysis)allConsumedClassDatumAnalysesList.get(i);
            for (ClassDatumAnalysis consumedSuperClassDatumAnalysis : consumedClassDatumAnalysis.getSuperClassDatumAnalyses()) {
                Set<@NonNull Property> consumedCompositeProperties = this.containedClassDatumAnalysis2compositeProperties.get(consumedSuperClassDatumAnalysis);
                if (consumedCompositeProperties == null) continue;
                for (Property consumedCompositeProperty : consumedCompositeProperties) {
                    Set<@NonNull ClassDatumAnalysis> introducedClassDatumAnalyses = this.consumedCompositeProperty2introducedClassDatumAnalyses.get(consumedCompositeProperty);
                    if (introducedClassDatumAnalyses == null) {
                        introducedClassDatumAnalyses = new HashSet<ClassDatumAnalysis>();
                        this.consumedCompositeProperty2introducedClassDatumAnalyses.put(consumedCompositeProperty, introducedClassDatumAnalyses);
                    }
                    introducedClassDatumAnalyses.add(consumedClassDatumAnalysis);
                    Class containerClass = consumedCompositeProperty.getOwningClass();
                    assert (containerClass != null);
                    ClassDatumAnalysis containerSuperClassDatumAnalysis = this.getSchedulerConstants().getClassDatumAnalysis(containerClass, consumedClassDatumAnalysis.getTypedModel());
                    if (!allConsumedClassDatumAnalyses.add(containerSuperClassDatumAnalysis)) continue;
                    allConsumedClassDatumAnalysesList.add(containerSuperClassDatumAnalysis);
                }
            }
            ++i;
        }
        assert (allConsumedClassDatumAnalyses.size() == allConsumedClassDatumAnalysesList.size());
    }

    private void computeInputModels() {
        for (ClassDatumAnalysis classDatumAnalysis : this.getSchedulerConstants().getClassDatumAnalyses()) {
            Model model;
            Class type;
            Package asPackage;
            DomainUsage domainUsage = classDatumAnalysis.getDomainUsage();
            if (!domainUsage.isInput() || domainUsage.isOutput() || (asPackage = PivotUtil.getContainingPackage((EObject)(type = classDatumAnalysis.getClassDatum().getType()))) == null || "http://www.eclipse.org/ocl/2015/Orphanage".equals(asPackage.getURI()) || (model = PivotUtil.getContainingModel((EObject)type)) == null) continue;
            this.inputModels.put(model, domainUsage);
        }
    }

    private void computeProducedClassDatumAnalysis2realizedNodes() {
        for (Region region : this.getRegions()) {
            for (Node assignedNode : region.getAssignedNodes()) {
                if (!assignedNode.isClassNode()) continue;
                this.addProducedNode(assignedNode);
            }
            for (NavigationEdge realizedNavigationEdge : region.getRealizedNavigationEdges()) {
                this.addProducedEdge(realizedNavigationEdge);
            }
        }
    }

    @Override
    protected @NonNull SymbolNameBuilder computeSymbolName() {
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("s_");
        s.appendName(this.name);
        return s;
    }

    private void createConnections() {
        ArrayList<@NonNull E> sortedCallableRegions = new ArrayList();
        Iterables.addAll(sortedCallableRegions, this.getCallableRegions());
        Collections.sort(sortedCallableRegions, NameUtil.NAMEABLE_COMPARATOR);
        for (Region region : sortedCallableRegions) {
            region.createIncomingConnections();
        }
        if (Scheduler.DEBUG_GRAPHS.isActive()) {
            this.writeDebugGraphs("4-bindings", true, true, false);
        }
    }

    private @NonNull RootCompositionRegion createRootContainmentRegion() {
        this.addRegion(this.rootContainmentRegion);
        for (Region region : this.getCallableRegions()) {
            for (Node node : region.getHeadNodes()) {
                SimpleNode introducedNode = this.rootContainmentRegion.getIntroducerNode(node);
                this.addIntroducedNode(introducedNode);
            }
        }
        if (Scheduler.DEBUG_GRAPHS.isActive()) {
            this.rootContainmentRegion.writeDebugGraphs("1-create");
        }
        return this.rootContainmentRegion;
    }

    public void createSchedule() {
        this.computeInputModels();
        if (Scheduler.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.isActive()) {
            Scheduler.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.println(this.dumpInputModels().reduce("", RootScheduledRegion.stringJoin("\n\t")));
        }
        this.computeContainedClassDatumAnalysis2compositeProperties();
        if (Scheduler.DUMP_CLASS_TO_CONTAINING_PROPERTIES.isActive()) {
            Scheduler.DUMP_CLASS_TO_CONTAINING_PROPERTIES.println(this.dumpClass2ContainingProperties().reduce("", RootScheduledRegion.stringJoin("\n\t")));
        }
        this.computeProducedClassDatumAnalysis2realizedNodes();
        if (Scheduler.DUMP_CLASS_TO_REALIZED_NODES.isActive()) {
            Scheduler.DUMP_CLASS_TO_REALIZED_NODES.println(this.dumpClass2ProducingNode().reduce("", RootScheduledRegion.stringJoin("\n\t")));
        }
        this.computeConsumedConsumedClassDatumAnalysis2headNodes();
        if (Scheduler.DUMP_CLASS_TO_CONSUMING_NODES.isActive()) {
            Scheduler.DUMP_CLASS_TO_CONSUMING_NODES.println(this.dumpClass2consumingNode().reduce("", RootScheduledRegion.stringJoin("\n\t")));
        }
        this.computeConsumedCompositeProperty2introducedClassDatumAnalyses();
        if (Scheduler.DUMP_PROPERTY_TO_CONSUMING_CLASSES.isActive()) {
            Scheduler.DUMP_PROPERTY_TO_CONSUMING_CLASSES.println(this.dumpClass2ConsumingProperty().reduce("", RootScheduledRegion.stringJoin("\n\t")));
        }
        this.createRootContainmentRegion();
        this.createConnections();
        ArrayList<@NonNull RootScheduledRegion> allScheduledRegions = new ArrayList<RootScheduledRegion>();
        allScheduledRegions.add(this);
        CyclesAnalyzer cyclesAnalyzer = new CyclesAnalyzer(this, this.getCallableRegions());
        List<@NonNull RegionCycle> regionCycles = cyclesAnalyzer.getOrderedCycles();
        if (Scheduler.DEBUG_GRAPHS.isActive()) {
            this.writeDebugGraphs("4-cycles", true, true, false);
        }
        for (ScheduledRegion scheduledRegion : allScheduledRegions) {
            scheduledRegion.createLocalSchedule();
        }
        ScheduleIndexer scheduleIndexer = new ScheduleIndexer(this);
        scheduleIndexer.schedule(this);
        for (ScheduledRegion scheduledRegion : allScheduledRegions) {
            scheduledRegion.createLocalSchedule2(scheduleIndexer.getOrdering());
        }
    }

    public Stream<String> dumpClass2consumingNode() {
        Stream<String> entries = this.consumedClassDatumAnalysis2headNodes.keySet().stream().map(k -> {
            List<Node> list = this.consumedClassDatumAnalysis2headNodes.get(k);
            assert (list != null);
            return String.valueOf(String.valueOf(k)) + " : " + list.stream().map(p -> p.getDisplayName()).sorted().reduce("", RootScheduledRegion.stringJoin("\n\t\t"));
        });
        return entries.sorted();
    }

    public Stream<String> dumpClass2ConsumingProperty() {
        Stream<String> entries = this.consumedCompositeProperty2introducedClassDatumAnalyses.keySet().stream().map(k -> {
            Set<ClassDatumAnalysis> set = this.consumedCompositeProperty2introducedClassDatumAnalyses.get(k);
            assert (set != null);
            return String.valueOf(String.valueOf(k)) + " : " + set.stream().map(p -> p.toString()).sorted().reduce("", RootScheduledRegion.stringJoin("\n\t\t"));
        });
        return entries.sorted();
    }

    public Stream<String> dumpClass2ContainingProperties() {
        Stream<String> entries = this.containedClassDatumAnalysis2compositeProperties.keySet().stream().map(k -> {
            Set<Property> set = this.containedClassDatumAnalysis2compositeProperties.get(k);
            assert (set != null);
            return String.valueOf(String.valueOf(k)) + " " + k.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(k)) + " : " + set.stream().map(p -> String.valueOf(p)).sorted().reduce("", RootScheduledRegion.stringJoin("\n\t\t"));
        });
        return entries.sorted();
    }

    public Stream<String> dumpClass2ProducingNode() {
        Stream<String> entries = this.producedClassDatumAnalysis2realizedNodes.keySet().stream().map(k -> {
            List<Node> list = this.producedClassDatumAnalysis2realizedNodes.get(k);
            assert (list != null);
            return String.valueOf(String.valueOf(k)) + " : " + list.stream().map(p -> p.getDisplayName()).sorted().reduce("", RootScheduledRegion.stringJoin("\n\t\t"));
        });
        return entries.sorted();
    }

    public Stream<String> dumpInputModels() {
        Stream<String> entries = this.inputModels.keySet().stream().map(k -> String.valueOf(String.valueOf(k)) + " : " + String.valueOf(this.inputModels.get(k)));
        return entries.sorted();
    }

    private @Nullable Iterable<@NonNull NavigationEdge> getCompositeRealizedEdges(@NonNull NavigationEdge predicatedEdge) {
        HashSet<@NonNull E> realizedEdges = null;
        for (Map.Entry<PropertyDatum, List<NavigationEdge>> entry : this.producedPropertyDatum2realizedEdges.entrySet()) {
            Property property = entry.getKey().getProperty();
            if (property == null) continue;
            Property compositeProperty = null;
            if (property.isIsComposite()) {
                compositeProperty = property;
            } else {
                Property oppositeProperty = property.getOpposite();
                if (oppositeProperty != null && oppositeProperty.isIsComposite()) {
                    compositeProperty = oppositeProperty;
                }
            }
            if (compositeProperty == null) continue;
            if (realizedEdges == null) {
                realizedEdges = new HashSet();
            }
            realizedEdges.addAll(entry.getValue());
        }
        return realizedEdges;
    }

    protected @NonNull ClassDatumAnalysis getElementalClassDatumAnalysis(@NonNull Node calledNode) {
        ClassDatumAnalysis classDatumAnalysis = calledNode.getClassDatumAnalysis();
        CompleteClass completeClass = classDatumAnalysis.getCompleteClass();
        Class primaryClass = completeClass.getPrimaryClass();
        if (primaryClass instanceof CollectionType) {
            Class elementType = (Class)((CollectionType)primaryClass).getElementType();
            assert (elementType != null);
            classDatumAnalysis = this.getSchedulerConstants().getClassDatumAnalysis(elementType, classDatumAnalysis.getTypedModel());
        }
        return classDatumAnalysis;
    }

    @Override
    public @NonNull List<@NonNull Node> getHeadNodes() {
        return Scheduler.EMPTY_NODE_LIST;
    }

    public @Nullable Iterable<@NonNull Node> getIntroducingNodes(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        return this.introducedClassDatumAnalysis2nodes.get(classDatumAnalysis);
    }

    public @Nullable Iterable<@NonNull Node> getIntroducingOrProducingNodes(@NonNull Node headNode) {
        ClassDatumAnalysis classDatumAnalysis = headNode.getClassDatumAnalysis();
        if (classDatumAnalysis.getDomainUsage().isInput()) {
            return Collections.singletonList(this.rootContainmentRegion.getIntroducerNode(headNode));
        }
        return this.getIntroducingOrProducingNodes(classDatumAnalysis);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Iterable<@NonNull Node> getIntroducingOrProducingNodes(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        @NonNull Iterable producedNodes = this.producedClassDatumAnalysis2realizedNodes.get(classDatumAnalysis);
        if (producedNodes != null) {
            return producedNodes;
        }
        return null;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    protected @Nullable PropertyDatum getPropertyDatum(@NonNull NavigationEdge producedEdge) {
        assert (!producedEdge.isCast());
        Property property = producedEdge.getProperty();
        ClassDatumAnalysis classDatumAnalysis = producedEdge.getSource().getClassDatumAnalysis();
        ClassDatum forwardClassDatum = classDatumAnalysis.getClassDatum();
        Iterable<@NonNull PropertyDatum> forwardPropertyDatums = QVTp2QVTg.getAllPropertyDatums(forwardClassDatum);
        for (PropertyDatum propertyDatum : forwardPropertyDatums) {
            if (propertyDatum.getProperty() != property || propertyDatum.getClassDatum() != forwardClassDatum) continue;
            return propertyDatum;
        }
        ClassRelationships classRelationships = this.getSchedulerConstants().getClassRelationships();
        PropertyDatum bestPropertyDatum = null;
        for (PropertyDatum propertyDatum : forwardPropertyDatums) {
            if (propertyDatum.getProperty() != property) continue;
            if (bestPropertyDatum == null) {
                bestPropertyDatum = propertyDatum;
                continue;
            }
            Class type = propertyDatum.getClassDatum().getType();
            assert (type != null);
            Set<@NonNull Class> allSuperClasses = classRelationships.getAllSuperClasses(type);
            if (!allSuperClasses.contains(bestPropertyDatum.getClassDatum().getType())) continue;
            bestPropertyDatum = propertyDatum;
        }
        if (bestPropertyDatum != null) {
            return bestPropertyDatum;
        }
        property = property.getOpposite();
        classDatumAnalysis = producedEdge.getTarget().getClassDatumAnalysis();
        ClassDatum reverseClassDatum = classDatumAnalysis.getClassDatum();
        Iterable<@NonNull PropertyDatum> reversePropertyDatums = QVTp2QVTg.getAllPropertyDatums(reverseClassDatum);
        for (PropertyDatum propertyDatum : reversePropertyDatums) {
            if (propertyDatum.getProperty() != property || propertyDatum.getClassDatum() != reverseClassDatum) continue;
            return propertyDatum;
        }
        for (PropertyDatum propertyDatum : reversePropertyDatums) {
            if (propertyDatum.getProperty() != property) continue;
            if (bestPropertyDatum == null) {
                bestPropertyDatum = propertyDatum;
                continue;
            }
            Class type = propertyDatum.getClassDatum().getType();
            assert (type != null);
            Set<@NonNull Class> allSuperClasses = classRelationships.getAllSuperClasses(type);
            if (!allSuperClasses.contains(bestPropertyDatum.getClassDatum().getType())) continue;
            bestPropertyDatum = propertyDatum;
        }
        if (bestPropertyDatum != null) {
            return bestPropertyDatum;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Iterable<@NonNull NavigationEdge> getRealizedEdges(@NonNull NavigationEdge edge, @NonNull ClassDatumAnalysis requiredClassDatumAnalysis) {
        Property property = edge.getProperty();
        if (property.eContainer() == null) {
            return null;
        }
        PropertyDatum propertyDatum = this.getPropertyDatum(edge);
        if (propertyDatum == null) {
            if (property == this.getSchedulerConstants().getOclContainerProperty()) {
                return this.getCompositeRealizedEdges(edge);
            }
            propertyDatum = this.getPropertyDatum(edge);
        }
        assert (propertyDatum != null);
        @NonNull Iterable realizedEdges = this.producedPropertyDatum2realizedEdges.get(propertyDatum);
        if (realizedEdges == null) {
            return null;
        }
        CompleteClass requiredClass = requiredClassDatumAnalysis.getCompleteClass();
        ArrayList<NavigationEdge> conformantRealizedEdges = null;
        for (NavigationEdge realizedEdge : realizedEdges) {
            Node targetNode = realizedEdge.getTarget();
            CompleteClass realizedClass = targetNode.getCompleteClass();
            if (!realizedClass.conformsTo(requiredClass)) continue;
            if (conformantRealizedEdges == null) {
                conformantRealizedEdges = new ArrayList<NavigationEdge>();
            }
            conformantRealizedEdges.add(realizedEdge);
        }
        return conformantRealizedEdges;
    }

    @Override
    public @NonNull RootScheduledRegion getRootScheduledRegion() {
        return this;
    }

    protected boolean isOnlyCastOrRecursed(@NonNull Node predicatedNode) {
        boolean isCast = false;
        for (Edge outgoingEdge : predicatedNode.getOutgoingEdges()) {
            if (!outgoingEdge.isCast() && !outgoingEdge.isRecursion()) {
                return false;
            }
            isCast = true;
        }
        return isCast;
    }

    @Override
    public boolean isLateMergeable(@NonNull Region innerRegion, @NonNull Region2Depth region2depths) {
        return false;
    }

    @Override
    public void toCallGraph(@NonNull GraphStringBuilder s) {
        s.setLabel(this.getName());
        s.pushCluster();
        for (Region region : this.getCallableRegions()) {
            region.toCallGraph(s);
        }
        for (Connection connection : this.getConnections()) {
            connection.toRegionGraph(this, s);
        }
        s.popCluster();
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.setLabel(this.getName());
        s.pushCluster();
        for (Region region : this.getRegions()) {
            region.toGraph(s);
        }
        for (Node node : this.getNodes()) {
            s.appendNode((GraphStringBuilder.GraphNode)node);
        }
        for (Edge edge : this.getEdges()) {
            s.appendEdge((GraphStringBuilder.GraphNode)edge.getSource(), (GraphStringBuilder.GraphEdge)edge, (GraphStringBuilder.GraphNode)edge.getTarget());
        }
        for (Connection connection : this.getConnections()) {
            connection.toGraph(s);
        }
        s.popCluster();
    }

    public static final class IsPassedBindingEdgePredicate
    implements Predicate<NodeConnection> {
        public static final @NonNull IsPassedBindingEdgePredicate INSTANCE = new IsPassedBindingEdgePredicate();

        public boolean apply(@NonNull NodeConnection connection) {
            return connection.isPassed();
        }
    }

    public static final class IsUsedBindingEdgePredicate
    implements Predicate<NodeConnection> {
        public static final @NonNull IsUsedBindingEdgePredicate INSTANCE = new IsUsedBindingEdgePredicate();

        public boolean apply(@NonNull NodeConnection connection) {
            return connection.isUsed();
        }
    }
}

