/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduleState;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;

public class ScheduleIndexer
extends ScheduleState {
    public ScheduleIndexer(@NonNull RootScheduledRegion rootScheduledRegion) {
        super(rootScheduledRegion);
    }

    @Override
    protected void scheduleScheduledRegion(@NonNull ScheduledRegion scheduledRegion) {
        int regionCount = Iterables.size(scheduledRegion.getCallableRegions());
        int iRegion = 0;
        while (iRegion < regionCount) {
            Region selectedRegion = this.selectNextRegion(scheduledRegion);
            this.scheduleRegion(selectedRegion);
            ++iRegion;
        }
        if (Scheduler.DEBUG_GRAPHS.isActive()) {
            scheduledRegion.writeDebugGraphs("6-indexed", false, true, true);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Region selectNextRegion(@NonNull ScheduledRegion scheduledRegion) {
        @NonNull ArrayList unblockedRegionsList = Lists.newArrayList(this.getUnblockedRegions());
        Collections.sort(unblockedRegionsList, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull ArrayList callableRegionsList = Lists.newArrayList(this.getBlockedCallableRegions());
        Collections.sort(callableRegionsList, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull ArrayList mandatoryBlockedRegionsList = Lists.newArrayList(this.getMandatoryBlockedRegions());
        Collections.sort(mandatoryBlockedRegionsList, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull ArrayList blockedConnectionsList = Lists.newArrayList(this.getBlockedConnections());
        Collections.sort(blockedConnectionsList, NameUtil.NAMEABLE_COMPARATOR);
        if (Scheduler.REGION_ORDER.isActive()) {
            Scheduler.REGION_ORDER.println("      unblocked regions:");
            for (Region region : unblockedRegionsList) {
                Scheduler.REGION_ORDER.println("        " + region);
            }
            Scheduler.REGION_ORDER.println("      callableRegion : blockedConnectionCount:");
            for (Region region : callableRegionsList) {
                Scheduler.REGION_ORDER.println("        " + region + " : " + this.getBlockedConnectionCount(region));
            }
            Scheduler.REGION_ORDER.println("      mandatory blocked regions:");
            for (Region region : mandatoryBlockedRegionsList) {
                Scheduler.REGION_ORDER.println("        " + region);
            }
            Scheduler.REGION_ORDER.println("      blocked connections:");
            for (Connection connection : blockedConnectionsList) {
                Scheduler.REGION_ORDER.println("        " + connection);
            }
        }
        if (unblockedRegionsList.size() > 0) {
            for (Region region : unblockedRegionsList) {
                if (this.isPassed(region)) continue;
                return region;
            }
            return (Region)unblockedRegionsList.get(0);
        }
        int bestBlockedConnectionCount = Integer.MAX_VALUE;
        ArrayList<@NonNull Region> bestRegions = new ArrayList<Region>();
        for (Region region : this.getBlockedCallableRegions()) {
            if (Iterables.isEmpty(region.getOutgoingConnections())) continue;
            Integer blockedConnectionCount = this.getBlockedConnectionCount(region);
            assert (blockedConnectionCount != null);
            if (blockedConnectionCount < bestBlockedConnectionCount) {
                bestBlockedConnectionCount = blockedConnectionCount;
                bestRegions.clear();
            }
            if (blockedConnectionCount > bestBlockedConnectionCount) continue;
            bestRegions.add(region);
        }
        if (bestRegions.size() > 0) {
            Collections.sort(bestRegions, NameUtil.NAMEABLE_COMPARATOR);
            return (Region)bestRegions.get(0);
        }
        throw new IllegalStateException("Failed to schedule " + scheduledRegion);
    }
}

