/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtrelation.Key;

public class KeyToFunctionForIdentification {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull Key rKey;

    public KeyToFunctionForIdentification(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull Key rKey) {
        this.qvtr2qvtc = qvtr2qvtc;
        this.rKey = rKey;
    }

    public @NonNull Function transform() throws CompilerChainException {
        QVTcoreHelper helper = this.qvtr2qvtc.getHelper();
        String functionName = this.qvtr2qvtc.createKeyFunctionName(this.rKey);
        ArrayList<@NonNull FunctionParameter> asParameters = new ArrayList<FunctionParameter>();
        ArrayList<@NonNull ShadowPart> asShadowParts = new ArrayList<ShadowPart>();
        for (Property keyProperty : ClassUtil.nullFree((EList)this.rKey.getPart())) {
            FunctionParameter cParameter = helper.createFunctionParameter((TypedElement)keyProperty);
            asParameters.add(cParameter);
            ShadowPart asShadowPart = helper.createShadowPart(keyProperty, (OCLExpression)helper.createVariableExp((Variable)cParameter));
            asShadowParts.add(asShadowPart);
        }
        for (Property keyOppositeProperty : ClassUtil.nullFree((EList)this.rKey.getOppositePart())) {
            Property keyProperty = (Property)ClassUtil.nonNullState((Object)keyOppositeProperty.getOpposite());
            FunctionParameter cParameter = helper.createFunctionParameter((TypedElement)keyProperty);
            asParameters.add(cParameter);
            ShadowPart asShadowPart = helper.createShadowPart(keyProperty, (OCLExpression)helper.createVariableExp((Variable)cParameter));
            asShadowParts.add(asShadowPart);
        }
        Collections.sort(asParameters, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull Class identifiedClass = (Class)ClassUtil.nonNullState((Object)this.rKey.getIdentifies());
        Function cFunction = helper.createFunction(functionName, (Type)identifiedClass, true, asParameters);
        OCLExpression asShadowExp = helper.createShadowExp(identifiedClass, asShadowParts);
        cFunction.setQueryExpression(asShadowExp);
        return cFunction;
    }
}

