/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.PrimitiveLiteralExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.AssignmentComparator;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeBottomPattern;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeDomain;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.util.AbstractExtendingQVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class BasicRegion2Mapping
extends AbstractRegion2Mapping {
    private final @NonNull List<@NonNull Node> headNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> guardNodes = new ArrayList<Node>();
    private final @NonNull Map<@NonNull Node, @NonNull Variable> node2variable = new HashMap<Node, Variable>();
    private final @NonNull Map<@NonNull TypedModel, @NonNull ImperativeDomain> typedModel2domain = new HashMap<TypedModel, ImperativeDomain>();
    private final @NonNull ExpressionCreator expressionCreator;
    private final @NonNull ExpressionCreator inlineExpressionCreator = new InlineExpressionCreator();

    public BasicRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull Region region) {
        super(visitor, region);
        this.expressionCreator = new ExpressionCreator();
        String name = region.getName();
        this.createEmptyDomainsAndPatterns();
        this.createHeadAndGuardNodeVariables();
        this.createNavigablePredicates();
        this.createExternalPredicates();
        this.createRealizedVariables();
        this.createPropertyAssignments();
        this.createConnectionAssignments();
        this.createPollingDependencies();
    }

    protected void addPredicate(@NonNull Predicate asPredicate) {
        boolean isBottom = false;
        TreeIterator tit = asPredicate.eAllContents();
        while (tit.hasNext()) {
            VariableDeclaration variable;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof VariableExp) || (variable = ((VariableExp)eObject).getReferredVariable()) == null || !(variable.eContainer() instanceof BottomPattern)) continue;
            isBottom = true;
            break;
        }
        if (isBottom) {
            this.mapping.getBottomPattern().getPredicate().add((Object)asPredicate);
        } else {
            this.mapping.getGuardPattern().getPredicate().add((Object)asPredicate);
        }
    }

    private @NonNull Variable createBottomVariable(@NonNull Node node, @Nullable OCLExpression initExpression) {
        Area area = this.getArea(node.getClassDatumAnalysis());
        Class variableType = node.getCompleteClass().getPrimaryClass();
        assert (variableType != null);
        boolean isRequired = true;
        for (TypedElement typedElement : node.getTypedElements()) {
            if (typedElement.isIsRequired()) continue;
            isRequired = false;
        }
        if (initExpression != null && initExpression.isIsRequired()) {
            isRequired = true;
        }
        Variable variable = PivotUtil.createVariable((String)this.getSafeName(node), (Type)variableType, (boolean)isRequired, null);
        BottomPattern bottomPattern = area.getBottomPattern();
        bottomPattern.getVariable().add((Object)variable);
        if (initExpression != null) {
            VariableAssignment variableAssignment = this.helper.createVariableAssignment(variable, initExpression);
            this.mapping.getBottomPattern().getAssignment().add((Object)variableAssignment);
        }
        Variable oldVariable = this.node2variable.put(node, variable);
        assert (oldVariable == null);
        return variable;
    }

    private void createClassPropertyAssignments(@NonNull Iterable<@NonNull List<@NonNull NavigationEdge>> classAssignments) {
        for (List<NavigationEdge> edges : classAssignments) {
            for (NavigationEdge edge : edges) {
                Node sourceNode = edge.getSource();
                Node targetNode = edge.getTarget();
                OCLExpression slotVariableExp = this.createVariableExp(sourceNode);
                Property property = edge.getProperty();
                OCLExpression targetVariableExp = this.createVariableExp(targetNode);
                PropertyAssignment propertyAssignment = QVTimperativeUtil.createPropertyAssignment((OCLExpression)slotVariableExp, (Property)property, (OCLExpression)targetVariableExp);
                this.mapping.getBottomPattern().getAssignment().add((Object)propertyAssignment);
            }
        }
    }

    private void createConnectionAssignments() {
        if (this.connection2variable != null) {
            for (NodeConnection connection : this.connection2variable.keySet()) {
                Node sourceNode = connection.getSource(this.region);
                OCLExpression variableExpression = this.createVariableExp(sourceNode);
                ConnectionVariable connectionVariable = (ConnectionVariable)this.connection2variable.get(connection);
                assert (connectionVariable != null);
                this.createConnectionAssignment(connectionVariable, variableExpression);
            }
        }
    }

    private void createEmptyDomainsAndPatterns() {
        ImperativeDomain oldDomain;
        ImperativeDomain domain;
        HashSet<@NonNull TypedModel> checkableTypedModels = new HashSet<TypedModel>();
        HashSet<@NonNull TypedModel> enforceableTypedModels = new HashSet<TypedModel>();
        for (Node node : this.region.getNodes()) {
            TypedModel qvtiTypedModel;
            ClassDatumAnalysis classDatumAnalysis = node.getClassDatumAnalysis();
            Class type = classDatumAnalysis.getClassDatum().getType();
            if (type instanceof DataType || type instanceof AnyType || type instanceof VoidType || type instanceof InvalidType) continue;
            DomainUsage domainUsage = classDatumAnalysis.getDomainUsage();
            if (domainUsage.isInput()) {
                for (TypedModel typedModel : domainUsage.getTypedModels()) {
                    qvtiTypedModel = this.visitor.getQVTiTypedModel(typedModel);
                    assert (qvtiTypedModel != null);
                    checkableTypedModels.add(qvtiTypedModel);
                }
            }
            if (!domainUsage.isOutput()) continue;
            for (TypedModel typedModel : domainUsage.getTypedModels()) {
                qvtiTypedModel = this.visitor.getQVTiTypedModel(typedModel);
                assert (qvtiTypedModel != null);
                enforceableTypedModels.add(qvtiTypedModel);
            }
        }
        checkableTypedModels.removeAll(enforceableTypedModels);
        for (TypedModel qvtiTypedModel : checkableTypedModels) {
            domain = QVTimperativeUtil.createImperativeDomain((TypedModel)qvtiTypedModel);
            domain.setIsCheckable(true);
            this.mapping.getDomain().add((Object)domain);
            oldDomain = this.typedModel2domain.put(qvtiTypedModel, domain);
            assert (oldDomain == null);
        }
        for (TypedModel qvtiTypedModel : enforceableTypedModels) {
            domain = QVTimperativeUtil.createImperativeDomain((TypedModel)qvtiTypedModel);
            domain.setIsEnforceable(true);
            this.mapping.getDomain().add((Object)domain);
            oldDomain = this.typedModel2domain.put(qvtiTypedModel, domain);
            assert (oldDomain == null);
        }
        ECollections.sort((EList)ClassUtil.nullFree((EList)this.mapping.getDomain()), (Comparator)DomainNameComparator.INSTANCE);
    }

    private void createExternalPredicates() {
        for (Node node : this.region.getNodes()) {
            if (!node.isTrue()) continue;
            for (Edge edge : node.getArgumentEdges()) {
                Node predicateNode = edge.getSource();
                for (TypedElement typedElement : predicateNode.getTypedElements()) {
                    OCLExpression conditionExpression = (OCLExpression)typedElement.accept((Visitor)this.inlineExpressionCreator);
                    Predicate asPredicate = QVTbaseFactory.eINSTANCE.createPredicate();
                    asPredicate.setConditionExpression(conditionExpression);
                    this.addPredicate(asPredicate);
                }
            }
        }
    }

    private @NonNull Variable createGuardVariable(@NonNull Node guardNode) {
        Area area = this.getArea(guardNode.getClassDatumAnalysis());
        GuardPattern guardPattern = area.getGuardPattern();
        assert (guardPattern != null);
        Class variableType = guardNode.getCompleteClass().getPrimaryClass();
        Variable guardVariable = PivotUtil.createVariable((String)this.getSafeName(guardNode), (Type)variableType, (boolean)true, null);
        guardPattern.getVariable().add((Object)guardVariable);
        Variable oldVariable = this.node2variable.put(guardNode, guardVariable);
        assert (oldVariable == null);
        return guardVariable;
    }

    private void createHeadAndGuardNodeVariables() {
        HashSet<@NonNull Region> headCallingRegions = new HashSet<Region>();
        Iterable<@NonNull Edge> recursionEdges = this.region.getRecursionEdges();
        if (Iterables.size(recursionEdges) > 0) {
            headCallingRegions.add(this.region);
        }
        for (Node headNode : this.region.getHeadNodes()) {
            Node bestHeadNode = null;
            boolean isExtraGuard = false;
            Iterable<@NonNull Node> callingSources = headNode.getPassedBindingSources();
            if (!Iterables.isEmpty(callingSources)) {
                bestHeadNode = headNode;
            } else if (headNode.getNodeRole().isExtraGuardVariable()) {
                isExtraGuard = true;
            }
            for (Node callingSource : callingSources) {
                headCallingRegions.add(callingSource.getRegion());
            }
            if (bestHeadNode != null) {
                this.headNodes.add(bestHeadNode);
                continue;
            }
            if (isExtraGuard) continue;
            System.err.println("No best head for " + this.region);
        }
        this.guardNodes.addAll(this.headNodes);
        for (Node guardNode : this.region.getGuardNodes()) {
            NodeConnection connection;
            if (this.guardNodes.contains(guardNode) || (connection = guardNode.getIncomingUsedConnection()) == null) continue;
            HashSet<Region> guardCallingRegions = new HashSet<Region>();
            boolean canBeGuard = true;
            for (Node callingSource : guardNode.getUsedBindingSources()) {
                if (callingSource.getNodeRole().isComposed()) {
                    canBeGuard = false;
                    break;
                }
                guardCallingRegions.add(callingSource.getRegion());
            }
            for (Node recursionSource : guardNode.getRecursionSources()) {
                guardCallingRegions.add(recursionSource.getRegion());
            }
            if (!canBeGuard || !guardCallingRegions.containsAll(headCallingRegions) || !guardCallingRegions.contains(connection.getCommonRegion()) || this.guardNodes.contains(guardNode)) continue;
            this.guardNodes.add(guardNode);
        }
        Collections.sort(this.guardNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node guardNode : this.guardNodes) {
            this.createGuardVariable(guardNode);
        }
        this.createConnectionGuardVariables();
    }

    private void createMappingStatements(@NonNull Map<@NonNull Region, @NonNull Map<@NonNull Node, @NonNull Node>> calls) {
        MappingStatement mappingStatement = null;
        HashMap<@NonNull Variable, @NonNull OCLExpression> loopVariables = null;
        for (Map.Entry<Region, Map<Node, Node>> entry : calls.entrySet()) {
            @NonNull Region calledRegion = entry.getKey();
            AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
            ArrayList<@NonNull MappingCallBinding> mappingCallBindings = new ArrayList<MappingCallBinding>();
            for (Map.Entry<Node, Node> entry2 : entry.getValue().entrySet()) {
                @NonNull Node sourceNode = entry2.getKey();
                @NonNull Node targetNode = entry2.getValue();
                OCLExpression sourceExpression = this.getSourceExpression(sourceNode);
                Type type = sourceExpression.getType();
                if (type instanceof CollectionType) {
                    if (loopVariables == null) {
                        loopVariables = new HashMap<Variable, OCLExpression>();
                    }
                    Type elementType = ((CollectionType)type).getElementType();
                    assert (elementType != null);
                    Variable loopVariable = PivotUtil.createVariable((String)("loop" + loopVariables.size()), (Type)elementType, (boolean)true, (OCLExpression)sourceExpression);
                    loopVariables.put(loopVariable, sourceExpression);
                    sourceExpression = PivotUtil.createVariableExp((Variable)loopVariable);
                }
                Variable guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
                mappingCallBindings.add(QVTimperativeUtil.createMappingCallBinding((Variable)guardVariable, (OCLExpression)sourceExpression));
            }
            Collections.sort(mappingCallBindings, QVTimperativeUtil.MappingCallBindingComparator.INSTANCE);
            MappingCall mappingCallStatement = calledRegion2Mapping.createMappingCall(mappingCallBindings);
            if (loopVariables != null) {
                for (Map.Entry loopEntry : loopVariables.entrySet()) {
                    @NonNull Variable loopVariable = (Variable)loopEntry.getKey();
                    @NonNull OCLExpression loopSource = (OCLExpression)loopEntry.getValue();
                    mappingCallStatement = QVTimperativeUtil.createMappingLoop((OCLExpression)loopSource, (Variable)loopVariable, (MappingStatement)mappingCallStatement);
                }
            }
            mappingStatement = QVTimperativeUtil.addMappingStatement(mappingStatement, (MappingStatement)mappingCallStatement);
        }
        this.mapping.setMappingStatement(mappingStatement);
    }

    private void createNavigablePredicates() {
        OCLExpression sourceExp;
        Property property;
        NavigationEdge oppositeEdge;
        Node targetNode;
        Node sourceNode;
        String name = this.region.getName();
        HashSet<@NonNull NavigationEdge> backwardEdges = new HashSet<NavigationEdge>();
        HashSet<@NonNull NavigationEdge> forwardEdges = new HashSet<NavigationEdge>();
        HashSet<@NonNull Object> navigableNodes = new HashSet<Object>();
        HashSet<@NonNull NavigationEdge> untraversedEdges = new HashSet<NavigationEdge>();
        for (NavigationEdge edge : this.region.getNavigationEdges()) {
            if (edge.isRealized() || !edge.isNavigable() || edge.isCast()) continue;
            assert (!edge.isArgument());
            assert (!edge.isComputation());
            Node sourceNode2 = edge.getSource();
            navigableNodes.add(sourceNode2);
            Object targetNode2 = edge.getTarget();
            if (targetNode2.isNull()) {
                untraversedEdges.add(edge);
                continue;
            }
            targetNode2 = RegionUtil.getCastTarget((Node)targetNode2);
            Property property2 = edge.getProperty();
            if (property2.isIsImplicit()) {
                backwardEdges.add(edge);
                navigableNodes.add(targetNode2);
                continue;
            }
            forwardEdges.add(edge);
            navigableNodes.add(targetNode2);
        }
        final HashMap<@NonNull NavigationEdge, @NonNull Integer> traversedEdge2depth = new HashMap<NavigationEdge, Integer>();
        HashMap<@NonNull Node, @Nullable NavigationEdge> traversedNode2incomingEdge = new HashMap<Node, NavigationEdge>();
        for (Node guardNode : this.guardNodes) {
            traversedNode2incomingEdge.put(guardNode, null);
        }
        HashSet<@NonNull Node> moreNodes = new HashSet<Node>(this.guardNodes);
        int depth = 0;
        while (moreNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node node : moreNodes) {
                for (NavigationEdge edge : node.getNavigationEdges()) {
                    if (!forwardEdges.contains(edge)) continue;
                    Node targetNode3 = RegionUtil.getCastTarget(edge.getTarget());
                    if (!traversedNode2incomingEdge.containsKey(targetNode3)) {
                        traversedNode2incomingEdge.put(targetNode3, edge);
                        moreMoreNodes.add(targetNode3);
                        traversedEdge2depth.put(edge, depth);
                        continue;
                    }
                    untraversedEdges.add(edge);
                }
            }
            if (moreMoreNodes.isEmpty() && traversedNode2incomingEdge.size() < navigableNodes.size()) {
                for (NavigationEdge navigationEdge : backwardEdges) {
                    sourceNode = navigationEdge.getSource();
                    if (!traversedNode2incomingEdge.containsKey(sourceNode) || traversedNode2incomingEdge.containsKey(targetNode = navigationEdge.getTarget())) continue;
                    traversedNode2incomingEdge.put(targetNode, navigationEdge);
                    moreMoreNodes.add(targetNode);
                    traversedEdge2depth.put(navigationEdge, depth);
                    break;
                }
            }
            moreNodes = moreMoreNodes;
            ++depth;
        }
        for (NavigationEdge edge : forwardEdges) {
            if (traversedEdge2depth.containsKey(edge) || (oppositeEdge = this.getOppositeEdge(edge)) != null && traversedEdge2depth.containsKey(oppositeEdge)) continue;
            untraversedEdges.add(edge);
        }
        for (NavigationEdge edge : backwardEdges) {
            if (traversedEdge2depth.containsKey(edge) || untraversedEdges.contains(edge) || (oppositeEdge = this.getOppositeEdge(edge)) != null && (traversedEdge2depth.containsKey(oppositeEdge) || untraversedEdges.contains(edge))) continue;
            untraversedEdges.add(edge);
        }
        ArrayList<@NonNull K> traversedEdges = new ArrayList(traversedEdge2depth.keySet());
        Collections.sort(traversedEdges, new Comparator<NavigationEdge>(){

            @Override
            public int compare(@NonNull NavigationEdge o1, @NonNull NavigationEdge o2) {
                Integer d1 = (Integer)traversedEdge2depth.get(o1);
                Integer d2 = (Integer)traversedEdge2depth.get(o2);
                if (!($assertionsDisabled || d1 != null && d2 != null)) {
                    throw new AssertionError();
                }
                if (d1 != d2) {
                    return d1 - d2;
                }
                String n1 = o1.getDisplayName();
                String n2 = o2.getDisplayName();
                return n1.compareTo(n2);
            }
        });
        for (NavigationEdge navigationEdge : traversedEdges) {
            sourceNode = navigationEdge.getSource();
            targetNode = navigationEdge.getTarget();
            property = navigationEdge.getProperty();
            sourceExp = this.createVariableExp(sourceNode);
            CallExp source2targetExp = this.createCallExp(sourceExp, property);
            if (targetNode.isAttributeNode()) {
                Variable attributeVariable = this.node2variable.get(targetNode);
                assert (attributeVariable == null);
                this.createBottomVariable(targetNode, (OCLExpression)source2targetExp);
                continue;
            }
            Variable classVariable = this.node2variable.get(targetNode);
            assert (classVariable == null);
            this.createBottomVariable(targetNode, (OCLExpression)source2targetExp);
        }
        for (NavigationEdge navigationEdge : untraversedEdges) {
            sourceNode = navigationEdge.getSource();
            targetNode = navigationEdge.getTarget();
            property = navigationEdge.getProperty();
            sourceExp = this.createVariableExp(sourceNode);
            OCLExpression targetExp = this.createVariableExp(targetNode);
            CallExp source2targetExp = this.createCallExp(sourceExp, property);
            OperationCallExp matchesExp = targetNode.isNull() ? this.helper.createOperationCallExp((OCLExpression)source2targetExp, "=", new OCLExpression[]{targetExp}) : this.helper.createOperationCallExp(targetExp, "=", new OCLExpression[]{source2targetExp});
            Predicate asPredicate = QVTbaseFactory.eINSTANCE.createPredicate();
            asPredicate.setConditionExpression((OCLExpression)matchesExp);
            this.addPredicate(asPredicate);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createPollingDependencies() {
        RootDomainUsageAnalysis.DomainUsageConstant anyUsage = this.region.getSchedulerConstants().getDomainAnalysis().getAnyUsage();
        for (TypedModel qvtpTypedModel : anyUsage.getTypedModels()) {
            Iterable<NavigationEdge> enforcedEdges;
            TypedModel qvtiTypedModel = this.visitor.getQVTiTypedModel(qvtpTypedModel);
            ImperativeDomain domain = this.typedModel2domain.get(qvtiTypedModel);
            ImperativeDomain imperativeArea = domain != null ? domain : this.mapping;
            Iterable<@NonNull NavigationEdge> checkedEdges = this.region.getCheckedEdges(qvtpTypedModel);
            if (checkedEdges != null) {
                EList checkedProperties = imperativeArea.getCheckedProperties();
                for (NavigationEdge checkedEdge : checkedEdges) {
                    checkedProperties.add(checkedEdge.getProperty());
                }
            }
            if ((enforcedEdges = this.region.getEnforcedEdges(qvtpTypedModel)) == null) continue;
            @NonNull EList enforcedProperties = ClassUtil.nullFree((EList)imperativeArea.getEnforcedProperties());
            for (NavigationEdge enforcedEdge : enforcedEdges) {
                enforcedProperties.add(enforcedEdge.getProperty());
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createPropertyAssignments() {
        HashMap<@NonNull Node, @NonNull ArrayList<@NonNull NavigationEdge>> classAssignments = null;
        ImperativeBottomPattern bottomPattern = (ImperativeBottomPattern)this.mapping.getBottomPattern();
        for (NavigationEdge edge : this.region.getRealizedNavigationEdges()) {
            ArrayList<NavigationEdge> edges;
            Node sourceNode = edge.getSource();
            Node targetNode = edge.getTarget();
            if (targetNode.isAttributeNode()) {
                OCLExpression slotVariableExp = this.createVariableExp(sourceNode);
                Property property = edge.getProperty();
                OCLExpression valueExp = this.expressionCreator.getExpression(targetNode);
                if (valueExp == null) {
                    valueExp = this.expressionCreator.getExpression(targetNode);
                }
                if (valueExp != null) {
                    PropertyAssignment propertyAssignment = QVTimperativeUtil.createPropertyAssignment((OCLExpression)slotVariableExp, (Property)property, (OCLExpression)valueExp);
                    bottomPattern.getAssignment().add((Object)propertyAssignment);
                    continue;
                }
                System.err.println("No assignment in " + this + " to " + slotVariableExp);
                continue;
            }
            if (classAssignments == null) {
                classAssignments = new HashMap<Node, ArrayList<NavigationEdge>>();
            }
            if ((edges = (ArrayList<NavigationEdge>)classAssignments.get(sourceNode)) == null) {
                edges = new ArrayList<NavigationEdge>();
                classAssignments.put(sourceNode, edges);
            }
            edges.add(edge);
        }
        if (classAssignments != null) {
            this.pruneClassAssignments(classAssignments);
            Collection<@NonNull List<@NonNull NavigationEdge>> values = classAssignments.values();
            this.createClassPropertyAssignments(values);
        }
        @NonNull @NonNull EList bottomAssignments = bottomPattern.getOrderedAssignment();
        ECollections.sort((EList)bottomAssignments, (Comparator)new AssignmentComparator((List)bottomAssignments));
    }

    private void createRealizedVariables() {
        for (Node node : this.region.getRealizedVariableNodes()) {
            OCLExpression constructor = null;
            for (Edge edge : node.getIncomingEdges()) {
                Node sourceNode;
                if (!edge.isResult() || !(sourceNode = edge.getSource()).isOperation()) continue;
                constructor = (OCLExpression)((OperationCallExp)sourceNode.getTypedElements().iterator().next()).accept((Visitor)this.expressionCreator);
            }
            ClassDatumAnalysis classDatumAnalysis = node.getClassDatumAnalysis();
            BottomPattern bottomPattern = this.getArea(classDatumAnalysis).getBottomPattern();
            RealizedVariable realizedVariable = QVTimperativeUtil.createRealizedVariable((String)this.getSafeName(node), (Type)classDatumAnalysis.getCompleteClass().getPrimaryClass());
            realizedVariable.setOwnedInit(constructor);
            bottomPattern.getRealizedVariable().add((Object)realizedVariable);
            Variable oldVariable = this.node2variable.put(node, (Variable)realizedVariable);
            assert (oldVariable == null);
        }
    }

    @Override
    public void createStatements() {
        HashMap<@NonNull Region, @NonNull HashMap<@NonNull K, @NonNull V>> calls = null;
        for (Region calledRegion : this.region.getCallableChildren()) {
            HashMap<Node, Node> source2target;
            if (calls == null) {
                calls = new HashMap();
            }
            if ((source2target = (HashMap<Node, Node>)calls.get(calledRegion)) == null) {
                source2target = new HashMap<Node, Node>();
                calls.put(calledRegion, source2target);
            }
            AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
            for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
                Node oldNode;
                for (Node callingNode : calledGuardNode.getPassedBindingSources()) {
                    if (callingNode.getRegion() != this.region) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
                for (Node callingNode : calledGuardNode.getUsedBindingSources()) {
                    if (callingNode.getRegion() != this.region) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
            }
        }
        if (calls != null) {
            this.createMappingStatements(calls);
        }
    }

    private @NonNull OCLExpression createVariableExp(@NonNull Node node) {
        if (node.isNull()) {
            return this.helper.createNullLiteralExp();
        }
        Variable variable = this.node2variable.get(node);
        if (variable == null) {
            for (Edge edge : node.getIncomingEdges()) {
                if (!edge.isArgument() && !edge.isCast()) continue;
                OCLExpression initExpression = (OCLExpression)edge.getSource().getTypedElements().iterator().next().accept((Visitor)this.expressionCreator);
                variable = this.createBottomVariable(node, initExpression);
                break;
            }
        }
        if (variable == null) {
            for (Edge edge : node.getIncomingEdges()) {
                boolean isPredicated = edge.isPredicated();
                boolean isNavigable = edge.isNavigable();
                boolean isNavigation = edge.isNavigation();
                if (!isPredicated || isNavigable || !isNavigation) continue;
                OCLExpression initExpression = (OCLExpression)edge.getSource().getTypedElements().iterator().next().accept((Visitor)this.expressionCreator);
                variable = this.createBottomVariable(node, initExpression);
                break;
            }
        }
        if (variable == null) {
            System.err.println("Creating dummy variable for " + node + " in " + this.region);
            BottomPattern bottomPattern = this.mapping.getBottomPattern();
            assert (bottomPattern != null);
            Class variableType = node.getCompleteClass().getPrimaryClass();
            assert (variableType != null);
            variable = PivotUtil.createVariable((String)this.getSafeName(node), (Type)variableType, (boolean)false, null);
            bottomPattern.getVariable().add((Object)variable);
            Variable oldVariable = this.node2variable.put(node, variable);
            assert (oldVariable == null);
        }
        return PivotUtil.createVariableExp((Variable)variable);
    }

    private @NonNull Area getArea(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        TypedModel qvtpTypedModel = classDatumAnalysis.getTypedModel();
        ImperativeDomain coreDomain = this.typedModel2domain.get(qvtpTypedModel);
        if (coreDomain != null) {
            return coreDomain;
        }
        TypedModel qvtiTypedModel = this.visitor.qvtpTypedModel2qvtiTypedModel.get(qvtpTypedModel);
        coreDomain = this.typedModel2domain.get(qvtiTypedModel);
        if (coreDomain != null) {
            return coreDomain;
        }
        return this.mapping;
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return this.guardNodes;
    }

    @Override
    public @NonNull Variable getGuardVariable(@NonNull Node node) {
        Variable variable = this.node2variable.get(node);
        assert (variable != null);
        return variable;
    }

    private @Nullable NavigationEdge getOppositeEdge(@NonNull NavigationEdge edge) {
        Node targetNode = edge.getTarget();
        Property property = edge.getProperty();
        Property oppositeProperty = property.getOpposite();
        if (oppositeProperty == null) {
            return null;
        }
        NavigationEdge oppositeEdge = targetNode.getNavigationEdge(oppositeProperty);
        if (oppositeEdge == null) {
            return null;
        }
        assert (oppositeEdge.getTarget() == edge.getSource());
        return oppositeEdge;
    }

    private @NonNull OCLExpression getSourceExpression(@NonNull Node sourceNode) {
        return this.createVariableExp(sourceNode);
    }

    public @Nullable Variable getVariable(@NonNull Node node) {
        return this.node2variable.get(node);
    }

    private boolean isIfExp(@NonNull Node node) {
        if (node.isExpression()) {
            for (TypedElement typedElement : node.getTypedElements()) {
                if (!(typedElement instanceof IfExp)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInfinite() {
        return this.region.getRecursionEdges().iterator().hasNext();
    }

    private void pruneClassAssignments(@NonNull Map<@NonNull Node, @NonNull List<@NonNull NavigationEdge>> classAssignments) {
        for (Node sourceNode : new ArrayList<Node>(classAssignments.keySet())) {
            List<@NonNull NavigationEdge> forwardEdges = classAssignments.get(sourceNode);
            assert (forwardEdges != null);
            int iForward = forwardEdges.size() - 1;
            while (iForward >= 0) {
                NavigationEdge forwardEdge = forwardEdges.get(iForward);
                Node targetNode = forwardEdge.getTarget();
                List<@NonNull NavigationEdge> reverseEdges = classAssignments.get(targetNode);
                if (reverseEdges != null) {
                    int iReverse = reverseEdges.size() - 1;
                    while (iReverse >= 0) {
                        NavigationEdge reverseEdge = reverseEdges.get(iReverse);
                        if (sourceNode == reverseEdge.getTarget()) {
                            Property forwardProperty = forwardEdge.getProperty();
                            Property reverseProperty = reverseEdge.getProperty();
                            if (forwardProperty.getOpposite() == reverseProperty) {
                                if (forwardProperty.isIsImplicit()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (reverseProperty.isIsImplicit()) {
                                    reverseEdges.remove(reverseEdge);
                                } else if (sourceNode.isInternal()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (targetNode.isInternal()) {
                                    reverseEdges.remove(reverseEdge);
                                } else {
                                    reverseEdges.remove(reverseEdge);
                                }
                            }
                        }
                        --iReverse;
                    }
                }
                --iForward;
            }
        }
    }

    private static final class DomainNameComparator
    implements Comparator<Domain> {
        public static final @NonNull DomainNameComparator INSTANCE = new DomainNameComparator();

        private DomainNameComparator() {
        }

        @Override
        public int compare(@NonNull Domain o1, @NonNull Domain o2) {
            TypedModel t1 = o1.getTypedModel();
            TypedModel t2 = o2.getTypedModel();
            String n1 = t1 != null ? t1.getName() : null;
            String n2 = t2 != null ? t2.getName() : null;
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    private class ExpressionCreator
    extends AbstractExtendingQVTimperativeVisitor<OCLExpression, BasicRegion2Mapping> {
        protected final @NonNull Set<@NonNull Node> multiAccessedNodes;
        protected final @NonNull Set<@NonNull Node> conditionalNodes;

        public ExpressionCreator() {
            super((Object)BasicRegion2Mapping.this);
            this.multiAccessedNodes = new HashSet<Node>();
            this.conditionalNodes = new HashSet<Node>();
            this.analyzeExpressions(this.multiAccessedNodes, this.conditionalNodes);
        }

        private void analyzeExpressions(@NonNull Set<Node> multiAccessedNodes, @NonNull Set<Node> conditionalNodes) {
            HashSet<@NonNull Node> unconditionalNodes = new HashSet<Node>();
            for (Edge edge : BasicRegion2Mapping.this.region.getRealizedEdges()) {
                this.analyzeIncomingPath(edge.getTarget(), unconditionalNodes, conditionalNodes, false);
            }
            conditionalNodes.removeAll(unconditionalNodes);
            for (Node node : unconditionalNodes) {
                int accesses = 0;
                for (Edge outgoingEdge : node.getOutgoingEdges()) {
                    if (!outgoingEdge.isNavigation() && !outgoingEdge.isComputation()) continue;
                    ++accesses;
                }
                if (accesses <= true) continue;
                multiAccessedNodes.add(node);
            }
        }

        private void analyzeIncomingPath(@NonNull Node node, @NonNull Set<Node> unconditionalNodes, @NonNull Set<Node> conditionalNodes, boolean isConditional) {
            if ((isConditional ? conditionalNodes : unconditionalNodes).add(node)) {
                boolean isIf = BasicRegion2Mapping.this.isIfExp(node);
                for (Edge edge : node.getIncomingEdges()) {
                    if (edge.isComputation()) {
                        boolean isIfThenOrElse = isIf && ("then".equals(edge.getName()) || "else".equals(edge.getName()));
                        this.analyzeIncomingPath(edge.getSource(), unconditionalNodes, conditionalNodes, isConditional || isIfThenOrElse);
                        continue;
                    }
                    if (!edge.isNavigation()) continue;
                    this.analyzeIncomingPath(edge.getSource(), unconditionalNodes, conditionalNodes, isConditional);
                }
                return;
            }
        }

        protected @NonNull OCLExpression create(Node node) {
            if (node.isNull()) {
                return BasicRegion2Mapping.this.helper.createNullLiteralExp();
            }
            Variable theVariable = (Variable)BasicRegion2Mapping.this.node2variable.get(node);
            if (theVariable == null) {
                TypedElement oldTypedElement = node.getTypedElements().iterator().next();
                assert (oldTypedElement != null);
                OCLExpression initExpression = (OCLExpression)oldTypedElement.accept((Visitor)this);
                assert (initExpression != null);
                if (initExpression instanceof PrimitiveLiteralExp || this.hasRealizedVariableReference(initExpression) || this.conditionalNodes.contains(node)) {
                    return initExpression;
                }
                theVariable = BasicRegion2Mapping.this.createBottomVariable(node, initExpression);
            }
            return PivotUtil.createVariableExp((Variable)theVariable);
        }

        private @Nullable OCLExpression create(@Nullable OCLExpression oldTypedElement) {
            if (oldTypedElement == null) {
                return null;
            }
            Node node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            if (node == null) {
                node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            }
            if (node != null) {
                return this.create(node);
            }
            return (OCLExpression)oldTypedElement.accept((Visitor)this);
        }

        private @NonNull List<@NonNull OCLExpression> createAll(@NonNull List<@NonNull OCLExpression> oldTypedElements) {
            ArrayList<@NonNull OCLExpression> newTypedElements = new ArrayList<OCLExpression>(oldTypedElements.size());
            for (OCLExpression oldTypedElement : oldTypedElements) {
                OCLExpression newTypedElement = this.create(oldTypedElement);
                assert (newTypedElement != null);
                newTypedElements.add(newTypedElement);
            }
            return newTypedElements;
        }

        private @NonNull OCLExpression createNonNull(@Nullable OCLExpression oldTypedElement) {
            assert (oldTypedElement != null);
            Node node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            if (node == null) {
                node = ((BasicRegion2Mapping)this.context).getNode((TypedElement)oldTypedElement);
            }
            return this.create(node);
        }

        private @NonNull List<@NonNull Variable> createVariables(@NonNull List<@NonNull Variable> oldVariables) {
            ArrayList<@NonNull Variable> newVariables = new ArrayList<Variable>(oldVariables.size());
            for (Variable oldVariable : oldVariables) {
                Variable newVariable = this.createVariable(oldVariable);
                newVariables.add(newVariable);
            }
            return newVariables;
        }

        private @NonNull Variable createVariable(@NonNull Variable oldVariable) {
            String name = oldVariable.getName();
            assert (name != null);
            Type type = oldVariable.getType();
            assert (type != null);
            Variable newVariable = PivotUtil.createVariable((String)name, (Type)type, (boolean)oldVariable.isIsRequired(), (OCLExpression)this.create(oldVariable.getOwnedInit()));
            Node variableNode = BasicRegion2Mapping.this.getNode((TypedElement)oldVariable);
            if (variableNode != null) {
                BasicRegion2Mapping.this.node2variable.put(variableNode, newVariable);
            }
            return newVariable;
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " " + BasicRegion2Mapping.this.region;
        }

        public @NonNull OCLExpression visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public @Nullable OCLExpression getExpression(@NonNull Node node) {
            if (node.isNull()) {
                return BasicRegion2Mapping.this.helper.createNullLiteralExp();
            }
            Variable variable = (Variable)BasicRegion2Mapping.this.node2variable.get(node);
            if (variable != null) {
                return PivotUtil.createVariableExp((Variable)variable);
            }
            Iterator<Edge> iterator = node.getArgumentEdges().iterator();
            if (iterator.hasNext()) {
                VariableDeclaration referredVariable;
                @NonNull Edge edge = iterator.next();
                Node expNode = edge.getSource();
                OCLExpression clonedElement = this.create(expNode);
                if (clonedElement instanceof VariableExp && (referredVariable = ((VariableExp)clonedElement).getReferredVariable()) instanceof Variable) {
                    BasicRegion2Mapping.this.node2variable.put(node, (Variable)referredVariable);
                }
                return clonedElement;
            }
            for (Edge edge : node.getIncomingEdges()) {
                OCLExpression source;
                EdgeRole edgeRole = edge.getEdgeRole();
                if (!edgeRole.isNavigation()) continue;
                if (edgeRole.isLoaded()) {
                    source = this.getExpression(edge.getSource());
                    if (source == null) continue;
                    return PivotUtil.createNavigationCallExp((OCLExpression)source, (Property)((NavigationEdge)edge).getProperty());
                }
                if (!edgeRole.isPredicated()) continue;
                source = this.create(edge.getSource());
                return PivotUtil.createNavigationCallExp((OCLExpression)source, (Property)((NavigationEdge)edge).getProperty());
            }
            return null;
        }

        private boolean hasRealizedVariableReference(@NonNull OCLExpression oclExpression) {
            TreeIterator tit = oclExpression.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof VariableExp) || !(((VariableExp)eObject).getReferredVariable() instanceof RealizedVariable)) continue;
                return true;
            }
            return false;
        }

        public @NonNull OCLExpression visitCollectionLiteralExp(@NonNull CollectionLiteralExp pCollectionLiteralExp) {
            ArrayList<@NonNull Object> clonedParts = new ArrayList<Object>();
            for (CollectionLiteralPart pPart : ClassUtil.nullFree((List)pCollectionLiteralExp.getOwnedParts())) {
                if (pPart instanceof CollectionItem) {
                    OCLExpression item = this.createNonNull(((CollectionItem)pPart).getOwnedItem());
                    clonedParts.add(BasicRegion2Mapping.this.helper.createCollectionItem(item));
                    continue;
                }
                CollectionRange pCollectionRange = (CollectionRange)pPart;
                OCLExpression first = this.createNonNull(pCollectionRange.getOwnedFirst());
                OCLExpression last = this.createNonNull(pCollectionRange.getOwnedLast());
                clonedParts.add(BasicRegion2Mapping.this.helper.createCollectionRange(first, last));
            }
            CollectionType collectionType = (CollectionType)pCollectionLiteralExp.getType();
            assert (collectionType != null);
            return BasicRegion2Mapping.this.helper.createCollectionLiteralExp(collectionType, clonedParts);
        }

        public @NonNull OCLExpression visitIfExp(@NonNull IfExp pIfExp) {
            PivotMetamodelManager metamodelManager = (PivotMetamodelManager)BasicRegion2Mapping.this.visitor.getMetamodelManager();
            return metamodelManager.createIfExp(this.createNonNull(pIfExp.getOwnedCondition()), BasicRegion2Mapping.this.inlineExpressionCreator.createNonNull(pIfExp.getOwnedThen()), BasicRegion2Mapping.this.inlineExpressionCreator.createNonNull(pIfExp.getOwnedElse()));
        }

        public @NonNull OCLExpression visitIterateExp(@NonNull IterateExp pIterateExp) {
            OCLExpression iSource = this.create(pIterateExp.getOwnedSource());
            assert (iSource != null);
            List<@NonNull Variable> iIterators = this.createVariables(ClassUtil.nullFree((List)pIterateExp.getOwnedIterators()));
            Variable result = this.createVariable((Variable)ClassUtil.nonNull((Object)pIterateExp.getOwnedResult()));
            Iteration referredIteration = (Iteration)BasicRegion2Mapping.this.visitor.create((Operation)pIterateExp.getReferredIteration());
            assert (referredIteration != null);
            OCLExpression iBody = BasicRegion2Mapping.this.inlineExpressionCreator.create(pIterateExp.getOwnedBody());
            assert (iBody != null);
            return BasicRegion2Mapping.this.helper.createIterateExp(iSource, referredIteration, iIterators, result, iBody);
        }

        public @NonNull OCLExpression visitIteratorExp(@NonNull IteratorExp pIteratorExp) {
            OCLExpression iSource = this.create(pIteratorExp.getOwnedSource());
            assert (iSource != null);
            List<@NonNull Variable> iIterators = this.createVariables(ClassUtil.nullFree((List)pIteratorExp.getOwnedIterators()));
            Iteration referredIteration = (Iteration)BasicRegion2Mapping.this.visitor.create((Operation)pIteratorExp.getReferredIteration());
            assert (referredIteration != null);
            OCLExpression iBody = BasicRegion2Mapping.this.inlineExpressionCreator.create(pIteratorExp.getOwnedBody());
            assert (iBody != null);
            return BasicRegion2Mapping.this.helper.createIteratorExp(iSource, referredIteration, iIterators, iBody);
        }

        public @NonNull OCLExpression visitLetExp(@NonNull LetExp pLetExp) {
            Variable asVariable = this.createVariable((Variable)ClassUtil.nonNull((Object)pLetExp.getOwnedVariable()));
            OCLExpression asInExpression = this.create(pLetExp.getOwnedIn());
            assert (asInExpression != null);
            return BasicRegion2Mapping.this.helper.createLetExp(asVariable, asInExpression);
        }

        public @NonNull OCLExpression visitMapLiteralExp(@NonNull MapLiteralExp pMapLiteralExp) {
            ArrayList<@NonNull MapLiteralPart> clonedParts = new ArrayList<MapLiteralPart>();
            for (MapLiteralPart pPart : ClassUtil.nullFree((List)pMapLiteralExp.getOwnedParts())) {
                OCLExpression key = this.createNonNull(pPart.getOwnedKey());
                OCLExpression value = this.createNonNull(pPart.getOwnedValue());
                clonedParts.add(BasicRegion2Mapping.this.helper.createMapLiteralPart(key, value));
            }
            MapType mapType = (MapType)pMapLiteralExp.getType();
            assert (mapType != null);
            return BasicRegion2Mapping.this.helper.createMapLiteralExp(mapType, clonedParts);
        }

        public @NonNull OCLExpression visitOperationCallExp(@NonNull OperationCallExp pOperationCallExp) {
            OCLExpression iSource = this.create(pOperationCallExp.getOwnedSource());
            List<@NonNull OCLExpression> iArguments = this.createAll(ClassUtil.nullFree((List)pOperationCallExp.getOwnedArguments()));
            Operation referredOperation = BasicRegion2Mapping.this.visitor.create(pOperationCallExp.getReferredOperation());
            assert (referredOperation != null);
            if (iSource == null && referredOperation instanceof Function) {
                SchedulerConstants scheduler = BasicRegion2Mapping.this.getRegion().getSuperRegion().getSchedulerConstants();
                StandardLibrary standardLibrary = scheduler.getStandardLibrary();
                Variable thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)BasicRegion2Mapping.this.visitor.getTransformation());
                iSource = PivotUtil.createVariableExp((Variable)thisVariable);
            }
            return BasicRegion2Mapping.this.helper.createOperationCallExp(iSource, referredOperation, iArguments);
        }

        public @NonNull OCLExpression visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp pOppositePropertyCallExp) {
            OCLExpression iSource = this.createNonNull(pOppositePropertyCallExp.getOwnedSource());
            Property referredProperty = pOppositePropertyCallExp.getReferredProperty();
            assert (referredProperty != null);
            return PivotUtil.createNavigationCallExp((OCLExpression)iSource, (Property)referredProperty);
        }

        public @NonNull OCLExpression visitPrimitiveLiteralExp(@NonNull PrimitiveLiteralExp pPrimitiveLiteralExp) {
            return (OCLExpression)EcoreUtil.copy((EObject)pPrimitiveLiteralExp);
        }

        public @NonNull OCLExpression visitPropertyCallExp(@NonNull PropertyCallExp pPropertyCallExp) {
            OCLExpression iSource = this.createNonNull(pPropertyCallExp.getOwnedSource());
            Property referredProperty = pPropertyCallExp.getReferredProperty();
            assert (referredProperty != null);
            assert (referredProperty.eContainer() != null);
            return BasicRegion2Mapping.this.helper.createNavigationCallExp(iSource, referredProperty);
        }

        public @NonNull OCLExpression visitShadowExp(@NonNull ShadowExp pShadowExp) {
            ArrayList<@NonNull ShadowPart> clonedParts = new ArrayList<ShadowPart>();
            for (ShadowPart pPart : ClassUtil.nullFree((List)pShadowExp.getOwnedParts())) {
                OCLExpression init = this.createNonNull(pPart.getOwnedInit());
                String name = pPart.getName();
                Type type = pPart.getType();
                assert (name != null && type != null);
                Property referredProperty = pPart.getReferredProperty();
                assert (referredProperty != null);
                clonedParts.add(BasicRegion2Mapping.this.helper.createShadowPart(referredProperty, init));
            }
            Class shadowType = pShadowExp.getType();
            assert (shadowType != null);
            return BasicRegion2Mapping.this.helper.createShadowExp(shadowType, clonedParts);
        }

        public @NonNull OCLExpression visitTupleLiteralExp(@NonNull TupleLiteralExp pTupleLiteralExp) {
            ArrayList<@NonNull TupleLiteralPart> clonedParts = new ArrayList<TupleLiteralPart>();
            for (TupleLiteralPart pPart : ClassUtil.nullFree((List)pTupleLiteralExp.getOwnedParts())) {
                OCLExpression init = this.createNonNull(pPart.getOwnedInit());
                String name = pPart.getName();
                Type type = pPart.getType();
                assert (name != null && type != null);
                clonedParts.add(BasicRegion2Mapping.this.helper.createTupleLiteralPart(name, type, pPart.isIsRequired(), init));
            }
            TupleType tupleType = (TupleType)pTupleLiteralExp.getType();
            assert (tupleType != null);
            return BasicRegion2Mapping.this.helper.createTupleLiteralExp(tupleType, clonedParts);
        }

        public @NonNull OCLExpression visitTypeExp(@NonNull TypeExp pTypeExp) {
            Type referredType = pTypeExp.getReferredType();
            assert (referredType != null);
            return BasicRegion2Mapping.this.helper.createTypeExp(referredType);
        }

        public @NonNull OCLExpression visitVariableExp(@NonNull VariableExp pVariableExp) {
            VariableDeclaration pVariable = pVariableExp.getReferredVariable();
            Node node = BasicRegion2Mapping.this.getNode((TypedElement)pVariable);
            if (node == null) {
                SchedulerConstants scheduler = BasicRegion2Mapping.this.getRegion().getSuperRegion().getSchedulerConstants();
                StandardLibrary standardLibrary = scheduler.getStandardLibrary();
                Transformation pTransformation = QVTbaseUtil.getContainingTransformation((EObject)pVariableExp);
                if (pTransformation != null) {
                    Variable pThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)pTransformation);
                    if (pVariableExp.getReferredVariable() == pThisVariable) {
                        Variable iThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)BasicRegion2Mapping.this.visitor.getTransformation());
                        return PivotUtil.createVariableExp((Variable)iThisVariable);
                    }
                }
            }
            if (node != null) {
                Variable iVariable = BasicRegion2Mapping.this.getVariable(node);
                assert (iVariable != null);
                return PivotUtil.createVariableExp((Variable)iVariable);
            }
            System.err.println("Creating unexpected variable for " + pVariable + " in " + BasicRegion2Mapping.this.region);
            BottomPattern bottomPattern = BasicRegion2Mapping.this.mapping.getBottomPattern();
            assert (bottomPattern != null);
            Type variableType = pVariable.getType();
            assert (variableType != null);
            String safeName = BasicRegion2Mapping.this.getSafeName((String)ClassUtil.nonNullState((Object)pVariable.getName()));
            Variable iVariable = PivotUtil.createVariable((String)safeName, (Type)variableType, (boolean)pVariable.isIsRequired(), null);
            bottomPattern.getVariable().add((Object)iVariable);
            return PivotUtil.createVariableExp((Variable)iVariable);
        }
    }

    private class InlineExpressionCreator
    extends ExpressionCreator {
        private InlineExpressionCreator() {
        }

        @Override
        public @NonNull OCLExpression create(Node node) {
            if (node.isNull()) {
                return BasicRegion2Mapping.this.helper.createNullLiteralExp();
            }
            Variable theVariable = (Variable)BasicRegion2Mapping.this.node2variable.get(node);
            if (theVariable == null) {
                TypedElement oldTypedElement = node.getTypedElements().iterator().next();
                assert (oldTypedElement != null);
                if (!(oldTypedElement instanceof Variable) || ((Variable)oldTypedElement).getOwnedInit() != null) {
                    return (OCLExpression)oldTypedElement.accept((Visitor)this);
                }
                theVariable = BasicRegion2Mapping.this.createBottomVariable(node, null);
                assert (theVariable != null);
            }
            return PivotUtil.createVariableExp((Variable)theVariable);
        }
    }
}

