/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.utilities;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.utilities.ExplicitClassLoader;
import org.osgi.framework.Bundle;

public final class JavaSourceFileObject
extends SimpleJavaFileObject {
    private static @Nullable JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public static void compileClasses(@NonNull String sourcePath, @NonNull String objectPath, @Nullable List<String> classpathProjects) throws IOException {
        List<@NonNull JavaFileObject> compilationUnits = JavaSourceFileObject.gatherCompilationUnits(new File(sourcePath), null);
        JavaCompiler compiler2 = compiler;
        if (compiler2 == null) {
            throw new IllegalStateException("No JavaCompiler provided by the Java platform - you need to use a JDK rather than a JRE");
        }
        StandardJavaFileManager stdFileManager2 = compiler2.getStandardFileManager(null, Locale.getDefault(), null);
        if (stdFileManager2 == null) {
            throw new IllegalStateException("No StandardJavaFileManager provided by the Java platform");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        List<String> compilationOptions = EcorePlugin.IS_ECLIPSE_RUNNING && classpathProjects != null ? Arrays.asList("-d", objectPath, "-g", "-cp", JavaSourceFileObject.createClassPath(classpathProjects)) : Arrays.asList("-d", objectPath, "-g");
        JavaCompiler.CompilationTask compilerTask = compiler2.getTask(null, stdFileManager2, diagnostics, compilationOptions, null, compilationUnits);
        if (!compilerTask.call().booleanValue()) {
            StringBuilder s = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                s.append("\n" + diagnostic);
            }
            if (s.length() > 0) {
                System.err.println("Failed to compile " + sourcePath + s.toString());
            } else {
                System.out.println("Compilation of " + sourcePath + " returned false but no diagnostics");
            }
        }
        stdFileManager2.close();
    }

    public static @NonNull List<@NonNull String> createClasspathProjectList(String ... classpathProjects) {
        ArrayList<@NonNull String> classpathProjectList = new ArrayList<String>();
        if (classpathProjects != null) {
            String[] stringArray = classpathProjects;
            int n = classpathProjects.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String classpathProject = stringArray[n2];
                classpathProjectList.add(classpathProject);
                ++n2;
            }
        }
        return classpathProjectList;
    }

    public static @NonNull String createClassPath(@NonNull List<String> projectNames) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String pathSeparator = null;
        StringBuilder s = new StringBuilder();
        for (String projectName : projectNames) {
            URI uri;
            Bundle bundle;
            IPath location;
            String projectPath = null;
            IProject project = root.getProject(projectName);
            if (project != null && (location = project.getLocation()) != null) {
                projectPath = String.valueOf(location.toString()) + "/";
            }
            if (projectPath == null && (bundle = Platform.getBundle((String)projectName)) != null) {
                projectPath = bundle.getLocation();
            }
            if (projectPath == null) continue;
            if (projectPath.startsWith("reference:")) {
                projectPath = projectPath.substring(10);
            }
            if ((uri = URI.createURI((String)projectPath)).isFile()) {
                projectPath = ((String)ClassUtil.nonNullState((Object)uri.toFileString())).replace("\\", "/");
            }
            assert (projectPath != null);
            if (projectPath.endsWith("/")) {
                projectPath = String.valueOf(projectPath) + "bin";
            }
            if (pathSeparator != null) {
                s.append(pathSeparator);
            } else {
                pathSeparator = System.getProperty("path.separator");
            }
            s.append(projectPath);
        }
        return s.toString();
    }

    private static @NonNull List<@NonNull JavaFileObject> gatherCompilationUnits(@NonNull File folder, @Nullable List<@NonNull JavaFileObject> compilationUnits) throws IOException {
        File[] listFiles;
        if (compilationUnits == null) {
            compilationUnits = new ArrayList<JavaFileObject>();
        }
        if ((listFiles = folder.listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    JavaSourceFileObject.gatherCompilationUnits(file, compilationUnits);
                } else if (file.isFile() && file.getName().endsWith(".java")) {
                    java.net.URI uri = file.getCanonicalFile().toURI();
                    compilationUnits.add(new JavaSourceFileObject(uri));
                }
                ++n2;
            }
        }
        return compilationUnits;
    }

    public static Class<?> loadExplicitClass(@NonNull File explicitClassPath, @NonNull String qualifiedClassName) throws ClassNotFoundException, IOException {
        ClassLoader thisClassLoader = JavaSourceFileObject.class.getClassLoader();
        ExplicitClassLoader classLoader = new ExplicitClassLoader(explicitClassPath, qualifiedClassName, thisClassLoader);
        return classLoader.loadClass(qualifiedClassName);
    }

    public static void saveClass(@NonNull String explicitClassPath, @NonNull String qualifiedName, @NonNull String javaCodeSource, @Nullable List<String> classpathProjects) throws IOException {
        List<OCL2JavaFileObject> compilationUnits;
        JavaCompiler compiler2 = compiler;
        if (compiler2 == null) {
            throw new IllegalStateException("No JavaCompiler provided by the Java platform - you need to use a JDK rather than a JRE");
        }
        StandardJavaFileManager stdFileManager2 = compiler2.getStandardFileManager(null, Locale.getDefault(), null);
        if (stdFileManager2 == null) {
            throw new IllegalStateException("No StandardJavaFileManager provided by the Java platform");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        List<String> compilationOptions = EcorePlugin.IS_ECLIPSE_RUNNING && classpathProjects != null ? Arrays.asList("-d", explicitClassPath, "-g", "-cp", JavaSourceFileObject.createClassPath(classpathProjects)) : Arrays.asList("-d", explicitClassPath, "-g");
        JavaCompiler.CompilationTask compilerTask = compiler2.getTask(null, stdFileManager2, diagnostics, compilationOptions, null, compilationUnits = Collections.singletonList(new OCL2JavaFileObject(qualifiedName, javaCodeSource)));
        if (!compilerTask.call().booleanValue()) {
            StringBuilder s = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                s.append("\n" + diagnostic);
            }
            if (s.length() > 0) {
                throw new IOException("Failed to compile " + qualifiedName + s.toString());
            }
            System.out.println("Compilation of " + qualifiedName + " returned false but no diagnostics");
        }
        stdFileManager2.close();
    }

    private JavaSourceFileObject(@NonNull java.net.URI uri) {
        super(uri, JavaFileObject.Kind.SOURCE);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        char[] buf = new char[4096];
        StringBuffer s = new StringBuffer();
        try (FileReader reader = new FileReader(new File(this.uri));){
            int len;
            while ((len = reader.read(buf)) > 0) {
                s.append(buf, 0, len);
            }
        }
        return s.toString();
    }
}

