/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.services.IDisposable;

public final class SharedImages
implements IDisposable {
    private ImageRegistry registry = null;

    public static String dlcl16(String image) {
        return "/icons/dlcl16/" + image;
    }

    public static String elcl16(String image) {
        return "/icons/elcl16/" + image;
    }

    public static String obj16(String image) {
        return "/icons/obj16/" + image;
    }

    public static String ovr16(String image) {
        return "/icons/ovr16/" + image;
    }

    public static String view16(String image) {
        return "/icons/view16/" + image;
    }

    public static String wizban(String image) {
        return "/icons/wizban/" + image;
    }

    public synchronized ImageDescriptor getDescriptor(ImageResource resource) {
        ImageDescriptor desc = this.getRegistry().getDescriptor(SharedImages.toKey(resource));
        if (desc == null) {
            desc = this.register(resource);
        }
        return desc;
    }

    private ImageRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = new ImageRegistry();
        }
        return this.registry;
    }

    public synchronized Image getImage(ImageResource resource) {
        String key = SharedImages.toKey(resource);
        Image img = this.getRegistry().get(key);
        if (img == null) {
            this.register(resource);
            img = this.getRegistry().get(key);
        }
        return img;
    }

    private ImageDescriptor register(ImageResource resource) {
        ImageDescriptor desc = ImageDescriptor.createFromFile(resource.getClass(), (String)resource.getName());
        String key = SharedImages.toKey(resource);
        this.getRegistry().put(key, desc);
        return desc;
    }

    private static String toKey(ImageResource resource) {
        return String.valueOf(resource.getClass().getName()) + '#' + resource.getName();
    }

    public void dispose() {
        if (this.registry != null) {
            this.registry.dispose();
        }
    }

    public static interface ImageResource {
        public String getName();
    }

    public static enum Images implements ImageResource
    {
        ELCL_ADD_REPOSITORY(SharedImages.elcl16("add_repository.png")),
        ELCL_ADD_SNIPPET(SharedImages.elcl16("add_snippet.png")),
        ELCL_CLEAR(SharedImages.elcl16("clear.gif")),
        ELCL_COLLAPSE_ALL(SharedImages.elcl16("collapseall.gif")),
        ELCL_DELETE(SharedImages.elcl16("delete.gif")),
        ELCL_DISABLE_REPOSITORY(SharedImages.elcl16("disable_repository.png")),
        ELCL_EDIT_REPOSITORY(SharedImages.elcl16("edit_repository.png")),
        ELCL_EDIT_SNIPPET(SharedImages.elcl16("edit_snippet.png")),
        ELCL_ENABLE_REPOSITORY(SharedImages.elcl16("enable_repository.png")),
        ELCL_EXPAND_ALL(SharedImages.elcl16("expandall.gif")),
        ELCL_HELP(SharedImages.elcl16("help.png")),
        ELCL_INSTALL_EXTENSIONS(SharedImages.elcl16("install-extensions.png")),
        ELCL_REFRESH(SharedImages.elcl16("refresh_tab.gif")),
        ELCL_REMOVE_REPOSITORY(SharedImages.elcl16("remove_repository.png")),
        ELCL_REMOVE_REPOSITORY_DISABLED(SharedImages.elcl16("remove_repository_disabled.png")),
        ELCL_REMOVE_SNIPPET(SharedImages.elcl16("remove_snippet.png")),
        ELCL_SHARE_SNIPPET(SharedImages.elcl16("share_snippet.png")),
        OBJ_BIRD_BLUE(SharedImages.obj16("bird_blue_16.png")),
        OBJ_BULLET_BLUE(SharedImages.obj16("bullet_blue.png")),
        OBJ_BULLET_GREEN(SharedImages.obj16("bullet_green.png")),
        OBJ_BULLET_ORANGE(SharedImages.obj16("bullet_orange.png")),
        OBJ_BULLET_RED(SharedImages.obj16("bullet_red.png")),
        OBJ_BULLET_STAR(SharedImages.obj16("bullet_star.png")),
        OBJ_BULLET_YELLOW(SharedImages.obj16("bullet_yellow.png")),
        OBJ_CHECK_GREEN(SharedImages.obj16("tick_small.png")),
        OBJ_CROSS_RED(SharedImages.obj16("cross_small.png")),
        OBJ_MANUAL(SharedImages.obj16("manual.gif")),
        OBJ_FAVORITE_STAR(SharedImages.obj16("favorite_star.png")),
        OBJ_HOMEPAGE(SharedImages.obj16("homepage.png")),
        OBJ_HOURGLASS(SharedImages.obj16("hourglass.png")),
        OBJ_LIGHTBULB(SharedImages.obj16("lightbulb.png")),
        OBJ_NEWSLETTER(SharedImages.obj16("newsletter.png")),
        OBJ_JAR(SharedImages.obj16("jar.gif")),
        OBJ_JAVA_PROJECT(SharedImages.obj16("project.gif")),
        OBJ_JRE(SharedImages.obj16("jre.gif")),
        OBJ_REPOSITORY(SharedImages.obj16("repository.gif")),
        OVR_STAR(SharedImages.ovr16("star.png"));

        private final String name;

        private Images(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

