/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.proxyselector;

import java.io.Closeable;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.IOUtils;
import org.eclipse.riena.internal.communication.core.proxyselector.ProxySelectorUtils;

public class CompoundProxySelector
extends ProxySelector {
    private final List<ProxySelector> proxySelectors;
    private final Set<Proxy> failedProxies = Collections.synchronizedSet(new LinkedHashSet());

    public CompoundProxySelector(List<ProxySelector> proxySelectors) {
        Assert.isLegal((proxySelectors != null ? 1 : 0) != 0, (String)"proxySelectors must not be null.");
        this.proxySelectors = proxySelectors;
    }

    @Override
    public List<Proxy> select(URI uri) {
        Assert.isLegal((uri != null ? 1 : 0) != 0, (String)"uri must not be null.");
        ArrayList<Proxy> result = new ArrayList<Proxy>();
        for (ProxySelector proxySelector : this.proxySelectors) {
            List<Proxy> proxies = proxySelector.select(uri);
            if (proxies == null || proxies.size() == 0) continue;
            for (Proxy proxy : proxies) {
                if (proxy == Proxy.NO_PROXY || result.contains(proxy)) continue;
                result.add(proxy);
            }
        }
        ProxySelectorUtils.resort(result, this.failedProxies);
        result.add(Proxy.NO_PROXY);
        return result;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        Proxy failed = ProxySelectorUtils.createProxy(uri.getScheme(), sa);
        this.failedProxies.add(failed);
        for (ProxySelector proxySelector : this.proxySelectors) {
            proxySelector.connectFailed(uri, sa, ioe);
        }
    }

    public void uninstall() {
        for (ProxySelector proxySelector : this.proxySelectors) {
            if (!(proxySelector instanceof Closeable)) continue;
            IOUtils.close((Closeable)((Closeable)((Object)proxySelector)));
        }
    }
}

