/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.annotationprocessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AnnotatedOverriddenMethodsGuard {
    private final Set<ShallowAnnotatedMethod> annotatedMethods = new HashSet<ShallowAnnotatedMethod>();

    public boolean add(Annotation annotation, Method method) {
        return this.annotatedMethods.add(new ShallowAnnotatedMethod(annotation, method));
    }

    private static class ShallowAnnotatedMethod {
        private final Annotation annotation;
        private final String name;
        private final Class<?>[] parameterTypes;
        private final boolean isPrivate;

        public ShallowAnnotatedMethod(Annotation annotation, Method method) {
            this.annotation = annotation;
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.isPrivate = Modifier.isPrivate(method.getModifiers());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ShallowAnnotatedMethod)) {
                return false;
            }
            ShallowAnnotatedMethod other = (ShallowAnnotatedMethod)obj;
            if (this.isPrivate || other.isPrivate) {
                return false;
            }
            if (this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, other.parameterTypes);
        }
    }
}

