/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.core.injector.extension.ExtensionPointId;

public class ExtensionDescriptor {
    private final ExtensionPointId extensionPointId;
    private boolean homogeneous = true;
    private Class<?> interfaceType;
    private int minOccurrences = 0;
    private int maxOccurrences = Integer.MAX_VALUE;
    public static final int UNBOUNDED = Integer.MAX_VALUE;

    public ExtensionDescriptor() {
        this.extensionPointId = new ExtensionPointId();
    }

    public ExtensionDescriptor(String extensionPointId) {
        Assert.isLegal((boolean)StringUtils.isGiven(extensionPointId), (String)"The extension id must be given, i.e. not null and not empty.");
        this.extensionPointId = new ExtensionPointId(extensionPointId);
    }

    public ExtensionDescriptor useType(Class<?> interfaceType) {
        Assert.isNotNull(interfaceType, (String)"Interface type must not be null.");
        Assert.isTrue((boolean)interfaceType.isInterface(), (String)"Interface type must be an interface.");
        Assert.isTrue((this.interfaceType == null ? 1 : 0) != 0, (String)"Interface type has already been set.");
        this.interfaceType = interfaceType;
        return this;
    }

    public ExtensionDescriptor heterogeneous() {
        this.homogeneous = false;
        return this;
    }

    public ExtensionInjector into(Object target) {
        Assert.isNotNull((Object)target, (String)"The target must not be null.");
        return new ExtensionInjector(this, target);
    }

    public ExtensionDescriptor expectingMinMax(int min, int max) {
        Assert.isLegal((max >= min ? 1 : 0) != 0, (String)"min must not be greater than max.");
        Assert.isLegal((min >= 0 ? 1 : 0) != 0, (String)"min must be greater or equal than zero.");
        Assert.isLegal((max > 0 ? 1 : 0) != 0, (String)"max must be greater than zero.");
        this.minOccurrences = min;
        this.maxOccurrences = max;
        return this;
    }

    public ExtensionDescriptor expectingExactly(int exactly) {
        return this.expectingMinMax(exactly, exactly);
    }

    public ExtensionPointId getExtensionPointId() {
        return this.extensionPointId;
    }

    public Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    int getMinOccurrences() {
        return this.minOccurrences;
    }

    int getMaxOccurrences() {
        return this.maxOccurrences;
    }

    public boolean isHomogeneous() {
        return this.homogeneous;
    }

    public boolean requiresArrayUpdateMethod() {
        return this.minOccurrences > 1 || this.maxOccurrences > 1;
    }
}

