/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.logging.SystemPropertyLogFilter;
import org.osgi.framework.ServiceReference;

public class ConsoleLogger
implements Logger {
    private final String name;
    private static String nameAndHost;
    private static DateFormat formatter;
    public static final String RIENA_CONSOLE_LOG_LEVEL_PROPERTY = "riena.console.loglevel";
    private static final LogFilter LOG_FILTER;

    static {
        String host;
        LOG_FILTER = new SystemPropertyLogFilter(RIENA_CONSOLE_LOG_LEVEL_PROPERTY, "debug");
        String user = System.getProperty("user.name", "?");
        try {
            host = Inet4Address.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            host = "?";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(user).append('@').append(host);
        nameAndHost = buffer.toString();
        formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
    }

    public ConsoleLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLoggable(int level) {
        return LOG_FILTER.isLoggable(null, this.name, level);
    }

    public void log(int level, String message) {
        this.log(level, null, null, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.log(level, null, null, message, exception);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(level, null, sr, message, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(level, null, null, message, exception);
    }

    public void log(Object context, int level, String message) {
        this.log(level, context, null, message, null);
    }

    public void log(Object context, int level, String message, Throwable exception) {
        this.log(level, context, null, message, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int level, Object context, ServiceReference sr, String message, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        StringBuilder bob = new StringBuilder();
        DateFormat dateFormat = formatter;
        synchronized (dateFormat) {
            bob.append(formatter.format(new Date()));
        }
        bob.append(' ');
        bob.append(nameAndHost);
        bob.append(' ');
        bob.append(this.getLevel(level));
        bob.append(' ');
        bob.append('[');
        bob.append(Thread.currentThread().getName());
        if (context != null) {
            bob.append(", CTX: ");
            bob.append(context);
        }
        if (sr != null) {
            bob.append(", SR: ");
            bob.append(sr);
        }
        bob.append("] ");
        bob.append(this.name);
        bob.append(' ');
        bob.append(message);
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            throwable.printStackTrace(writer);
            writer.close();
            bob.append('\n').append(stringWriter.toString());
        }
        PrintStream printStream = this.getPrintStream(level);
        printStream.println(bob.toString());
    }

    private String getLevel(int level) {
        switch (level) {
            case 4: {
                return "DEBUG";
            }
            case 3: {
                return "INFO";
            }
            case 2: {
                return "WARN";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "CUSTOM(" + level + ")";
    }

    private PrintStream getPrintStream(int level) {
        return 2 == level || 1 == level ? System.err : System.out;
    }
}

