/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.logging.ILogCatcher;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.internal.core.Activator;

public class JavaLogCatcher
implements ILogCatcher {
    private Handler javaLogginghandler;
    protected java.util.logging.Logger rootLogger;
    protected Level rootLevel;

    @Override
    public void attach() {
        this.prepareJulLogging();
        this.javaLogginghandler = new JavaLoggingHandler();
        this.rootLogger.addHandler(this.javaLogginghandler);
    }

    protected void prepareJulLogging() {
        LogManager.getLogManager().reset();
        this.rootLogger = java.util.logging.Logger.getLogger("");
        this.rootLevel = this.rootLogger.getLevel();
        this.rootLogger.setLevel(Level.ALL);
    }

    @Override
    public void detach() {
        if (this.rootLogger == null || this.javaLogginghandler == null) {
            return;
        }
        this.rootLogger.removeHandler(this.javaLogginghandler);
        this.cleanupJulLogging();
    }

    protected void cleanupJulLogging() {
        this.rootLogger.setLevel(this.rootLevel);
    }

    private static class JavaLoggingHandler
    extends Handler {
        private JavaLoggingHandler() {
        }

        @Override
        public void close() {
            Nop.reason("nothing to close here");
        }

        @Override
        public void flush() {
            Nop.reason("nothing to flush here");
        }

        @Override
        public void publish(LogRecord record) {
            int javaLoglevel = record.getLevel().intValue();
            int equinoxLoglevel = javaLoglevel == Level.SEVERE.intValue() ? 1 : (javaLoglevel == Level.WARNING.intValue() ? 2 : (javaLoglevel == Level.INFO.intValue() || javaLoglevel == Level.CONFIG.intValue() ? 3 : 4));
            Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), record.getLoggerName());
            if (!logger.isLoggable(equinoxLoglevel)) {
                return;
            }
            String message = record.getMessage();
            Object[] params = record.getParameters();
            if (params != null) {
                message = MessageFormat.format(message, params);
            }
            logger.log(equinoxLoglevel, message, record.getThrown());
        }
    }
}

