/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging.log4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class Log4jCommandProvider
implements CommandProvider {
    private static final String ROOT_LOGGER_NAME = "ROOT";

    public void _log4jLevel(CommandInterpreter intp) {
        Logger logger;
        String category = intp.nextArgument();
        String loglevel = intp.nextArgument();
        String categoryForDisplay = category == null ? ROOT_LOGGER_NAME : category;
        Logger logger2 = logger = category == null || category.equals(ROOT_LOGGER_NAME) ? Logger.getRootLogger() : Logger.getLogger((String)category);
        if (loglevel == null) {
            intp.println((Object)String.format("LogLevel for %s is %s", categoryForDisplay, this.getLogLevelString(logger)));
        } else {
            Level newLevel = Level.toLevel((String)(loglevel = loglevel.toUpperCase()));
            if (newLevel.toString().equals(loglevel)) {
                logger.setLevel(newLevel);
                intp.println((Object)String.format("LogLevel for %s set to %s", categoryForDisplay, this.getLogLevelString(logger)));
            } else {
                intp.println((Object)String.format("LogLevel for %s is %s (not changed to unknown level %s)", categoryForDisplay, this.getLogLevelString(logger), loglevel));
            }
        }
    }

    private String getLogLevelString(Logger logger) {
        if (logger == null) {
            return "OFF";
        }
        if (logger.isEnabledFor((Priority)Level.ALL)) {
            return "ALL";
        }
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            return "DEBUG";
        }
        if (logger.isEnabledFor((Priority)Level.INFO)) {
            return "INFO";
        }
        if (logger.isEnabledFor((Priority)Level.WARN)) {
            return "WARN";
        }
        if (logger.isEnabledFor((Priority)Level.ERROR)) {
            return "ERROR";
        }
        if (logger.isEnabledFor((Priority)Level.OFF)) {
            return "OFF";
        }
        return "UNKNOWN";
    }

    public String getHelp() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("---Log4j configuration---");
        writer.println("\tlog4jLevel - display log level of root category (same as 'log4jLevel ROOT')");
        writer.println("\tlog4jLevel (ROOT|<category>) - display log level for specified category");
        writer.println("\tlog4jLevel (ROOT|<category>) (DEBUG|INFO|WARN|ERROR) - set log level for specified category");
        writer.close();
        return stringWriter.toString();
    }
}

