/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.riena.core.RienaLocations;
import org.osgi.framework.FrameworkUtil;

public class JavaSystemPropertiesResolver
implements IDynamicVariableResolver {
    private static final String RIENA = "riena.";
    private static final String HOST_ADDRESS = "riena.host.address";
    private static final String HOST_NAME = "riena.host.name";
    private static final String LOCATIONS_DATA = "riena.locations.data";
    private static final String UNKNOWN = "?";
    private String hostName;
    private String hostAddress;
    private String dataLocation;

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        if (argument == null) {
            return null;
        }
        String value = this.lookForSyntheticProperties(argument);
        if (value != null) {
            return value;
        }
        return System.getProperty(argument);
    }

    private String lookForSyntheticProperties(String argument) throws CoreException {
        if (argument.equals(HOST_ADDRESS)) {
            return this.getHostAddress();
        }
        if (argument.equals(HOST_NAME)) {
            return this.getHostName();
        }
        if (argument.equals(LOCATIONS_DATA)) {
            return this.getDataLocation();
        }
        return null;
    }

    private String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.hostName = UNKNOWN;
            }
        }
        return this.hostName;
    }

    private String getHostAddress() {
        if (this.hostAddress == null) {
            try {
                this.hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.hostAddress = UNKNOWN;
            }
        }
        return this.hostAddress;
    }

    private String getDataLocation() throws CoreException {
        if (this.dataLocation == null) {
            try {
                this.dataLocation = RienaLocations.getDataArea().getCanonicalPath();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, FrameworkUtil.getBundle(JavaSystemPropertiesResolver.class).getSymbolicName(), "Could not resolve Riena default data location", (Throwable)e));
            }
        }
        return this.dataLocation;
    }
}

