/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Scanner;
import org.eclipse.core.runtime.Assert;

public final class Millis {
    private Millis() {
    }

    public static long seconds(int seconds) {
        return 1000L * (long)seconds;
    }

    public static long minutes(int minutes) {
        return Millis.seconds(60 * minutes);
    }

    public static long hours(int hours) {
        return Millis.minutes(60 * hours);
    }

    public static long days(int days) {
        return Millis.hours(24 * days);
    }

    public static long weeks(int weeks) {
        return Millis.days(weeks * 7);
    }

    public static long months(int months) {
        return Millis.days(months * 28);
    }

    public static long years(int years) {
        return Millis.days(years * 365);
    }

    public static long valueOf(String period) {
        Assert.isLegal((period != null ? 1 : 0) != 0, (String)"period must not be null.");
        Scanner scanner = new Scanner(period);
        long millis = 0L;
        long value = 0L;
        while (scanner.hasNext()) {
            if (scanner.hasNextLong()) {
                value = scanner.nextLong();
                continue;
            }
            millis += value * Millis.getFactor(scanner.next());
        }
        return millis;
    }

    private static long getFactor(String unit) {
        if ("d".equals(unit)) {
            return Millis.days(1);
        }
        if ("h".equals(unit)) {
            return Millis.hours(1);
        }
        if ("m".equals(unit)) {
            return Millis.minutes(1);
        }
        if ("s".equals(unit)) {
            return Millis.seconds(1);
        }
        if ("ms".equals(unit)) {
            return 1L;
        }
        if ("w".equals(unit)) {
            return Millis.weeks(1);
        }
        if ("M".equals(unit)) {
            return Millis.months(1);
        }
        if ("y".equals(unit)) {
            return Millis.years(1);
        }
        throw new IllegalArgumentException("Wrong time unit. Expecting either: y, M, w, d, h, m, s or ms");
    }
}

