/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.wire;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.injector.IStoppable;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.util.WeakRef;
import org.eclipse.riena.core.wire.IWiring;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.core.wire.OnWiringDone;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.internal.core.wire.ExtensionInjectorBuilder;
import org.eclipse.riena.internal.core.wire.ServiceInjectorBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;

public class WirePuller
implements IStoppable {
    private final WeakRef<?> beanRef;
    private BundleContext context;
    private List<IWiring> wirings;
    private List<IStoppable> injections;
    private State state = State.PENDING;
    private BundleListener bundleStoppingListener;
    private static final Comparator<MAOTupel> ORDER_COMPARATOR = new OrderComparator();
    private static Map<Class<?>, Class<? extends IWiring>> wiringMocks;
    private static final Logger LOGGER;

    static {
        LOGGER = Log4r.getLogger(WirePuller.class);
    }

    WirePuller(Object bean) {
        Assert.isLegal((bean != null ? 1 : 0) != 0, (String)"bean must exist");
        this.beanRef = new WeakRef<Object>(bean, new Runnable(){

            @Override
            public void run() {
                WirePuller.this.stop();
            }
        });
    }

    public synchronized WirePuller andStart() {
        Class<?> beanClass = this.getBeanClass();
        if (beanClass == null) {
            LOGGER.log(2, "Could not wire bean because it is aleady garbage collected.");
            return null;
        }
        Bundle bundle = FrameworkUtil.getBundle(beanClass);
        if (bundle != null) {
            return this.andStart(bundle.getBundleContext());
        }
        LOGGER.log(2, "Could not wire bean '" + beanClass + "' because there is no bundle context.");
        return null;
    }

    public synchronized WirePuller andStart(BundleContext context) {
        Assert.isLegal((context != null ? 1 : 0) != 0, (String)"context must be given.");
        Assert.isLegal((this.state == State.PENDING ? 1 : 0) != 0, (String)"state must be pending.");
        this.context = context;
        if (!this.wire(this.getBean(), this.getBeanClass())) {
            return this;
        }
        this.state = State.STARTED;
        this.bundleStoppingListener = new BundleStoppingListener();
        context.addBundleListener(this.bundleStoppingListener);
        return this;
    }

    @Override
    public synchronized void stop() {
        if (this.state != State.STARTED) {
            return;
        }
        this.context.removeBundleListener(this.bundleStoppingListener);
        Object bean = this.getBean();
        if (bean != null && this.wirings != null) {
            for (IWiring wiring : this.wirings) {
                wiring.unwire(bean, this.context);
            }
        }
        for (IStoppable stoppable : Iter.ableReverse(this.injections)) {
            stoppable.stop();
        }
        this.state = State.STOPPED;
    }

    private boolean wire(Object bean, Class<?> beanClass) {
        if (beanClass == null || bean == null || beanClass == Object.class) {
            return false;
        }
        IWiring wiring = this.getWiring(this.getWiringClass(beanClass));
        this.add(wiring);
        boolean hasWirings = this.wire(bean, beanClass.getSuperclass());
        if (wiring != null) {
            wiring.wire(bean, this.context);
            hasWirings = true;
        }
        return this.injectIntoAnnotatedMethods(bean, beanClass) | hasWirings;
    }

    private boolean injectIntoAnnotatedMethods(Object bean, Class<?> beanClass) {
        boolean hasWirings = false;
        for (MAOTupel maot : this.sortMethodsByInjectionOrder(beanClass.getDeclaredMethods())) {
            if (maot.annotation == InjectService.class) {
                this.verifyOrder(beanClass, maot);
                this.injectServiceInto(bean, maot.method);
                hasWirings = true;
                continue;
            }
            if (maot.annotation == InjectExtension.class) {
                this.verifyOrder(beanClass, maot);
                this.injectExtensionInto(bean, maot.method);
                hasWirings = true;
                continue;
            }
            if (maot.annotation != OnWiringDone.class) continue;
            this.notifyBean(bean, maot.method);
        }
        return hasWirings;
    }

    private void verifyOrder(Class<?> beanClass, MAOTupel maot) {
        if (maot.getOrder() == Integer.MAX_VALUE) {
            throw new InjectionFailure("Annotation '" + maot.annotation + "' on '" + beanClass.getName() + "." + maot.method.getName() + "' has forbidden order Integer.MAX_VALUE");
        }
    }

    private List<MAOTupel> sortMethodsByInjectionOrder(Method[] methods) {
        ArrayList<MAOTupel> maots = new ArrayList<MAOTupel>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            OnWiringDone wiringDoneAnnotation;
            InjectExtension injectExtensionAnnotation;
            Method method = methodArray[n2];
            InjectService injectServiceAnnotation = method.getAnnotation(InjectService.class);
            if (injectServiceAnnotation != null) {
                maots.add(new MAOTupel(method, InjectService.class, injectServiceAnnotation.order()));
            }
            if ((injectExtensionAnnotation = method.getAnnotation(InjectExtension.class)) != null) {
                maots.add(new MAOTupel(method, InjectExtension.class, injectExtensionAnnotation.order()));
            }
            if ((wiringDoneAnnotation = method.getAnnotation(OnWiringDone.class)) != null) {
                maots.add(new MAOTupel(method, OnWiringDone.class, Integer.MAX_VALUE));
            }
            ++n2;
        }
        Collections.sort(maots, ORDER_COMPARATOR);
        return maots;
    }

    private void injectServiceInto(Object bean, Method method) {
        ServiceInjectorBuilder bob = new ServiceInjectorBuilder(bean, method);
        ServiceInjector injector = bob.build();
        this.add(injector.andStart(this.context));
    }

    private void injectExtensionInto(Object bean, Method method) {
        ExtensionInjectorBuilder bob = new ExtensionInjectorBuilder(bean, method);
        ExtensionInjector injector = bob.build();
        this.add(injector.andStart(this.context));
    }

    private void notifyBean(Object bean, Method method) {
        try {
            method.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new InjectionFailure("Invoking the @WiringDone method '" + method + "' on bean class '" + bean.getClass().getName() + "'.", e);
        }
    }

    private void add(IWiring wiring) {
        if (wiring == null) {
            return;
        }
        if (this.wirings == null) {
            this.wirings = new ArrayList<IWiring>(2);
        }
        this.wirings.add(wiring);
    }

    private void add(IStoppable stoppable) {
        if (this.injections == null) {
            this.injections = new ArrayList<IStoppable>();
        }
        this.injections.add(stoppable);
    }

    private IWiring getWiring(Class<? extends IWiring> wiringClass) {
        if (wiringClass == null) {
            return null;
        }
        try {
            return wiringClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not create instance of wiring " + wiringClass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not create instance of wiring " + wiringClass, e);
        }
    }

    private Class<? extends IWiring> getWiringClass(Class<?> beanClass) {
        if (wiringMocks != null) {
            return wiringMocks.get(beanClass);
        }
        WireWith wiringAnnotation = beanClass.getAnnotation(WireWith.class);
        if (wiringAnnotation != null) {
            return wiringAnnotation.value();
        }
        return null;
    }

    private Object getBean() {
        return this.beanRef.get();
    }

    private Class<?> getBeanClass() {
        Object bean = this.getBean();
        return bean == null ? null : bean.getClass();
    }

    public static void injectWiringMocks(Map<Class<?>, Class<? extends IWiring>> wiringMocks) {
        WirePuller.wiringMocks = wiringMocks;
    }

    private class BundleStoppingListener
    implements SynchronousBundleListener {
        private BundleStoppingListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getBundle() != WirePuller.this.context.getBundle()) {
                return;
            }
            if (event.getType() == 256) {
                WirePuller.this.stop();
            }
        }
    }

    private static class MAOTupel {
        private final Method method;
        private final Class<?> annotation;
        private final int order;

        public MAOTupel(Method method, Class<?> annotation, int order) {
            this.method = method;
            this.annotation = annotation;
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }

    private static final class OrderComparator
    implements Comparator<MAOTupel> {
        private OrderComparator() {
        }

        @Override
        public int compare(MAOTupel tupel1, MAOTupel tupel2) {
            return tupel1.getOrder() == tupel2.getOrder() ? 0 : (tupel1.getOrder() < tupel2.getOrder() ? -1 : 1);
        }
    }

    private static enum State {
        STARTED,
        STOPPED,
        PENDING;

    }
}

