/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.eclipse.riena.internal.core.cache.ICacheEntry;

public class SoftCacheEntry<K, V>
implements ICacheEntry<K, V> {
    private K key;
    private long timestamp;
    private SoftReference<V> value;

    public SoftCacheEntry(K key) {
        this.key = key;
        this.timestamp = System.currentTimeMillis();
    }

    public SoftCacheEntry(V value, K key, ReferenceQueue<V> queue) {
        this(key);
        if (value != null) {
            this.value = new SoftReference<V>(value, queue);
        }
    }

    @Override
    public V getValue() {
        return this.value.get();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

