/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.injector.extension;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.core.injector.extension.ExtensionInterface;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ExtensionPointId {
    private final String rawId;
    private List<String> normalizedIds;
    private static final String DOT = ".";
    private static final String ID = "ID";

    public ExtensionPointId() {
        this.rawId = null;
    }

    public ExtensionPointId(String id) {
        this.rawId = id;
    }

    public void normalize(Class<?> extensionInterface) {
        if (this.normalizedIds != null) {
            return;
        }
        this.normalizedIds = this.getNormalizedAndFullyQualifiedExtensionPointIds(extensionInterface);
    }

    public Iterable<String> compatibleIds() {
        if (this.normalizedIds == null) {
            throw new IllegalStateException("ExceptionPointId has not been normalized");
        }
        return this.normalizedIds;
    }

    private List<String> getNormalizedAndFullyQualifiedExtensionPointIds(Class<?> extensionInterface) {
        List<String> ids = this.split(this.getRawExtensionPointId(this.rawId, extensionInterface));
        ArrayList<String> result = new ArrayList<String>(ids.size());
        for (String id : ids) {
            if (id.contains(DOT)) {
                result.add(id);
                continue;
            }
            Bundle bundle = FrameworkUtil.getBundle(extensionInterface);
            if (bundle != null) {
                result.add(String.valueOf(bundle.getSymbolicName()) + DOT + id);
                continue;
            }
            result.add(id);
        }
        return result;
    }

    private List<String> split(String rawId) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        int fromIndex = 0;
        while ((i = rawId.indexOf(44, fromIndex)) > 0) {
            result.add(rawId.substring(fromIndex, i));
            fromIndex = i + 1;
        }
        result.add(rawId.substring(fromIndex));
        return result;
    }

    private String getRawExtensionPointId(String id, Class<?> extensionInterface) {
        if (StringUtils.isGiven(id)) {
            return id;
        }
        ExtensionInterface extensionInterfaceAnnotation = extensionInterface.getAnnotation(ExtensionInterface.class);
        if (extensionInterfaceAnnotation != null && StringUtils.isGiven(extensionInterfaceAnnotation.id())) {
            return extensionInterfaceAnnotation.id();
        }
        try {
            Field idField = extensionInterface.getField(ID);
            Object value = idField.get(null);
            if (value instanceof String) {
                return (String)value;
            }
        }
        catch (Exception exception) {
            Nop.reason("Fall throuh!");
        }
        throw new IllegalStateException("It was not possible to retrieve an extension point id from extension interface " + extensionInterface);
    }

    public String toString() {
        return "ExtensionPointId [normalizedIds=" + this.normalizedIds + ", rawId=" + this.rawId + "]";
    }
}

