/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import org.eclipse.riena.internal.core.logging.LogLevelMapper;
import org.osgi.framework.ServiceReference;

public class DeferredLogEvent {
    private final String loggerName;
    private final long time;
    private final String threadName;
    private final Method log;
    private final Object[] args;

    public DeferredLogEvent(String loggerName, long time, String threadName, Method log, Object[] args) {
        this.loggerName = loggerName;
        this.time = time;
        this.threadName = threadName;
        this.log = log;
        this.args = args;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public long getTime() {
        return this.time;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Method getLogMethod() {
        return this.log;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public int getLevel() {
        Object[] objectArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg instanceof Integer) {
                return (Integer)arg;
            }
            ++n2;
        }
        return 4;
    }

    public String toString() {
        StringBuilder bob = new StringBuilder("DeferredLogEvent on ");
        bob.append(new Date(this.getTime())).append(" (").append(this.getTime());
        bob.append(" ms) in thread [").append(this.getThreadName()).append("]:\n\t\t");
        this.appendArgs(bob, this.getArgs());
        return bob.toString();
    }

    private void appendArgs(StringBuilder bob, Object[] args) {
        if (args == null) {
            return;
        }
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg instanceof ServiceReference) {
                ServiceReference ref = (ServiceReference)arg;
                String bundleName = ref.getBundle() != null ? ref.getBundle().getSymbolicName() : null;
                bob.append("ServiceReference( bundle=").append(bundleName).append(", properties=(");
                String[] stringArray = ref.getPropertyKeys();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String key = stringArray[n4];
                    bob.append(key).append("=").append(ref.getProperty(key)).append(",");
                    ++n4;
                }
                bob.append(")");
            } else if (arg instanceof String) {
                bob.append("Message(").append((String)arg).append(')');
            } else if (arg instanceof Integer) {
                bob.append("LogLevel(").append(LogLevelMapper.getValue((Integer)arg)).append(')');
            } else if (arg instanceof Throwable) {
                Throwable throwable = (Throwable)arg;
                bob.append("Throwable(");
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                throwable.printStackTrace(writer);
                writer.close();
                bob.append(stringWriter.toString()).append(')');
            } else {
                bob.append("Object(").append(arg).append(')');
            }
            bob.append(", ");
            ++n2;
        }
        bob.setLength(bob.length() - 2);
    }
}

