/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.riena.e4.launcher.part.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.menus.MenuFactoryGenerator;
import org.eclipse.ui.internal.services.RegistryPersistence;

public final class MenuPersistence
extends RegistryPersistence {
    private final MApplication application;
    private final IEclipseContext appContext;
    private final ArrayList<MenuAdditionCacheEntry> cacheEntries = new ArrayList();
    private final ArrayList<MMenuContribution> menuContributions = new ArrayList();
    private final ArrayList<MToolBarContribution> toolBarContributions = new ArrayList();
    private final ArrayList<MTrimContribution> trimContributions = new ArrayList();
    private final Comparator<IConfigurationElement> comparer = new Comparator<IConfigurationElement>(){

        @Override
        public int compare(IConfigurationElement c1, IConfigurationElement c2) {
            return c1.getContributor().getName().compareToIgnoreCase(c2.getContributor().getName());
        }
    };
    private Pattern contributorFilter;

    public MenuPersistence(MApplication application, IEclipseContext appContext) {
        this.application = application;
        this.appContext = appContext;
    }

    public MenuPersistence(MApplication application, IEclipseContext appContext, String filterRegex) {
        this(application, appContext);
        this.contributorFilter = Pattern.compile(filterRegex);
    }

    public void dispose() {
        ControlContributionRegistry.clear();
        this.application.getMenuContributions().removeAll(this.menuContributions);
        this.application.getToolBarContributions().removeAll(this.toolBarContributions);
        this.application.getTrimContributions().removeAll(this.trimContributions);
        this.menuContributions.clear();
        this.cacheEntries.clear();
        super.dispose();
    }

    protected boolean isChangeImportant(IRegistryChangeEvent event) {
        return false;
    }

    public void reRead() {
        this.read();
    }

    protected final void read() {
        super.read();
        this.readAdditions();
        ArrayList<MMenuContribution> tmp = new ArrayList<MMenuContribution>(this.menuContributions);
        this.menuContributions.clear();
        ContributionsAnalyzer.mergeContributions(tmp, this.menuContributions);
        this.application.getMenuContributions().addAll(this.menuContributions);
        ArrayList<MToolBarContribution> tmpToolbar = new ArrayList<MToolBarContribution>(this.toolBarContributions);
        this.toolBarContributions.clear();
        ContributionsAnalyzer.mergeToolBarContributions(tmpToolbar, this.toolBarContributions);
        this.application.getToolBarContributions().addAll(this.toolBarContributions);
        ArrayList<MTrimContribution> tmpTrim = new ArrayList<MTrimContribution>(this.trimContributions);
        this.trimContributions.clear();
        ContributionsAnalyzer.mergeTrimContributions(tmpTrim, this.trimContributions);
        this.application.getTrimContributions().addAll(this.trimContributions);
    }

    private void readAdditions() {
        IConfigurationElement[] menusExtensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = menusExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int n = menusExtensionPoint.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("menuContribution".equals(element.getName()) && (this.contributorFilter == null || this.contributorFilter.matcher(element.getContributor().getName()).matches())) {
                configElements.add(element);
            }
            ++n2;
        }
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement configElement : configElements) {
            if (this.isProgramaticContribution(configElement)) {
                MenuFactoryGenerator gen = new MenuFactoryGenerator(this.application, this.appContext, configElement, configElement.getAttribute("locationURI"));
                gen.mergeIntoModel(this.menuContributions, this.toolBarContributions, this.trimContributions);
                continue;
            }
            MenuAdditionCacheEntry menuContribution = new MenuAdditionCacheEntry(this.application, this.appContext, configElement, configElement.getAttribute("locationURI"), configElement.getNamespaceIdentifier());
            this.cacheEntries.add(menuContribution);
            menuContribution.mergeIntoModel(this.menuContributions, this.toolBarContributions, this.trimContributions);
        }
    }

    private boolean isProgramaticContribution(IConfigurationElement menuAddition) {
        return menuAddition.getAttribute("class") != null;
    }
}

