/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.riena.e4.launcher.part.RienaPartHelper;
import org.eclipse.riena.e4.launcher.part.ViewInstanceProvider;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.swt.widgets.Composite;

public class PartWrapper {
    public static final String VIEW_KEY = String.valueOf(PartWrapper.class.getName()) + ".rienaNavigationNodeView";
    private static final String VIEWS_EXT_POINT = "org.eclipse.ui.views";
    @Inject
    private IExtensionRegistry extensionRegistry;
    private SubModuleView view;

    @Inject
    public void create(Composite parent, MPart part) {
        SubModuleView viewInstance;
        SwtViewId swtViewId = RienaPartHelper.extractRienaCompoundId((MUIElement)part);
        ISubModuleNode node = (ISubModuleNode)SwtViewProvider.getInstance().getNavigationNode(swtViewId.getId(), swtViewId.getSecondary(), ISubModuleNode.class);
        if (RienaPartHelper.isSharedView(node) && (viewInstance = ViewInstanceProvider.getInstance().getView(swtViewId)) != null) {
            return;
        }
        this.view = this.createView(swtViewId);
    }

    public SubModuleView getView() {
        return this.view;
    }

    private SubModuleView createView(SwtViewId swtViewId) {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = this.extensionRegistry.getConfigurationElementsFor(VIEWS_EXT_POINT);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (swtViewId.getId().equals(element.getAttribute("id"))) {
                try {
                    SubModuleView viewInstance = (SubModuleView)element.createExecutableExtension("class");
                    ViewInstanceProvider.getInstance().registerView(swtViewId, viewInstance);
                    return viewInstance;
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }
}

