/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.security;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.riena.navigation.ui.swt.application.LoginNonActivityTimer;

public abstract class LoginExecutor
implements LoginNonActivityTimer.ILoginExecutor<Integer> {
    private final List<MWindow> showAfterLogin = new ArrayList<MWindow>();
    private final IEclipseContext eclipseContext;
    private final int nonActivityDuration;

    public LoginExecutor(IEclipseContext eclipseContext, int nonActivityDuration) {
        this.nonActivityDuration = nonActivityDuration;
        Assert.isNotNull((Object)eclipseContext);
        this.eclipseContext = eclipseContext;
    }

    public void prePerformLogin() throws Exception {
        this.showAfterLogin.clear();
        EModelService modelService = (EModelService)this.eclipseContext.get(EModelService.class);
        List windows = modelService.findElements((MUIElement)this.eclipseContext.get(MApplication.class), null, MWindow.class, null);
        for (MWindow w : windows) {
            if (!w.isVisible()) continue;
            w.setVisible(false);
            this.showAfterLogin.add(w);
        }
    }

    public void postPerformLogin(Integer result) throws Exception {
        if (IApplication.EXIT_OK.equals(result)) {
            for (MWindow w : this.showAfterLogin) {
                w.setVisible(true);
            }
            this.showAfterLogin.clear();
        } else {
            System.exit(0);
        }
    }

    public int getNonActivityDuration() {
        return this.nonActivityDuration;
    }
}

