/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.lang.reflect.Constructor;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.ModuleGroupController;
import org.eclipse.riena.navigation.ui.swt.views.IViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.navigation.ui.swt.views.desc.IModuleDescriptionExtension;
import org.eclipse.riena.navigation.ui.swt.views.desc.IModuleGroupDescriptionExtension;
import org.eclipse.swt.widgets.Composite;

public class NavigationViewFactory
implements IViewFactory {
    private IModuleDescriptionExtension moduleDescriptionExtension;
    private IModuleGroupDescriptionExtension moduleGroupDescriptionExtension;

    @InjectExtension(min=0, max=1)
    public void update(IModuleDescriptionExtension moduleView) {
        this.moduleDescriptionExtension = moduleView;
    }

    @InjectExtension(min=0, max=1)
    public void update(IModuleGroupDescriptionExtension moduleGroup) {
        this.moduleGroupDescriptionExtension = moduleGroup;
    }

    @Override
    public ModuleGroupView createModuleGroupView(Composite parent) {
        Class<ModuleGroupView> moduleGroupClazz;
        if (this.moduleGroupDescriptionExtension != null && (moduleGroupClazz = this.moduleGroupDescriptionExtension.getView()) != null) {
            try {
                Constructor<ModuleGroupView> constructor = moduleGroupClazz.getConstructor(Composite.class, Integer.TYPE);
                return constructor.newInstance(parent, 0);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleGroupView " + moduleGroupClazz + " failed.", e);
            }
        }
        return new ModuleGroupView(parent, 0);
    }

    @Override
    public ModuleGroupController createModuleGroupController(IModuleGroupNode moduleGroupNode) {
        Class<ModuleGroupController> moduleGroupClazz;
        ModuleGroupController controller = null;
        if (moduleGroupNode.getNavigationNodeController() instanceof ModuleGroupController) {
            return (ModuleGroupController)moduleGroupNode.getNavigationNodeController();
        }
        if (this.moduleGroupDescriptionExtension != null && (moduleGroupClazz = this.moduleGroupDescriptionExtension.getController()) != null) {
            try {
                Constructor<ModuleGroupController> constructor = moduleGroupClazz.getConstructor(IModuleGroupNode.class);
                controller = constructor.newInstance(moduleGroupNode);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleGroupController " + moduleGroupClazz + " failed.", e);
            }
        }
        if (controller == null) {
            controller = new ModuleGroupController(moduleGroupNode);
        }
        controller.setNavigationNode((INavigationNode)moduleGroupNode);
        return controller;
    }

    @Override
    public ModuleView createModuleView(Composite parent) {
        if (this.moduleDescriptionExtension != null) {
            Class<ModuleView> moduleViewClazz = this.moduleDescriptionExtension.getView();
            try {
                Constructor<ModuleView> constructor = moduleViewClazz.getConstructor(Composite.class);
                return constructor.newInstance(parent);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleView " + moduleViewClazz + " failed.", e);
            }
        }
        return new ModuleView(parent);
    }

    @Override
    public ModuleController createModuleController(IModuleNode moduleNode) {
        Class<ModuleController> moduleViewClazz;
        SWTModuleController controller = null;
        if (moduleNode.getNavigationNodeController() instanceof ModuleController) {
            return (ModuleController)moduleNode.getNavigationNodeController();
        }
        if (this.moduleDescriptionExtension != null && (moduleViewClazz = this.moduleDescriptionExtension.getController()) != null) {
            try {
                Constructor<ModuleController> constructor = moduleViewClazz.getConstructor(IModuleNode.class);
                controller = constructor.newInstance(moduleNode);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleController " + moduleViewClazz + " failed.", e);
            }
        }
        if (controller == null) {
            controller = new SWTModuleController(moduleNode);
        }
        controller.setNavigationNode((INavigationNode)moduleNode);
        return controller;
    }
}

