/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.annotation.processor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.annotation.OnNavigationNodeEvent;

public final class NavigationNodeControllerAnnotationProcessor {
    private static final SingletonProvider<NavigationNodeControllerAnnotationProcessor> NNCAP = new SingletonProvider(NavigationNodeControllerAnnotationProcessor.class);
    private final Map<INavigationNodeController, ?> alreadyProcessed = new WeakHashMap();

    public static NavigationNodeControllerAnnotationProcessor getInstance() {
        return (NavigationNodeControllerAnnotationProcessor)NNCAP.getInstance();
    }

    private NavigationNodeControllerAnnotationProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnnotations(INavigationNodeController navigationNodeController) {
        Map<INavigationNodeController, ?> map = this.alreadyProcessed;
        synchronized (map) {
            if (this.alreadyProcessed.containsKey(navigationNodeController)) {
                return;
            }
            this.alreadyProcessed.put(navigationNodeController, null);
        }
        this.processAnnotations(navigationNodeController, navigationNodeController.getClass());
    }

    private void processAnnotations(INavigationNodeController navigationNodeController, Class<?> targetClazz) {
        if (!INavigationNodeController.class.isAssignableFrom(targetClazz)) {
            return;
        }
        this.processAnnotations(navigationNodeController, targetClazz.getSuperclass());
        Map<String, Method> events = this.getEventMethodMap(navigationNodeController, targetClazz);
        if (!events.isEmpty()) {
            navigationNodeController.getNavigationNode().addSimpleListener(this.createListener(events, navigationNodeController));
        }
    }

    private Map<String, Method> getEventMethodMap(INavigationNodeController navigationNodeController, Class<?> targetClazz) {
        HashMap<String, Method> events = new HashMap<String, Method>();
        Method[] methodArray = targetClazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            OnNavigationNodeEvent onNavigationNodeEvent = method.getAnnotation(OnNavigationNodeEvent.class);
            if (onNavigationNodeEvent != null) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                events.put(onNavigationNodeEvent.event().getMethodName(), method);
            }
            ++n2;
        }
        return events;
    }

    private ISimpleNavigationNodeListener createListener(Map<String, Method> events, INavigationNodeController navigationNodeController) {
        return (ISimpleNavigationNodeListener)Proxy.newProxyInstance(navigationNodeController.getClass().getClassLoader(), new Class[]{ISimpleNavigationNodeListener.class}, (InvocationHandler)new ListenerHandler(events, navigationNodeController));
    }

    private static class ListenerHandler
    implements InvocationHandler {
        private final Map<String, Method> events;
        private final INavigationNodeController navigationNodeController;

        public ListenerHandler(Map<String, Method> events, INavigationNodeController navigationNodeController) {
            this.events = events;
            this.navigationNodeController = navigationNodeController;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method targetMethod;
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (methodName.equals("equals")) {
                    if (proxy == args[0]) {
                        return true;
                    }
                    return false;
                }
                if (methodName.equals("toString")) {
                    return "Proxy for " + ISimpleNavigationNodeListener.class.getName() + " " + proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
                }
            }
            if ((targetMethod = this.events.get(methodName)) != null) {
                if (targetMethod.getParameterTypes().length == 0) {
                    return targetMethod.invoke((Object)this.navigationNodeController, new Object[0]);
                }
                return targetMethod.invoke((Object)this.navigationNodeController, args);
            }
            return null;
        }
    }
}

