/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.Trace;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IJumpTargetListener;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationHistoryListener;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ExtensionPointFailure;
import org.eclipse.riena.navigation.model.JumpContext;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationHistoryEvent;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.riena.navigation.model.NavigationNodeProvider;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;

public class NavigationProcessor
implements INavigationProcessor {
    private List<ISubModuleNode> collNodes;
    private final Stack<INavigationNode<?>> histBack = new Stack();
    private final Stack<INavigationNode<?>> histForward = new Stack();
    private final Map<INavigationNode<?>, Stack<JumpContext>> jumpTargets = new HashMap();
    private final Map<INavigationNode<?>, List<IJumpTargetListener>> jumpTargetListeners = new HashMap();
    private final Map<INavigationNode<?>, INavigationNode<?>> navigationMap = new HashMap();
    private final List<INavigationHistoryListener> navigationListener = new Vector<INavigationHistoryListener>();
    private static final int MAX_HISTORY_LENGTH = 40;
    private static final boolean DEBUG_NAVIGATION_PROCESSOR = Trace.isOn(NavigationProcessor.class, (String)"debug");
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), NavigationProcessor.class);

    @Override
    public void activate(INavigationNode<?> toActivate) {
        if (toActivate != null) {
            IModuleNode moduleNode = toActivate.getParentOfType(IModuleNode.class);
            this.collNodes = this.collectCollapsedNodes(moduleNode);
            if (toActivate.isActivated()) {
                if (DEBUG_NAVIGATION_PROCESSOR) {
                    LOGGER.log(4, "NaviProc: - activate triggered for Node " + toActivate.getNodeId() + "but is already activated --> NOP");
                }
                Nop.reason((String)"see comment below.");
            } else {
                if (DEBUG_NAVIGATION_PROCESSOR) {
                    LOGGER.log(4, "NaviProc: - activate triggered for Node " + toActivate.getNodeId());
                }
                if (!toActivate.isVisible() || !toActivate.isEnabled()) {
                    if (DEBUG_NAVIGATION_PROCESSOR) {
                        LOGGER.log(4, "NaviProc: - activate triggered for Node " + toActivate.getNodeId() + "but is not visible or not enabled --> NOP");
                    }
                    return;
                }
                List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnActivation(toActivate);
                if (toActivateList.isEmpty()) {
                    return;
                }
                List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnActivation(toActivate);
                NavigationContext navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
                if (this.allowsDeactivate(navigationContext)) {
                    if (this.allowsActivate(navigationContext)) {
                        navigationContext = new NavigationContext(null, this.getNodesToActivateOnActivation(toActivate), this.getNodesToDeactivateOnActivation(toActivate));
                        this.deactivate(navigationContext);
                        this.activate(navigationContext);
                    } else {
                        INavigationNode<?> currentActive = this.getActiveChild(toActivate.getParent());
                        if (currentActive == null) {
                            return;
                        }
                        toActivateList.clear();
                        toActivateList.add(currentActive);
                        toDeactivateList.clear();
                        navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
                        this.activate(navigationContext);
                        currentActive.onAfterActivate(navigationContext);
                    }
                }
            }
        }
    }

    @Override
    public void markNodesToCollapse(INavigationNode<?> toActivate) {
        if (toActivate.getContext("fromUI") == null) {
            if (this.collNodes != null) {
                for (ISubModuleNode node : this.collNodes) {
                    if (!node.isExpanded()) continue;
                    node.setCloseSubTree(true);
                }
            }
        } else {
            toActivate.removeContext("fromUI");
        }
    }

    private boolean isJumpSource(ISubModuleNode node) {
        for (Map.Entry<INavigationNode<?>, Stack<JumpContext>> entry : this.jumpTargets.entrySet()) {
            Stack<JumpContext> value = entry.getValue();
            if (value.isEmpty() || !value.peek().getSource().equals(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeOrChildJumpSource(ISubModuleNode node) {
        List children = node.getChildren();
        if (this.isJumpSource(node)) {
            this.exemptNodeFromCollapsing(node);
            return true;
        }
        for (ISubModuleNode child : children) {
            if (!this.isJumpSource(child)) continue;
            node.setCloseSubTree(false);
            this.exemptNodeFromCollapsing(child);
            return true;
        }
        return false;
    }

    private void exemptNodeFromCollapsing(ISubModuleNode node) {
        node.setCloseSubTree(false);
        ISubModuleNode parent = node.getParentOfType(ISubModuleNode.class);
        while (parent != null) {
            if (this.collNodes.contains(parent)) {
                parent.setCloseSubTree(false);
            }
            parent = parent.getParentOfType(ISubModuleNode.class);
        }
    }

    private List<ISubModuleNode> collectCollapsedNodes(INavigationNode<?> node) {
        LinkedList<ISubModuleNode> collapsedNodes = new LinkedList<ISubModuleNode>();
        List<Object> children = new LinkedList();
        if (node instanceof IModuleNode) {
            children = ((IModuleNode)node).getChildren();
        } else if (node instanceof ISubModuleNode) {
            children = ((ISubModuleNode)node).getChildren();
        }
        for (ISubModuleNode child : children) {
            if (!(collapsedNodes.contains(child) || child.isExpanded() && !child.isCloseSubTree() || this.isNodeOrChildJumpSource(child))) {
                collapsedNodes.add(child);
            }
            if (child.isLeaf()) continue;
            collapsedNodes.addAll(this.collectCollapsedNodes(child));
        }
        return collapsedNodes;
    }

    @Override
    public void prepare(INavigationNode<?> toPrepare) {
        LinkedList toPreparedList = new LinkedList();
        toPreparedList.add(toPrepare);
        NavigationContext navigationContext = new NavigationContext(toPreparedList, null, null);
        toPrepare.prepare(navigationContext);
    }

    private void buildHistory(INavigationNode<?> toActivate) {
        if (!(toActivate instanceof ISubModuleNode) || toActivate.isDisposed()) {
            return;
        }
        if (this.histBack.isEmpty() || !this.histBack.peek().equals(toActivate)) {
            this.histBack.push(toActivate);
            if (this.histBack.size() > 40) {
                this.histBack.remove(this.histBack.firstElement());
            }
            this.fireBackHistoryChangedEvent();
        }
        if (!this.histForward.isEmpty() && this.histForward.peek().equals(toActivate)) {
            this.histForward.pop();
            this.fireForewardHistoryChangedEvent();
        }
    }

    @Override
    public void dispose(INavigationNode<?> toDispose) {
        INavigationNode<?> nodeToDispose = this.getNodeToDispose(toDispose);
        if (nodeToDispose != null && !nodeToDispose.isDisposed()) {
            INavigationNode.State nodeStartState = nodeToDispose.getState();
            IApplicationNode applicationNode = nodeToDispose.getParentOfType(IApplicationNode.class);
            this.handleJumpsOnDispose(nodeToDispose);
            List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnDispose(nodeToDispose);
            Boolean oldSelectable = null;
            if (toDispose instanceof ISubModuleNode) {
                oldSelectable = ((ISubModuleNode)toDispose).isSelectable();
                ((ISubModuleNode)toDispose).setSelectable(false);
            }
            List<INavigationNode<?>> toActivateList = null;
            try {
                try {
                    toActivateList = this.getNodesToActivateOnDispose(nodeToDispose);
                }
                catch (NavigationModelFailure ex) {
                    String msg = "Dispose is not allowed for: " + toDispose.toString();
                    msg = String.valueOf(msg) + "\n" + ex.getMessage();
                    LOGGER.log(1, msg);
                    if (toDispose instanceof ISubModuleNode && oldSelectable != null) {
                        ((ISubModuleNode)toDispose).setSelectable(oldSelectable);
                    }
                    return;
                }
            }
            finally {
                if (toDispose instanceof ISubModuleNode && oldSelectable != null) {
                    ((ISubModuleNode)toDispose).setSelectable(oldSelectable);
                }
            }
            NavigationContext navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
            if (this.allowsDeactivate(navigationContext) && this.allowsDispose(navigationContext) && this.allowsActivate(navigationContext)) {
                if (nodeStartState != nodeToDispose.getState()) {
                    String msg = String.format("State of node '%s' changed unexpected!", toDispose);
                    throw new NavigationModelFailure(msg);
                }
                this.deactivate(navigationContext);
                this.dispose(navigationContext);
                Object target = toDispose.getContext("riena.navigation.navigateAfterDispose");
                if (target instanceof NavigationNodeId && applicationNode != null) {
                    NavigationNodeId targetId = (NavigationNodeId)target;
                    this.navigate(applicationNode, targetId, new NavigationArgument());
                } else {
                    this.activate(navigationContext);
                }
            }
            this.cleanupHistory(nodeToDispose);
            this.cleanupJumpTargetListeners(nodeToDispose);
        }
    }

    @Override
    public void addMarker(INavigationNode<?> node, IMarker marker) {
        if (node != null) {
            INavigationNode<?> nodeToHide;
            if (node.isActivated() && (marker instanceof DisabledMarker || marker instanceof HiddenMarker) && (nodeToHide = this.getNodeToDispose(node)) != null) {
                List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnDispose(nodeToHide);
                List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnDispose(nodeToHide);
                NavigationContext navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
                if (this.allowsDeactivate(navigationContext) && this.allowsActivate(navigationContext)) {
                    this.deactivate(navigationContext);
                    this.activate(navigationContext);
                } else {
                    return;
                }
            }
            if (marker instanceof DisabledMarker || marker instanceof HiddenMarker) {
                node.setSelected(false);
            }
            LinkedList toMarkList = new LinkedList();
            toMarkList.add(node);
            NavigationContext navigationContext = new NavigationContext(null, toMarkList, null);
            this.addMarker(navigationContext, marker);
        }
    }

    private void addMarker(INavigationContext context, IMarker marker) {
        for (INavigationNode<?> node : context.getToActivate()) {
            node.addMarker(context, marker);
        }
    }

    private void cleanupHistory(INavigationNode<?> toDispose) {
        while (this.histBack.contains(toDispose)) {
            this.histBack.remove(toDispose);
        }
        this.fireBackHistoryChangedEvent();
        boolean fhc = false;
        while (this.histForward.contains(toDispose)) {
            this.histForward.remove(toDispose);
            fhc = true;
        }
        if (fhc) {
            this.fireForewardHistoryChangedEvent();
        }
        if (this.navigationMap.containsKey(toDispose)) {
            this.navigationMap.remove(toDispose);
        }
    }

    @Override
    public INavigationNode<?> create(INavigationNode<?> sourceNode, NavigationNodeId targetId) {
        return this.provideNode(sourceNode, targetId, null);
    }

    @Override
    public INavigationNode<?> create(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        return this.provideNode(sourceNode, targetId, argument);
    }

    @Override
    public void move(INavigationNode<?> sourceNode, NavigationNodeId targetId) {
        Assert.isTrue((boolean)ModuleNode.class.isAssignableFrom(sourceNode.getClass()));
        ModuleNode sourceModuleNode = (ModuleNode)ModuleNode.class.cast(sourceNode);
        INavigationNode<?> targetNode = this.create(sourceNode, targetId);
        Assert.isTrue((boolean)ModuleGroupNode.class.isAssignableFrom(targetNode.getClass()));
        ModuleGroupNode targetModuleGroup = (ModuleGroupNode)ModuleGroupNode.class.cast(targetNode);
        ModuleGroupNode oldParentModuleGroup = (ModuleGroupNode)ModuleGroupNode.class.cast(sourceModuleNode.getParent());
        if (targetModuleGroup.equals(oldParentModuleGroup)) {
            return;
        }
        boolean isActivated = sourceModuleNode.isActivated();
        boolean isBlocked = sourceModuleNode.isBlocked();
        boolean isEnabled = sourceModuleNode.isEnabled();
        boolean isVisible = sourceModuleNode.isVisible();
        sourceModuleNode.dispose(null);
        sourceModuleNode.deactivate(null);
        oldParentModuleGroup.removeChild(sourceModuleNode);
        targetModuleGroup.addChild(sourceModuleNode);
        for (ISubModuleNode child : sourceModuleNode.getChildren()) {
            child.setParent(sourceModuleNode);
        }
        sourceModuleNode.setBlocked(isBlocked || targetModuleGroup.isBlocked());
        sourceModuleNode.setEnabled(isEnabled && targetModuleGroup.isEnabled());
        sourceModuleNode.setVisible(isVisible && targetModuleGroup.isVisible());
        if (isActivated) {
            sourceModuleNode.activate();
        }
        if (oldParentModuleGroup.getChildren().size() == 0) {
            oldParentModuleGroup.dispose();
        } else {
            ((IModuleNode)oldParentModuleGroup.getChild(0)).setSelected(true);
        }
    }

    @Override
    public INavigationNode<?> navigate(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument navigation) {
        return this.navigateSync(sourceNode, targetId, navigation, NavigationType.DEFAULT);
    }

    private INavigationNode<?> navigateSync(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument navigation, NavigationType navigationType) {
        INavigationNode<?> targetNode = null;
        try {
            targetNode = this.provideNode(sourceNode, targetId, navigation);
        }
        catch (NavigationModelFailure failure) {
            LOGGER.log(1, failure.getMessage());
        }
        if (targetNode == null) {
            return null;
        }
        INavigationNode<?> activateNode = targetNode.findNode(targetId);
        INavigationNode<?> node = activateNode;
        if (node == null) {
            node = targetNode;
        }
        if (!(sourceNode instanceof IApplicationNode)) {
            this.navigationMap.put(node, sourceNode);
        }
        if (NavigationType.JUMP == navigationType) {
            this.handleJump(sourceNode, node);
        }
        node.activate();
        try {
            this.setFocusOnRidget(node, navigation);
        }
        catch (NavigationModelFailure failure) {
            LOGGER.log(1, failure.getMessage());
        }
        return node;
    }

    private void handleJump(final INavigationNode<?> sourceNode, final INavigationNode<?> node) {
        this.runObserved(sourceNode, new Runnable(){

            @Override
            public void run() {
                NavigationProcessor.this.registerJump(sourceNode, node);
            }
        });
    }

    private INavigationNode<?> getRootNode(INavigationNode<?> node) {
        INavigationNode<?> topNode = node;
        while (topNode.getParent() != null) {
            topNode = topNode.getParent();
        }
        return topNode;
    }

    private Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> saveJumpState(INavigationNode<?> node) {
        INavigationNode<?> topNode = this.getRootNode(node);
        HashMap savedJumpState = new HashMap();
        this.saveJumpState(topNode, savedJumpState);
        return savedJumpState;
    }

    private void saveJumpState(INavigationNode<?> root, Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> savedJumpState) {
        savedJumpState.put(root, this.isJumpTarget(root) ? IJumpTargetListener.JumpTargetState.ENABLED : IJumpTargetListener.JumpTargetState.DISABLED);
        for (INavigationNode child : root.getChildren()) {
            this.saveJumpState(child, savedJumpState);
        }
    }

    private void notifyJumpStateChanged(INavigationNode<?> node, Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> oldJumpState) {
        Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> savedJumpState = this.saveJumpState(node);
        for (Map.Entry<INavigationNode<?>, IJumpTargetListener.JumpTargetState> entry : savedJumpState.entrySet()) {
            if (oldJumpState.get(entry.getKey()) == entry.getValue()) continue;
            this.notifyJumpStateChanged(entry.getKey(), entry.getValue());
        }
    }

    private void notifyJumpStateChanged(INavigationNode<?> node, IJumpTargetListener.JumpTargetState jumpTargetState) {
        List<IJumpTargetListener> listeners = this.jumpTargetListeners.get(node);
        if (listeners == null) {
            return;
        }
        for (IJumpTargetListener listener : listeners) {
            listener.jumpTargetStateChanged(node, jumpTargetState);
        }
    }

    private void registerJump(INavigationNode<?> source, INavigationNode<?> target) {
        Stack<JumpContext> sourceStack = this.jumpTargets.get(target);
        if (sourceStack == null) {
            sourceStack = new Stack();
            this.jumpTargets.put(target, sourceStack);
        }
        if (sourceStack.size() == 0 || !sourceStack.peek().getSource().equals(source)) {
            sourceStack.push(new JumpContext(source, target));
        }
    }

    private void handleJumpsOnDispose(final INavigationNode<?> node) {
        this.runObserved(node, new Runnable(){

            @Override
            public void run() {
                NavigationProcessor.this.unregisterNodeJumps(node);
            }
        });
    }

    private void unregisterNodeJumps(INavigationNode<?> node) {
        this.jumpTargets.remove(node);
        Iterator<Map.Entry<INavigationNode<?>, Stack<JumpContext>>> it = this.jumpTargets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<INavigationNode<?>, Stack<JumpContext>> entry = it.next();
            Stack<JumpContext> entryStack = entry.getValue();
            JumpContext ctx = null;
            for (JumpContext ictx : entryStack) {
                if (!ictx.getSource().equals(node)) continue;
                ctx = ictx;
            }
            entryStack.remove(ctx);
            if (!entryStack.isEmpty()) continue;
            it.remove();
        }
        for (INavigationNode child : node.getChildren()) {
            this.unregisterNodeJumps(child);
        }
    }

    @Override
    public void jump(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        this.navigateSync(sourceNode, targetId, argument, NavigationType.JUMP);
    }

    @Override
    public void jumpBack(final INavigationNode<?> node) {
        this.runObserved(node, new Runnable(){

            @Override
            public void run() {
                NavigationProcessor.this.jumpBackInternal(node);
            }
        });
    }

    @Override
    public INavigationNode<?> getTentativeJumpBackTarget(INavigationNode<?> node) {
        INavigationNode<?> lastJumpedNode = this.getLastJump(node);
        Stack<JumpContext> sourceStack = this.jumpTargets.get(lastJumpedNode);
        if (sourceStack == null) {
            return null;
        }
        if (!sourceStack.isEmpty()) {
            return sourceStack.peek().getSource();
        }
        return null;
    }

    private void jumpBackInternal(INavigationNode<?> node) {
        INavigationNode<?> lastJumpedNode = this.getLastJump(node);
        Stack<JumpContext> sourceStack = this.jumpTargets.get(lastJumpedNode);
        if (sourceStack == null) {
            return;
        }
        if (!sourceStack.isEmpty()) {
            INavigationNode<?> backTarget = sourceStack.pop().getSource();
            this.setCloseSubTreeOnJumpBack(backTarget);
            if (sourceStack.isEmpty()) {
                this.jumpTargets.remove(lastJumpedNode);
            }
            backTarget.activate();
        }
    }

    private void runObserved(INavigationNode<?> node, Runnable runnable) {
        Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> savedJumpState = this.saveJumpState(node);
        runnable.run();
        this.notifyJumpStateChanged(node, savedJumpState);
    }

    private INavigationNode<?> getLastJump(INavigationNode<?> node) {
        ModuleGroupNode moduleGroupNode;
        ModuleGroupNode moduleGroupNode2 = moduleGroupNode = node instanceof ModuleGroupNode ? node : node.getParentOfType(ModuleGroupNode.class);
        if (moduleGroupNode == null) {
            return node;
        }
        LinkedList nodes = new LinkedList();
        this.collectNodes(moduleGroupNode, nodes);
        ArrayList<JumpContext> latestJumpSources = new ArrayList<JumpContext>();
        for (INavigationNode iNavigationNode : nodes) {
            if (!this.jumpTargets.containsKey(iNavigationNode)) continue;
            latestJumpSources.add(this.jumpTargets.get(iNavigationNode).peek());
        }
        if (latestJumpSources.size() > 0) {
            Collections.sort(latestJumpSources);
            return ((JumpContext)latestJumpSources.get(latestJumpSources.size() - 1)).getTarget();
        }
        return null;
    }

    private void collectNodes(INavigationNode<?> root, List<INavigationNode<?>> nodes) {
        nodes.add(root);
        for (INavigationNode child : root.getChildren()) {
            this.collectNodes(child, nodes);
        }
    }

    private void setCloseSubTreeOnJumpBack(INavigationNode<?> backTarget) {
        if (backTarget.isLeaf() && backTarget.getParentOfType(ISubModuleNode.class) != null) {
            backTarget.getParentOfType(ISubModuleNode.class).setCloseSubTree(true);
        } else {
            ((ISubModuleNode)backTarget).setCloseSubTree(true);
        }
    }

    @Override
    public boolean isJumpTarget(INavigationNode<?> node) {
        ModuleGroupNode moduleGroupNode = node.getParentOfType(ModuleGroupNode.class);
        INavigationNode<?> targetNode = null;
        targetNode = moduleGroupNode == null ? node : this.getLastJump(moduleGroupNode);
        Stack<JumpContext> sourceStack = this.jumpTargets.get(targetNode);
        return sourceStack != null && sourceStack.size() > 0;
    }

    @Override
    public void addJumpTargetListener(INavigationNode<?> node, IJumpTargetListener listener) {
        List<IJumpTargetListener> listeners = this.jumpTargetListeners.get(node);
        if (listeners == null) {
            listeners = new LinkedList<IJumpTargetListener>();
            this.jumpTargetListeners.put(node, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void removeJumpTargetListener(INavigationNode<?> node, IJumpTargetListener listener) {
        List<IJumpTargetListener> listeners = this.jumpTargetListeners.get(node);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.size() == 0) {
            this.jumpTargetListeners.remove(node);
        }
    }

    private void cleanupJumpTargetListeners(INavigationNode<?> node) {
        this.jumpTargetListeners.remove(node);
        for (INavigationNode child : node.getChildren()) {
            this.cleanupJumpTargetListeners(child);
        }
    }

    private void setFocusOnRidget(INavigationNode<?> activateNode, NavigationArgument navigation) {
        if (navigation != null && navigation.getRidgetId() != null) {
            IRidgetContainer ridgetContainer = activateNode.getNavigationNodeController().getTypecastedAdapter(IRidgetContainer.class);
            IRidget ridget = ridgetContainer.getRidget(navigation.getRidgetId());
            if (ridget != null) {
                ridget.requestFocus();
            } else {
                throw new NavigationModelFailure(String.format("Ridget not found '%s'", navigation.getRidgetId()));
            }
        }
    }

    private INavigationNode<?> provideNode(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        try {
            return this.getNavigationNodeProvider().provideNode(sourceNode, targetId, argument);
        }
        catch (ExtensionPointFailure failure) {
            throw new NavigationModelFailure(String.format("Node not found '%s'", targetId), (Throwable)((Object)failure));
        }
    }

    protected INavigationNodeProvider getNavigationNodeProvider() {
        return NavigationNodeProvider.getInstance();
    }

    private INavigationNode<?> getNodeToDispose(INavigationNode<?> toDispose) {
        int ind;
        INavigationNode<ISubModuleNode> parent;
        IModuleNode moduleNode = toDispose.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null && (parent = moduleNode.getParent()) instanceof ModuleGroupNode && (ind = parent.getIndexOfChild(moduleNode)) == 0) {
            return parent;
        }
        return toDispose;
    }

    private List<INavigationNode<?>> getNodesToDeactivateOnDispose(INavigationNode<?> toDispose) {
        LinkedList allToDispose = new LinkedList();
        this.addAllChildren(allToDispose, toDispose);
        if (this.isOnlySubModule(toDispose)) {
            allToDispose.add(toDispose.getParent());
        }
        return allToDispose;
    }

    private boolean isOnlySubModule(INavigationNode<?> node) {
        return node.getParent() instanceof IModuleNode && node.getParent().getChildren().size() == 1;
    }

    private void addAllChildren(List<INavigationNode<?>> allToDispose, INavigationNode<?> toDispose) {
        for (Object nextChild : toDispose.getChildren()) {
            this.addAllChildren(allToDispose, (INavigationNode)nextChild);
        }
        allToDispose.add(toDispose);
    }

    private List<INavigationNode<?>> getNodesToActivateOnDispose(INavigationNode<?> toDispose) {
        INavigationNode<?> parentOfToDispose;
        if (toDispose.isActivated() && (parentOfToDispose = this.getParentToActivate(toDispose)) != null) {
            List<?> childrenOfParentOfToDispose = parentOfToDispose.getChildren();
            List<INavigationNode<?>> activatableNode = this.getActivatableNodes(childrenOfParentOfToDispose);
            if (childrenOfParentOfToDispose.size() > 1) {
                for (INavigationNode<?> nextChild : activatableNode) {
                    if (nextChild.equals(toDispose)) continue;
                    if (this.isSelectable(nextChild)) {
                        return this.getNodesToActivateOnActivation(nextChild);
                    }
                    INavigationNode<?> selectableChild = this.getSelectableChild(nextChild);
                    if (selectableChild == null) continue;
                    return this.getNodesToActivateOnActivation(selectableChild);
                }
                if (!(parentOfToDispose instanceof ISubModuleNode)) {
                    throw new NavigationModelFailure("No sibling of node can be selected!");
                }
            }
            if (parentOfToDispose instanceof ISubModuleNode) {
                INavigationNode<?> selectable = this.getSelectableParent(parentOfToDispose);
                if (selectable != null) {
                    return this.getNodesToActivateOnActivation(selectable);
                }
                throw new NavigationModelFailure("No parent of node can be selected!");
            }
        }
        return new LinkedList();
    }

    private INavigationNode<?> getSelectableParent(INavigationNode<?> node) {
        if (node == null) {
            return null;
        }
        if (this.isSelectable(node)) {
            return node;
        }
        INavigationNode<?> parent = this.getSelectableParent(node.getParent());
        if (this.getChildToActivate(parent) == null) {
            return null;
        }
        return parent;
    }

    private INavigationNode<?> getSelectableChild(INavigationNode<?> node) {
        if (node == null) {
            return null;
        }
        for (INavigationNode child : node.getChildren()) {
            if (!this.isSelectable(child)) continue;
            return child;
        }
        for (INavigationNode child : node.getChildren()) {
            INavigationNode<?> selectableChild = this.getSelectableChild(child);
            if (selectableChild == null) continue;
            return selectableChild;
        }
        return null;
    }

    private boolean isSelectable(INavigationNode<?> node) {
        if (!node.isVisible() || !node.isEnabled()) {
            return false;
        }
        if (node instanceof ISubModuleNode) {
            return ((ISubModuleNode)node).isSelectable();
        }
        return true;
    }

    private INavigationNode<?> getParentToActivate(INavigationNode<?> node) {
        if (this.isOnlySubModule(node)) {
            if (node.getParentOfType(IModuleGroupNode.class).getChildren().size() == 1) {
                return node.getParentOfType(ISubApplicationNode.class);
            }
            return node.getParentOfType(IModuleGroupNode.class);
        }
        return node.getParent();
    }

    private List<INavigationNode<?>> getActivatableNodes(List<?> nodes) {
        LinkedList activatableNodes = new LinkedList();
        for (Object node : nodes) {
            INavigationNode naviNode;
            if (!(node instanceof INavigationNode) || !(naviNode = (INavigationNode)node).isVisible() || !naviNode.isEnabled()) continue;
            activatableNodes.add(naviNode);
        }
        return activatableNodes;
    }

    private List<INavigationNode<?>> getNodesToActivateOnActivation(INavigationNode<?> toActivate) {
        LinkedList nodesToActivate = new LinkedList();
        this.addParentsToActivate(nodesToActivate, toActivate);
        this.addChildrenToActivate(nodesToActivate, toActivate);
        return nodesToActivate;
    }

    private void addParentsToActivate(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        INavigationNode<?> parent = this.getActivationParent(toActivate);
        if (parent != null) {
            if (parent.isActivated()) {
                this.addSelectableNode(nodesToActivate, toActivate);
            } else {
                this.addParentsToActivate(nodesToActivate, parent);
                this.addSelectableNode(nodesToActivate, toActivate);
            }
        } else {
            nodesToActivate.add(toActivate);
        }
    }

    private void addSelectableNode(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        if (toActivate instanceof ISubModuleNode && !((ISubModuleNode)toActivate).isSelectable()) {
            Nop.reason((String)"do not add; not selectable");
        } else {
            nodesToActivate.add(toActivate);
        }
    }

    private INavigationNode<?> getActivationParent(INavigationNode<?> child) {
        ISubModuleNode subModuleNode = child.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            INavigationNode<?> parent = child.getParent();
            while (parent != null) {
                if (parent.getTypecastedAdapter(IModuleNode.class) != null) {
                    return parent;
                }
                parent = parent.getParent();
            }
        } else {
            return child.getParent();
        }
        return null;
    }

    private void addChildrenToActivate(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        INavigationNode<?> childToActivate = this.getChildToActivate(toActivate);
        if (childToActivate != null) {
            nodesToActivate.add(childToActivate);
            this.addChildrenToActivate(nodesToActivate, childToActivate);
        }
    }

    private List<INavigationNode<?>> getNodesToDeactivateOnActivation(INavigationNode<?> toActivate) {
        LinkedList nodesToDeactivate = new LinkedList();
        INavigationNode<?> activeParent = this.getNextActiveParent(toActivate);
        if (activeParent != null) {
            INavigationNode<?> activeChild = this.getActiveChild(activeParent);
            if (activeChild != null) {
                this.addChildrenToDeactivate(nodesToDeactivate, activeChild);
            }
        } else {
            this.addChildrenToDeactivate(nodesToDeactivate, this.getTopParent(toActivate));
        }
        return nodesToDeactivate;
    }

    private void addChildrenToDeactivate(List<INavigationNode<?>> nodesToDeactivate, INavigationNode<?> toAdd) {
        INavigationNode<?> activeChild = this.getActiveChild(toAdd);
        if (activeChild != null) {
            this.addChildrenToDeactivate(nodesToDeactivate, activeChild);
            nodesToDeactivate.add(toAdd);
        } else {
            nodesToDeactivate.add(toAdd);
        }
    }

    private INavigationNode<?> getNextActiveParent(INavigationNode<?> node) {
        ISubModuleNode subModuleNode = node.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            return this.getNextActiveParent(subModuleNode.getParent());
        }
        if (node.isActivated()) {
            return node;
        }
        if (node.getParent() != null) {
            return this.getNextActiveParent(node.getParent());
        }
        return null;
    }

    private INavigationNode<?> getTopParent(INavigationNode<?> node) {
        if (node.getParent() != null) {
            return this.getTopParent(node.getParent());
        }
        return node;
    }

    private boolean allowsActivate(INavigationContext context) {
        for (INavigationNode<?> nextToActivate : context.getToActivate()) {
            if (nextToActivate.allowsActivate(context)) continue;
            return false;
        }
        return true;
    }

    private boolean allowsDispose(INavigationContext context) {
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (nextToDeactivate.allowsDispose(context)) continue;
            return false;
        }
        return true;
    }

    private boolean allowsDeactivate(INavigationContext context) {
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (nextToDeactivate.allowsDeactivate(context)) continue;
            return false;
        }
        return true;
    }

    private void activate(INavigationContext context) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull(context.getToActivate());
        List<INavigationNode<?>> nextNodesToActivate = context.getToActivate();
        if (nextNodesToActivate.isEmpty()) {
            LOGGER.log(4, "NaviProc: - There is no node to activate!");
        }
        for (INavigationNode<?> iNavigationNode : nextNodesToActivate) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - beforeActivate: " + iNavigationNode.getNodeId());
            }
            iNavigationNode.onBeforeActivate(context);
        }
        for (INavigationNode<?> iNavigationNode : nextNodesToActivate) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - activate: " + iNavigationNode.getNodeId());
            }
            iNavigationNode.activate(context);
            this.setAsSelectedChild(iNavigationNode);
        }
        for (INavigationNode<Object> iNavigationNode : Iter.ableReverse(nextNodesToActivate)) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - onAfterActivate: " + iNavigationNode.getNodeId());
            }
            iNavigationNode.onAfterActivate(context);
        }
        if (!nextNodesToActivate.isEmpty()) {
            this.checkActiveNodes(nextNodesToActivate.iterator().next());
        }
    }

    private boolean checkActiveNodes(INavigationNode<?> someChild) {
        boolean ok = true;
        if (someChild instanceof IApplicationNode) {
            return ok;
        }
        IApplicationNode application = someChild.getParentOfType(IApplicationNode.class);
        LinkedList activeNodes = new LinkedList();
        this.addChildren(application, activeNodes, INavigationNode.State.ACTIVATED);
        int i = 0;
        while (i < activeNodes.size()) {
            INavigationNode iNode = (INavigationNode)activeNodes.get(i);
            int j = i + 1;
            while (j < activeNodes.size()) {
                INavigationNode jNode = (INavigationNode)activeNodes.get(j);
                if (iNode instanceof IApplicationNode && jNode instanceof IApplicationNode) {
                    LOGGER.log(1, "Two active IApplicationNodes: " + iNode.getNodeId() + ", " + jNode.getNodeId());
                    ok = false;
                } else if (iNode instanceof ISubApplicationNode && jNode instanceof ISubApplicationNode) {
                    LOGGER.log(1, "Two active ISubApplicationNodes: " + iNode.getNodeId() + ", " + jNode.getNodeId());
                    ok = false;
                } else if (iNode instanceof IModuleGroupNode && jNode instanceof IModuleGroupNode) {
                    LOGGER.log(1, "Two active IModuleGroupNode: " + iNode.getNodeId() + ", " + jNode.getNodeId());
                    ok = false;
                } else if (iNode instanceof IModuleNode && jNode instanceof IModuleNode) {
                    LOGGER.log(1, "Two active IModuleNode: " + iNode.getNodeId() + ", " + jNode.getNodeId());
                    ok = false;
                } else if (iNode instanceof ISubModuleNode && jNode instanceof ISubModuleNode) {
                    LOGGER.log(1, "Two active ISubModuleNodes: " + iNode.getNodeId() + ", " + jNode.getNodeId());
                    ok = false;
                }
                ++j;
            }
            ++i;
        }
        return ok;
    }

    private void addChildren(INavigationNode<?> parent, List<INavigationNode<?>> nodes, INavigationNode.State nodeState) {
        if (parent != null) {
            for (INavigationNode child : parent.getChildren()) {
                if (child.getState() == nodeState) {
                    nodes.add(child);
                }
                this.addChildren(child, nodes, nodeState);
            }
        }
    }

    private void deactivate(INavigationContext context) {
        ArrayList<INavigationNode> previouslyActivatedNodes = new ArrayList<INavigationNode>();
        for (INavigationNode iNavigationNode : Iter.ableReverse(context.getToDeactivate())) {
            if (!iNavigationNode.isActivated()) continue;
            previouslyActivatedNodes.add(iNavigationNode);
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - beforeDeactivate: " + iNavigationNode.getNodeId());
            }
            iNavigationNode.onBeforeDeactivate(context);
        }
        for (INavigationNode iNavigationNode : context.getToDeactivate()) {
            if (!previouslyActivatedNodes.contains(iNavigationNode)) continue;
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - deactivate: " + iNavigationNode.getNodeId());
            }
            iNavigationNode.deactivate(context);
        }
        for (INavigationNode iNavigationNode : context.getToDeactivate()) {
            if (!previouslyActivatedNodes.contains(iNavigationNode)) continue;
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - onAfterDeactivate: " + iNavigationNode.getNodeId());
            }
            iNavigationNode.onAfterDeactivate(context);
        }
    }

    private void dispose(INavigationContext context) {
        for (INavigationNode iNavigationNode : Iter.ableReverse(context.getToDeactivate())) {
            iNavigationNode.onBeforeDispose(context);
        }
        for (INavigationNode iNavigationNode : context.getToDeactivate()) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - dispos: " + iNavigationNode.getNodeId());
            }
            iNavigationNode.dispose(context);
            INavigationNode<?> parent = iNavigationNode.getParent();
            if (parent == null) continue;
            parent.removeChild(iNavigationNode);
        }
        for (INavigationNode iNavigationNode : context.getToDeactivate()) {
            iNavigationNode.onAfterDispose(context);
            this.cleanupHistory(iNavigationNode);
        }
    }

    private INavigationNode<?> getChildToActivate(INavigationNode<?> pNode) {
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            if (!subModuleNode.isSelectable() && !subModuleNode.getChildren().isEmpty()) {
                return this.findSelectableChildNode(subModuleNode);
            }
            return null;
        }
        IModuleNode moduleNode = pNode.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null) {
            ISubModuleNode nextChild = this.getSelectedChild(moduleNode);
            ISubModuleNode selectedChild = null;
            while (nextChild != null) {
                selectedChild = nextChild.isSelectable() ? nextChild : selectedChild;
                nextChild = this.getSelectedChild(nextChild);
            }
            if (selectedChild != null) {
                return selectedChild;
            }
            if (moduleNode.getChildren().size() > 0) {
                ISubModuleNode subModule = null;
                Iterator subIter = moduleNode.getChildren().iterator();
                while (subModule == null && subIter.hasNext()) {
                    subModule = this.findSelectableChildNode((ISubModuleNode)subIter.next());
                }
                return subModule;
            }
            return null;
        }
        INavigationNode<?> nextSelectedChild = this.getSelectedChild(pNode);
        if (nextSelectedChild != null) {
            return nextSelectedChild;
        }
        for (INavigationNode next : pNode.getChildren()) {
            if (!next.isVisible() || !next.isEnabled()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode findSelectableChildNode(ISubModuleNode startNode) {
        if (!startNode.isVisible() || !startNode.isEnabled()) {
            return null;
        }
        if (startNode.isSelectable()) {
            return startNode;
        }
        startNode.setExpanded(true);
        for (ISubModuleNode child : startNode.getChildren()) {
            ISubModuleNode found = this.findSelectableChildNode(child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private INavigationNode<?> getActiveChild(INavigationNode<?> pNode) {
        INavigationNode<?> nextSelectedChild;
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            return null;
        }
        IModuleNode moduleNode = pNode.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null) {
            ISubModuleNode nextChild = this.getSelectedChild(moduleNode);
            if (nextChild != null) {
                while (nextChild != null) {
                    if (nextChild.isActivated()) {
                        return nextChild;
                    }
                    if (this.getSelectedChild(nextChild) != null) {
                        nextChild = this.getSelectedChild(nextChild);
                        continue;
                    }
                    return null;
                }
            } else {
                return null;
            }
        }
        if ((nextSelectedChild = this.getSelectedChild(pNode)) != null && nextSelectedChild.isActivated()) {
            return nextSelectedChild;
        }
        return null;
    }

    private void setAsSelectedChild(INavigationNode<?> pNode) {
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            ISubModuleNode nextToSet = subModuleNode;
            while (nextToSet != null) {
                if (nextToSet.getParent() == null) continue;
                this.setSelectedChild(nextToSet.getParent(), nextToSet);
                nextToSet = nextToSet.getParent().getTypecastedAdapter(ISubModuleNode.class);
            }
            this.setSelectedChild(subModuleNode, null);
            return;
        }
        if (pNode.getParent() != null) {
            this.setSelectedChild(pNode.getParent(), pNode);
        }
    }

    private void setSelectedChild(INavigationNode<?> parent, INavigationNode<?> child) {
        for (INavigationNode next : parent.getChildren()) {
            if (next.equals(child)) {
                next.setSelected(true);
                if (!next.isActivated()) continue;
                this.buildHistory(next);
                continue;
            }
            next.setSelected(false);
        }
    }

    private INavigationNode<?> getSelectedChild(INavigationNode<?> pNavigationNode) {
        for (INavigationNode next : pNavigationNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode getSelectedChild(IModuleNode pModuleNode) {
        for (ISubModuleNode next : pModuleNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode getSelectedChild(ISubModuleNode pSubModuleNode) {
        for (ISubModuleNode next : pSubModuleNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    @Override
    public void historyBack() {
        if (this.getHistoryBackSize() > 0) {
            INavigationNode<?> current = this.histBack.pop();
            this.fireBackHistoryChangedEvent();
            this.histForward.push(current);
            if (this.histForward.size() > 40) {
                this.histForward.remove(this.histForward.firstElement());
            }
            this.fireForewardHistoryChangedEvent();
            INavigationNode<?> node = this.histBack.peek();
            if (node != null) {
                this.activate(node);
            }
        }
    }

    private void fireBackHistoryChangedEvent() {
        if (this.navigationListener.size() == 0) {
            return;
        }
        NavigationHistoryEvent event = new NavigationHistoryEvent(this.histBack.subList(0, Math.max(0, this.histBack.size() - 1)));
        for (INavigationHistoryListener listener : this.navigationListener) {
            listener.backHistoryChanged(event);
        }
    }

    @Override
    public void historyForward() {
        if (this.getHistoryForwardSize() > 0) {
            INavigationNode<?> current = this.histForward.pop();
            this.fireForewardHistoryChangedEvent();
            if (current != null) {
                this.histBack.push(current);
                if (this.histBack.size() > 40) {
                    this.histBack.remove(this.histBack.firstElement());
                }
                this.activate(current);
                this.fireBackHistoryChangedEvent();
            }
        }
    }

    private void fireForewardHistoryChangedEvent() {
        if (this.navigationListener.size() == 0) {
            return;
        }
        NavigationHistoryEvent event = new NavigationHistoryEvent(this.histForward.subList(0, this.histForward.size()));
        for (INavigationHistoryListener listener : this.navigationListener) {
            listener.forwardHistoryChanged(event);
        }
    }

    @Override
    public int getHistoryBackSize() {
        return this.histBack.size() - 1;
    }

    @Override
    public INavigationNode<?> getSelectedNode() {
        return this.histBack.peek();
    }

    @Override
    public int getHistoryForwardSize() {
        return this.histForward.size();
    }

    @Override
    public void navigateBack(INavigationNode<?> targetNode) {
        INavigationNode<?> sourceNode = null;
        INavigationNode<?> lookupNode = targetNode;
        while (sourceNode == null) {
            sourceNode = this.navigationMap.get(lookupNode);
            if (sourceNode != null || (lookupNode = lookupNode.getParent()) != null) continue;
            return;
        }
        this.navigate(targetNode, sourceNode.getNodeId(), null);
    }

    @Override
    public synchronized void addNavigationHistoryListener(INavigationHistoryListener listener) {
        if (!this.navigationListener.contains(listener)) {
            this.navigationListener.add(listener);
            NavigationHistoryEvent event = new NavigationHistoryEvent(this.histBack.subList(0, this.histBack.size() > 0 ? this.histBack.size() - 1 : 0));
            listener.backHistoryChanged(event);
            event = new NavigationHistoryEvent(this.histForward.subList(0, this.histForward.size()));
            listener.forwardHistoryChanged(event);
        }
    }

    @Override
    public synchronized void removeNavigationHistoryListener(INavigationHistoryListener listener) {
        this.navigationListener.remove(listener);
    }

    @Override
    public List<INavigationNode<?>> getHistory() {
        return Collections.unmodifiableList(this.histBack);
    }

    private static class NavigationContext
    implements INavigationContext {
        private static final List<INavigationNode<?>> EMPTY_LIST = new LinkedList();
        private List<INavigationNode<?>> toDeactivate;
        private List<INavigationNode<?>> toActivate;
        private List<INavigationNode<?>> toPrepare;

        public NavigationContext(List<INavigationNode<?>> toPrepare, List<INavigationNode<?>> toActivate, List<INavigationNode<?>> toDeactivate) {
            this.toPrepare = toPrepare;
            this.toActivate = toActivate;
            this.toDeactivate = toDeactivate;
            if (this.toPrepare == null) {
                this.toPrepare = EMPTY_LIST;
            }
            if (this.toActivate == null) {
                this.toActivate = EMPTY_LIST;
            }
            if (this.toDeactivate == null) {
                this.toDeactivate = EMPTY_LIST;
            }
        }

        @Override
        public List<INavigationNode<?>> getToActivate() {
            return this.toActivate;
        }

        @Override
        public List<INavigationNode<?>> getToDeactivate() {
            return this.toDeactivate;
        }

        @Override
        public List<INavigationNode<?>> getToPrepare() {
            return this.toPrepare;
        }
    }

    private static enum NavigationType {
        DEFAULT,
        JUMP;

    }
}

