/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.app.client.helloworld.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.sample.app.client.helloworld.views.CustomerDetailsSubModuleView;
import org.eclipse.riena.sample.app.common.model.Customer;
import org.eclipse.riena.sample.app.common.model.ICustomerSearch;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.workarea.WorkareaManager;

public class CustomerSearchSubModuleController
extends SubModuleController {
    private ICustomerSearch service;
    private ITableRidget tableRidget;
    private IActionRidget searchAction;
    private IActionRidget clearAction;
    private IActionRidget openAction;
    private ITextRidget firstNameRidget;
    private ITextRidget lastNameRidget;
    private final ResultContainer searchResult = new ResultContainer();
    private WritableValue tableSelection;
    private final Customer sample = new Customer();

    public CustomerSearchSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    @InjectService
    public void bind(ICustomerSearch service) {
        this.service = service;
    }

    public void unbind(ICustomerSearch service) {
        if (this.service == service) {
            this.service = null;
        }
    }

    protected void searchCustomers() {
        Customer[] result = this.service.findCustomer(this.sample);
        this.searchResult.setList(Arrays.asList(result));
        this.tableRidget.updateFromModel();
    }

    public void configureRidgets() {
        this.tableRidget = (ITableRidget)this.getRidget("tableRidget");
        this.searchAction = (IActionRidget)this.getRidget("searchAction");
        this.clearAction = (IActionRidget)this.getRidget("clearAction");
        this.openAction = (IActionRidget)this.getRidget("openAction");
        this.firstNameRidget = (ITextRidget)this.getRidget("firstNameRidget");
        this.lastNameRidget = (ITextRidget)this.getRidget("lastNameRidget");
    }

    public void afterBind() {
        super.afterBind();
        String[] columnProperties = new String[]{"customerNumber", "lastName", "firstName", "phoneBusiness"};
        this.tableRidget.bindToModel((Object)this.searchResult, "list", Customer.class, columnProperties, new String[]{"Number", "Lastname", "Firstname", "phone"});
        this.tableRidget.updateFromModel();
        this.tableSelection = new WritableValue();
        this.tableRidget.bindSingleSelectionToModel((IObservableValue)this.tableSelection);
        this.searchAction.addListener((IActionListener)new SearchCallback());
        this.firstNameRidget.bindToModel((Object)this.sample, "firstName");
        this.lastNameRidget.bindToModel((Object)this.sample, "lastName");
        this.clearAction.addListener((IActionListener)new ClearCallback());
        this.openAction.addListener((IActionListener)new OpenCallback());
    }

    private class ClearCallback
    implements IActionListener {
        private ClearCallback() {
        }

        public void callback() {
            CustomerSearchSubModuleController.this.sample.setCustomerNumber(null);
            CustomerSearchSubModuleController.this.sample.setFirstName("");
            CustomerSearchSubModuleController.this.sample.setLastName("");
            CustomerSearchSubModuleController.this.firstNameRidget.updateFromModel();
            CustomerSearchSubModuleController.this.lastNameRidget.updateFromModel();
        }
    }

    private class OpenCallback
    implements IActionListener {
        private OpenCallback() {
        }

        public void callback() {
            Object selectedValue = CustomerSearchSubModuleController.this.tableSelection.getValue();
            if (selectedValue == null) {
                return;
            }
            if (!(selectedValue instanceof Customer)) {
                throw new RuntimeException("invalid datatype for selected value");
            }
            Customer selected = (Customer)selectedValue;
            ISubModuleNode node = (ISubModuleNode)CustomerSearchSubModuleController.this.getNavigationNode();
            SubModuleNode cNode = new SubModuleNode(null, selected.getFirstName());
            cNode.setContext(Customer.class.getName(), (Object)selected);
            WorkareaManager.getInstance().registerDefinition((INavigationNode)cNode, (Object)CustomerDetailsSubModuleView.ID);
            node.addChild((INavigationNode)cNode);
            cNode.activate();
        }
    }

    public static class ResultContainer {
        private List<Customer> list = new ArrayList<Customer>();

        public List<Customer> getList() {
            return this.list;
        }

        public void setList(List<Customer> list) {
            this.list = list;
        }
    }

    private class SearchCallback
    implements IActionListener {
        private SearchCallback() {
        }

        public void callback() {
            CustomerSearchSubModuleController.this.searchCustomers();
        }
    }
}

