/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.sample.app.server;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.sample.app.server.Activator;
import org.eclipse.riena.sample.app.common.exception.IExceptionService;

public class ExceptionService
implements IExceptionService {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ExceptionService.class);

    public String getDate() {
        Calendar cld = Calendar.getInstance();
        int day = cld.get(5);
        int month = cld.get(2);
        int year = cld.get(1);
        return String.valueOf(day) + "." + month + "." + year;
    }

    public String throwException(String name) throws Throwable {
        Throwable exception = null;
        LOGGER.log(3, "The client requested an Exception '" + name + "'");
        if (name == null) {
            LOGGER.log(1, "The name of the requested Exception/Failure is null!");
            return null;
        }
        if (name.equals("default")) {
            throw new Exception("ExceptionService: Here is your requested general default Exception...");
        }
        try {
            Class<?> exceptionClass = Class.forName(name);
            Class[] params = new Class[]{Class.forName("java.lang.String")};
            LOGGER.log(3, "throwException: Created a class: " + exceptionClass);
            String cause = "ExceptionService: Here is your requested " + exceptionClass.getName() + "...";
            Object[] args = new Object[]{cause};
            Constructor<?> c = null;
            try {
                c = exceptionClass.getConstructor(params);
                exception = (Throwable)c.newInstance(args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                params = new Class[]{};
                c = exceptionClass.getConstructor(params);
                exception = (Throwable)c.newInstance(new Object[0]);
                LOGGER.log(3, "Take default constructor.");
            }
            LOGGER.log(3, "throwException: Created the requested exception " + exception + " of type throwable");
        }
        catch (Exception e) {
            throw new Exception("ExceptionService: requested Exception '" + name + "' could not be found....", e);
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    public String throwNestedException() throws Throwable {
        throw new Exception(new NullPointerException("ExceptionService: Here is your requested nested Exception."));
    }

    public String throwRuntimeException(String name) {
        try {
            this.throwException(name);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return null;
    }
}

