/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.DateColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class SnippetTableRidget003 {
    public SnippetTableRidget003(final Shell shell) {
        Table table = new Table((Composite)shell, 67588);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn[] columns = new TableColumn[2];
        int i = 0;
        while (i < columns.length) {
            columns[i] = new TableColumn(table, 16384);
            ++i;
        }
        TableColumnLayout layout = new TableColumnLayout();
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(50, 200));
            ++n2;
        }
        shell.setLayout((Layout)layout);
        ITableRidget tableRidget = (ITableRidget)SwtRidgetFactory.createRidget((Object)table);
        String[] columnPropertyNames = new String[]{"description", "date"};
        String[] columnHeaders = new String[]{"Description", "Date"};
        List<Holiday> input = this.createInput();
        tableRidget.setColumnFormatter(1, (IColumnFormatter)new DateColumnFormatter("MM/dd/yyyy"){

            protected Date getDate(Object element) {
                return ((Holiday)((Object)element)).getDate();
            }

            public Color getForeground(Object element) {
                return shell.getDisplay().getSystemColor(3);
            }
        });
        tableRidget.bindToModel((IObservableList)new WritableList(input, Holiday.class), Holiday.class, columnPropertyNames, columnHeaders);
        tableRidget.updateFromModel();
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = UIControlsFactory.createShell((Display)display);
            shell.setText(SnippetTableRidget003.class.getSimpleName());
            new SnippetTableRidget003(shell);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private List<Holiday> createInput() {
        ArrayList<Holiday> result = new ArrayList<Holiday>(7);
        result.add(new Holiday("New Year's Day", this.createDate(2009, 1, 1)));
        result.add(new Holiday("Martin Luther King Day", this.createDate(2009, 1, 19)));
        result.add(new Holiday("Memorial Day", this.createDate(2009, 5, 25)));
        result.add(new Holiday("Independence Day", this.createDate(2009, 7, 4)));
        result.add(new Holiday("Labor Day", this.createDate(2009, 9, 7)));
        result.add(new Holiday("Thanksgiving Day", this.createDate(2009, 11, 26)));
        result.add(new Holiday("Christmas Eve", this.createDate(2009, 12, 24)));
        result.add(new Holiday("Christmas Day", this.createDate(2009, 12, 25)));
        return result;
    }

    private Date createDate(int year, int month, int day) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    private static final class Holiday
    extends AbstractBean {
        private final String descr;
        private final Date date;

        public Holiday(String descr, Date date) {
            this.descr = descr;
            this.date = date;
        }

        public String getDescription() {
            return this.descr;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

