/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.IntegerBean;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.ISliderRidget;
import org.eclipse.riena.ui.ridgets.ISpinnerRidget;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;

public final class SnippetTraverseRidget001 {
    private static final int MINIMUM = 75;
    private static final int MAXIMUM = 200;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = new Shell();
            shell.setText(SnippetTraverseRidget001.class.getSimpleName());
            shell.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(20, 10).applyTo((Composite)shell);
            UIControlsFactory.createLabel((Composite)shell, (String)"Slider");
            Slider slider = new Slider((Composite)shell, 256);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)slider);
            UIControlsFactory.createLabel((Composite)shell, (String)"Scale");
            Scale scale = new Scale((Composite)shell, 256);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)scale);
            scale.setBackground(shell.getBackground());
            UIControlsFactory.createLabel((Composite)shell, (String)"Spinner");
            Spinner spinner = new Spinner((Composite)shell, 256);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)spinner);
            UIControlsFactory.createLabel((Composite)shell, (String)"Progress");
            ProgressBar progressBar = new ProgressBar((Composite)shell, 65792);
            progressBar.setState(4);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)progressBar);
            ISliderRidget sliderRidget = (ISliderRidget)SwtRidgetFactory.createRidget((Object)slider);
            sliderRidget.setMaximum(200);
            sliderRidget.setMinimum(75);
            sliderRidget.setPageIncrement(25);
            sliderRidget.setIncrement(2);
            sliderRidget.setToolTipText("The current value is: [VALUE].");
            sliderRidget.bindToModel((Object)new IntegerBean(100), "value");
            sliderRidget.addValidationRule(new IValidator(){

                public IStatus validate(Object value) {
                    int selection = (Integer)value;
                    if (selection > 180 || selection < 95) {
                        return ValidationRuleStatus.error((boolean)true, (String)"Value of of range!");
                    }
                    return ValidationRuleStatus.ok();
                }
            }, ValidationTime.ON_UPDATE_TO_MODEL);
            sliderRidget.updateFromModel();
            ITraverseRidget scaleRidget = (ITraverseRidget)SwtRidgetFactory.createRidget((Object)scale);
            scaleRidget.setMaximum(200);
            scaleRidget.setMinimum(75);
            scaleRidget.setPageIncrement(25);
            scaleRidget.setIncrement(2);
            scaleRidget.setToolTipText("[VALUE]");
            scaleRidget.bindToModel((Object)new IntegerBean(100), "value");
            scaleRidget.updateFromModel();
            ISpinnerRidget spinnerRidget = (ISpinnerRidget)SwtRidgetFactory.createRidget((Object)spinner);
            spinnerRidget.setMaximum(200);
            spinnerRidget.setMinimum(75);
            spinnerRidget.setPageIncrement(25);
            spinnerRidget.setIncrement(2);
            spinnerRidget.setToolTipText("[VALUE] days left");
            spinnerRidget.bindToModel((Object)new IntegerBean(100), "value");
            spinnerRidget.updateFromModel();
            ITraverseRidget progressBarRidget = (ITraverseRidget)SwtRidgetFactory.createRidget((Object)progressBar);
            progressBarRidget.setMaximum(200);
            progressBarRidget.setMinimum(75);
            progressBarRidget.setToolTipText("Value of progress: [VALUE]");
            progressBarRidget.bindToModel((Object)new IntegerBean(100), "value");
            progressBarRidget.updateFromModel();
            shell.setSize(270, 270);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }
}

