/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MenuPropertiesTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testMenuProperties() {
        Menu menu = new Menu((Control)this.shell);
        MenuItem menuItem = new MenuItem(menu, 64);
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu2);
        MenuRidget ridget = new MenuRidget();
        ridget.setUIControl((Object)menuItem);
        MenuProperties prop = new MenuProperties(ridget);
        Decorations menuParent = (Decorations)ReflectionUtils.getHidden((Object)prop, (String)"menuParent");
        MenuPropertiesTest.assertSame((Object)this.shell, (Object)menuParent);
        int menuStyle = (Integer)ReflectionUtils.getHidden((Object)prop, (String)"menuStyle");
        MenuPropertiesTest.assertEquals((int)menu2.getStyle(), (int)menuStyle);
        MenuItemProperties[] children = (MenuItemProperties[])ReflectionUtils.getHidden((Object)prop, (String)"children");
        MenuPropertiesTest.assertEquals((int)0, (int)children.length);
        MenuItem menuItem2 = new MenuItem(menu2, 0);
        MenuItemRidget childRidget = new MenuItemRidget();
        childRidget.setUIControl((Object)menuItem2);
        ridget.addChild(childRidget);
        prop = new MenuProperties(ridget);
        children = (MenuItemProperties[])ReflectionUtils.getHidden((Object)prop, (String)"children");
        MenuPropertiesTest.assertEquals((int)1, (int)children.length);
        IRidget retRidget = (IRidget)ReflectionUtils.invokeHidden((Object)children[0], (String)"getRidget", (Object[])new Object[0]);
        MenuPropertiesTest.assertSame((Object)childRidget, (Object)retRidget);
    }

    public void testCreateItem() {
        Menu menu = new Menu((Control)this.shell);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)menu, "menu");
        MenuItem menuItem = new MenuItem(menu, 64);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)menuItem, "menuItem");
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu2);
        MenuRidget ridget = new MenuRidget();
        ridget.setUIControl((Object)menuItem);
        MenuItem menuItem2 = new MenuItem(menu2, 0);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)menuItem2, "menuItem2");
        menuItem2.setText("Simple menu item");
        MenuItemRidget childRidget = new MenuItemRidget();
        childRidget.setUIControl((Object)menuItem2);
        ridget.addChild(childRidget);
        MyMenuProperties prop = new MyMenuProperties(ridget);
        MenuItem retMenuItem = prop.createItem();
        MenuPropertiesTest.assertNotNull((Object)retMenuItem);
        MenuPropertiesTest.assertNotSame((Object)menuItem, (Object)retMenuItem);
        MenuPropertiesTest.assertNotNull((Object)retMenuItem.getMenu());
        MenuPropertiesTest.assertNotSame((Object)menu2, (Object)retMenuItem.getMenu());
        MenuPropertiesTest.assertEquals((int)1, (int)retMenuItem.getMenu().getItemCount());
        MenuPropertiesTest.assertEquals((String)"menuItem", (String)SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)retMenuItem));
        MenuItem retChildMenuItem = retMenuItem.getMenu().getItems()[0];
        MenuPropertiesTest.assertEquals((String)menuItem2.getText(), (String)retChildMenuItem.getText());
    }

    private static class MyMenuProperties
    extends MenuProperties {
        public MyMenuProperties(MenuRidget ridget) {
            super(ridget);
        }

        public MenuItem createItem() {
            return super.createItem();
        }
    }
}

