/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.SharedColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

@UITestCase
public class SharedColorsTest
extends RienaTestCase {
    private SharedColors sharedColors;
    private Display display;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.sharedColors = (SharedColors)ReflectionUtils.newInstanceHidden(SharedColors.class, (Object[])new Object[]{this.display});
    }

    protected void tearDown() throws Exception {
        ReflectionUtils.invokeHidden((Object)this.sharedColors, (String)"dispose", (Object[])new Object[0]);
        super.tearDown();
    }

    public void testGet() {
        SharedColorsTest.assertEquals((Object)new Color((Device)this.display, new RGB(250, 190, 190)), (Object)this.getSharedColor("COLOR_FLASH_ERROR"));
        SharedColorsTest.assertEquals((Object)new Color((Device)this.display, new RGB(255, 255, 175)), (Object)this.getSharedColor("COLOR_MANDATORY"));
        SharedColorsTest.assertEquals((Object)new Color((Device)this.display, new RGB(255, 249, 216)), (Object)this.getSharedColor("COLOR_MANDATORY_OUTPUT"));
        SharedColorsTest.assertEquals((Object)new Color((Device)this.display, new RGB(255, 0, 0)), (Object)this.getSharedColor("COLOR_NEGATIVE"));
        SharedColorsTest.assertEquals((Object)new Color((Device)this.display, new RGB(231, 233, 245)), (Object)this.getSharedColor("COLOR_OUTPUT"));
    }

    public void testGetFailWrongKey() {
        try {
            this.getSharedColor("hmm");
            SharedColorsTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            this.ok();
        }
    }

    public void testGetFailDisposed() {
        ReflectionUtils.invokeHidden((Object)this.sharedColors, (String)"dispose", (Object[])new Object[0]);
        try {
            this.getSharedColor("COLOR_MANDATORY");
            SharedColorsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    private Color getSharedColor(String key) {
        try {
            return (Color)ReflectionUtils.invokeHidden((Object)this.sharedColors, (String)"getSharedColor", (Object[])new Object[]{key});
        }
        catch (InvocationTargetFailure e) {
            throw (RuntimeException)e.getTargetException();
        }
    }
}

