/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetEditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

@UITestCase
public class TableRidgetEditingSupportTest
extends TestCase {
    private Shell shell;
    private TableRidget ridget;
    private Table table;

    protected void setUp() throws Exception {
        PropHolder[] values;
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        TableRidgetEditingSupportTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.shell = new Shell(147456);
        this.table = new Table((Composite)this.shell, -1);
        this.ridget = new TableRidget();
        this.ridget.setUIControl((Object)this.table);
        ArrayList<PropHolder> rows = new ArrayList<PropHolder>();
        PropHolder[] propHolderArray = values = new PropHolder[]{new PropHolder(), new PropHolder()};
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            PropHolder value = propHolderArray[n2];
            rows.add(value);
            ++n2;
        }
        String[] propNames = new String[]{"booleanValue", "intValue"};
        this.ridget.bindToModel((IObservableList)new WritableList(rows, PropHolder.class), PropHolder.class, propNames, propNames);
    }

    protected void tearDown() throws Exception {
        this.ridget = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testGetAlignment() {
        TableRidgetEditingSupport support = new TableRidgetEditingSupport((AbstractTableRidget)this.ridget, null, -1);
        int style = 0;
        int ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)-1, (int)ret);
        style = 32768;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)-1, (int)ret);
        style = 16384;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)16384, (int)ret);
        style = 49152;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)16384, (int)ret);
        style = 131072;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)131072, (int)ret);
        style = 196608;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)131072, (int)ret);
        style = 0x1000000;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)0x1000000, (int)ret);
        style = 0x1008000;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)0x1000000, (int)ret);
        style = 147456;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)16384, (int)ret);
        style = 0x1020000;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)131072, (int)ret);
        style = 16924672;
        ret = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getAlignment", (Object[])new Object[]{style});
        TableRidgetEditingSupportTest.assertEquals((int)16384, (int)ret);
    }

    public void testCreateCellEditort() throws IntrospectionException {
        TableRidgetEditingSupport support = new TableRidgetEditingSupport((AbstractTableRidget)this.ridget, null, -1);
        PropertyDescriptor property = null;
        CellEditor editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNull((Object)editor);
        property = new PropertyDescriptor("booleanValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNull((Object)editor);
        property = new PropertyDescriptor("intValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        Object data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"numeric", (Object)data);
        int style = editor.getControl().getStyle();
        TableRidgetEditingSupportTest.assertEquals((int)16384, (int)(style & 0x4000));
        property = new PropertyDescriptor("longValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 131072});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"numeric", (Object)data);
        style = editor.getControl().getStyle();
        TableRidgetEditingSupportTest.assertEquals((int)131072, (int)(style & 0x20000));
        property = new PropertyDescriptor("floatValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 0x1000000});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"decimal", (Object)data);
        style = editor.getControl().getStyle();
        TableRidgetEditingSupportTest.assertEquals((int)0x1000000, (int)(style & 0x1000000));
        property = new PropertyDescriptor("doubleValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"decimal", (Object)data);
        property = new PropertyDescriptor("bigIntegerValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"numeric", (Object)data);
        property = new PropertyDescriptor("bigDecimalValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"decimal", (Object)data);
        property = new PropertyDescriptor("integerValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"numeric", (Object)data);
        property = new PropertyDescriptor("dateValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertEquals((Object)"date", (Object)data);
        property = new PropertyDescriptor("someValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertNull((Object)data);
        property = new PropertyDescriptor("stringValue", PropHolder.class);
        editor = (CellEditor)ReflectionUtils.invokeHidden((Object)support, (String)"createCellEditort", (Object[])new Object[]{property, 16384});
        TableRidgetEditingSupportTest.assertNotNull((Object)editor);
        data = editor.getControl().getData("type");
        TableRidgetEditingSupportTest.assertNull((Object)data);
    }

    private class PropHolder {
        private boolean booleanValue;
        private int intValue;
        private long longValue;
        private float floatValue;
        private double doubleValue;
        private BigInteger bigIntegerValue;
        private BigDecimal bigDecimalValue;
        private Integer integerValue;
        private Date dateValue;
        private Object someValue;
        private String stringValue;

        private PropHolder() {
        }

        public boolean isBooleanValue() {
            return this.booleanValue;
        }

        public void setBooleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public void setIntValue(int intValue) {
            this.intValue = intValue;
        }

        public long getLongValue() {
            return this.longValue;
        }

        public void setLongValue(long longValue) {
            this.longValue = longValue;
        }

        public float getFloatValue() {
            return this.floatValue;
        }

        public void setFloatValue(float floatValue) {
            this.floatValue = floatValue;
        }

        public double getDoubleValue() {
            return this.doubleValue;
        }

        public void setDoubleValue(double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public BigInteger getBigIntegerValue() {
            return this.bigIntegerValue;
        }

        public void setBigIntegerValue(BigInteger bigIntegerValue) {
            this.bigIntegerValue = bigIntegerValue;
        }

        public BigDecimal getBigDecimalValue() {
            return this.bigDecimalValue;
        }

        public void setBigDecimalValue(BigDecimal bigDecimalValue) {
            this.bigDecimalValue = bigDecimalValue;
        }

        public Integer getIntegerValue() {
            return this.integerValue;
        }

        public void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        public Date getDateValue() {
            return this.dateValue;
        }

        public void setDateValue(Date dateValue) {
            this.dateValue = dateValue;
        }

        public Object getSomeValue() {
            return this.someValue;
        }

        public void setSomeValue(Object someValue) {
            this.someValue = someValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }
    }
}

