/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemMarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ToolItemMarkerSupportTest
extends TestCase {
    private Shell shell;
    private ToolBar toolbar;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.toolbar = new ToolBar((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        SwtUtilities.dispose((Widget)this.toolbar);
    }

    public void testUpdateMarkers() {
        ToolItem item = new ToolItem(this.toolbar, 0);
        ToolItemRidget ridget = new ToolItemRidget();
        ToolItemMarkerSupport markerSupport = new ToolItemMarkerSupport(ridget, null);
        ridget.setEnabled(false);
        ToolItemMarkerSupportTest.assertTrue((boolean)item.isEnabled());
        ridget.setUIControl((Object)item);
        markerSupport.updateMarkers();
        ToolItemMarkerSupportTest.assertFalse((boolean)item.isEnabled());
    }

    public void testUpdateDisabled() {
        ToolItem item = new ToolItem(this.toolbar, 0);
        ToolItemRidget ridget = new ToolItemRidget();
        ToolItemMarkerSupport markerSupport = new ToolItemMarkerSupport(ridget, null);
        ridget.setEnabled(false);
        ReflectionUtils.invokeHidden((Object)markerSupport, (String)"updateDisabled", (Object[])new Object[]{item});
        ToolItemMarkerSupportTest.assertFalse((boolean)item.isEnabled());
        ridget.setEnabled(true);
        ReflectionUtils.invokeHidden((Object)markerSupport, (String)"updateDisabled", (Object[])new Object[]{item});
        ToolItemMarkerSupportTest.assertTrue((boolean)item.isEnabled());
        item.dispose();
        ReflectionUtils.invokeHidden((Object)markerSupport, (String)"updateDisabled", (Object[])new Object[]{item});
    }
}

