/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Map;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.lnf.ColorLnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfCustomizer;
import org.eclipse.riena.ui.swt.lnf.ILnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfTheme;
import org.eclipse.riena.ui.swt.lnf.IgnoreLnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class LnFUpdaterTest
extends RienaTestCase {
    private Shell shell;
    private LnFUpdater lnFUpdater;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.lnFUpdater = (LnFUpdater)ReflectionUtils.newInstanceHidden(LnFUpdater.class, (Object[])new Object[0]);
        Map resourceCache = (Map)ReflectionUtils.getHidden((Object)this.lnFUpdater, (String)"RESOURCE_CACHE");
        resourceCache.clear();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SwtUtilities.dispose((Widget)this.shell);
        this.lnFUpdater = null;
    }

    public void testGetErrorMessage() throws IntrospectionException {
        PropertyDescriptor property = new PropertyDescriptor("foreground", Label.class);
        Label label = new Label((Composite)this.shell, 0);
        String message = (String)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getErrorMessage", (Object[])new Object[]{label, property});
        LnFUpdaterTest.assertNotNull((Object)message);
        LnFUpdaterTest.assertTrue((message.indexOf(Label.class.getSimpleName()) > 0 ? 1 : 0) != 0);
        LnFUpdaterTest.assertTrue((message.indexOf(property.getName()) > 0 ? 1 : 0) != 0);
        SwtUtilities.dispose((Widget)label);
    }

    public void testGetLnfValue() throws IntrospectionException {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        RienaDefaultLnf lnf = new RienaDefaultLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        try {
            lnf.setTheme((ILnfTheme)new MyTheme());
            Label label = new Label((Composite)this.shell, 0);
            PropertyDescriptor property = new PropertyDescriptor("foreground", Label.class);
            Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfValue", (Object[])new Object[]{label, property});
            SwtUtilities.dispose((Widget)label);
            LnFUpdaterTest.assertNotNull((Object)value);
            LnFUpdaterTest.assertTrue((boolean)(value instanceof Color));
            Color color = (Color)value;
            LnFUpdaterTest.assertEquals((int)1, (int)color.getRed());
            LnFUpdaterTest.assertEquals((int)2, (int)color.getGreen());
            LnFUpdaterTest.assertEquals((int)3, (int)color.getBlue());
            lnf.setTheme((ILnfTheme)new MyTheme());
            Text text = new Text((Composite)this.shell, 0);
            value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfValue", (Object[])new Object[]{text, property});
            SwtUtilities.dispose((Widget)text);
            LnFUpdaterTest.assertNull((Object)value);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
        }
    }

    public void testGetLnfStyleValue() throws IntrospectionException {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        RienaDefaultLnf lnf = new RienaDefaultLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        try {
            lnf.setTheme((ILnfTheme)new MyTheme());
            Label label = new Label((Composite)this.shell, 0);
            label.setData("lnfStyle", (Object)"section");
            PropertyDescriptor property = new PropertyDescriptor("foreground", Label.class);
            Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfStyleValue", (Object[])new Object[]{label, property});
            SwtUtilities.dispose((Widget)label);
            LnFUpdaterTest.assertNotNull((Object)value);
            LnFUpdaterTest.assertTrue((boolean)(value instanceof Color));
            Color color = (Color)value;
            LnFUpdaterTest.assertEquals((int)111, (int)color.getRed());
            LnFUpdaterTest.assertEquals((int)22, (int)color.getGreen());
            LnFUpdaterTest.assertEquals((int)3, (int)color.getBlue());
            lnf.setTheme((ILnfTheme)new MyTheme());
            label = new Label((Composite)this.shell, 0);
            label.setData("lnfStyle", (Object)"dummy");
            value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfStyleValue", (Object[])new Object[]{label, property});
            SwtUtilities.dispose((Widget)label);
            LnFUpdaterTest.assertNull((Object)value);
            lnf.setTheme((ILnfTheme)new MyTheme());
            Text text = new Text((Composite)this.shell, 0);
            text.setData("lnfStyle", (Object)"section");
            value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfStyleValue", (Object[])new Object[]{text, property});
            SwtUtilities.dispose((Widget)label);
            LnFUpdaterTest.assertNotNull((Object)value);
            LnFUpdaterTest.assertTrue((boolean)(value instanceof Color));
            color = (Color)value;
            LnFUpdaterTest.assertEquals((int)111, (int)color.getRed());
            LnFUpdaterTest.assertEquals((int)22, (int)color.getGreen());
            LnFUpdaterTest.assertEquals((int)3, (int)color.getBlue());
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
        }
    }

    public void testCheckPropertyUpdateView() {
        boolean retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertFalse((boolean)retValue);
        System.setProperty("riena.lnf.update.view", "abc");
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertFalse((boolean)retValue);
        System.setProperty("riena.lnf.update.view", "true");
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertTrue((boolean)retValue);
        System.setProperty("riena.lnf.update.view", "false");
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertFalse((boolean)retValue);
    }

    public void testUpdateUIControl() {
        String oldUpdateValue = System.getProperty("riena.lnf.update.view", "");
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        try {
            System.setProperty("riena.lnf.update.view", "true");
            RienaDefaultLnf lnf = new RienaDefaultLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            lnf.setTheme((ILnfTheme)new MyTheme());
            Label label = new Label((Composite)this.shell, 0);
            ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"updateUIControl", (Object[])new Object[]{label});
            Color labelColor = label.getForeground();
            Color themeColor = lnf.getColor("Label.foreground");
            LnFUpdaterTest.assertEquals((Object)themeColor, (Object)labelColor);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
            System.setProperty("riena.lnf.update.view", oldUpdateValue);
        }
    }

    public void testGetDefaultPropertyValue() throws IntrospectionException {
        Label label = new Label((Composite)this.shell, 0);
        PropertyDescriptor foregroundProperty = new PropertyDescriptor("foreground", Label.class);
        Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getDefaultPropertyValue", (Object[])new Object[]{label, foregroundProperty});
        LnFUpdaterTest.assertEquals((Object)label.getForeground().getRGB(), (Object)value);
    }

    public void testGetPropertyValue() throws IntrospectionException {
        Label label = new Label((Composite)this.shell, 0);
        label.setAlignment(131072);
        PropertyDescriptor property = new PropertyDescriptor("alignment", Label.class);
        Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getPropertyValue", (Object[])new Object[]{label, property});
        LnFUpdaterTest.assertEquals((Object)131072, (Object)value);
    }

    public void testHasNoDefaultValue() throws IntrospectionException {
        Label label = new Label((Composite)this.shell, 0);
        PropertyDescriptor property = new PropertyDescriptor("text", Label.class);
        Boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"hasNoDefaultValue", (Object[])new Object[]{label, property, label.getText()});
        LnFUpdaterTest.assertFalse((boolean)ret);
        label.setText("Hello!");
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"hasNoDefaultValue", (Object[])new Object[]{label, property, label.getText()});
        LnFUpdaterTest.assertTrue((boolean)ret);
    }

    public void testGetSimpleClassName() {
        Class controlClass = Label.class;
        String className = (String)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getSimpleClassName", (Object[])new Object[]{controlClass});
        LnFUpdaterTest.assertEquals((String)Label.class.getSimpleName(), (String)className);
        Composite innerControl = new Composite((Composite)this.shell, 0){

            public boolean setFocus() {
                return true;
            }
        };
        controlClass = innerControl.getClass();
        className = (String)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getSimpleClassName", (Object[])new Object[]{controlClass});
        LnFUpdaterTest.assertEquals((String)Composite.class.getSimpleName(), (String)className);
    }

    public void testCheckLnfKeys() {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        try {
            RienaDefaultLnf lnf = new RienaDefaultLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            ILnfTheme oldTheme = lnf.getTheme();
            MyTheme myTheme = new MyTheme();
            lnf.setTheme((ILnfTheme)myTheme);
            Label label = new Label((Composite)this.shell, 0);
            boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkLnfKeys", (Object[])new Object[]{label});
            lnf.setTheme(oldTheme);
            SwtUtilities.dispose((Widget)label);
            LnFUpdaterTest.assertTrue((boolean)ret);
            lnf.setTheme((ILnfTheme)myTheme);
            Text text = new Text((Composite)this.shell, 0);
            ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkLnfKeys", (Object[])new Object[]{text});
            lnf.setTheme(oldTheme);
            SwtUtilities.dispose((Widget)text);
            LnFUpdaterTest.assertFalse((boolean)ret);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
        }
    }

    public void testCheckLnfClassKeys() {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        RienaDefaultLnf lnf = new RienaDefaultLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.setTheme((ILnfTheme)new MyTheme());
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkLnfClassKeys", (Object[])new Object[]{Label.class});
        LnFUpdaterTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkLnfClassKeys", (Object[])new Object[]{Text.class});
        LnFUpdaterTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkLnfClassKeys", (Object[])new Object[]{MyComposite.class});
        LnFUpdaterTest.assertTrue((boolean)ret);
        LnfManager.setLnf((RienaDefaultLnf)oldLnf);
    }

    public void testIgnoreProperty() throws IntrospectionException {
        PropertyDescriptor property = new PropertyDescriptor("foreground", Label.class);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"ignoreProperty", (Object[])new Object[]{Label.class, property});
        LnFUpdaterTest.assertFalse((boolean)ret);
        property = new PropertyDescriptor("foreground", MyComposite.class);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"ignoreProperty", (Object[])new Object[]{MyComposite.class, property});
        LnFUpdaterTest.assertFalse((boolean)ret);
        property = new PropertyDescriptor("background", MyComposite.class);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"ignoreProperty", (Object[])new Object[]{MyComposite.class, property});
        LnFUpdaterTest.assertTrue((boolean)ret);
        property = new PropertyDescriptor("background", Composite.class);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"ignoreProperty", (Object[])new Object[]{MyComposite.class, property});
        LnFUpdaterTest.assertTrue((boolean)ret);
    }

    public void testIgnoreControl() throws IntrospectionException {
        Label label = new Label((Composite)this.shell, -1);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"ignoreControl", (Object[])new Object[]{label});
        LnFUpdaterTest.assertFalse((boolean)ret);
        label.dispose();
        Composite comp = new MyComposite((Composite)this.shell, -1);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"ignoreControl", (Object[])new Object[]{comp});
        LnFUpdaterTest.assertFalse((boolean)ret);
        comp.dispose();
        comp = new MyIgnoreComposite((Composite)this.shell, -1);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"ignoreControl", (Object[])new Object[]{comp});
        LnFUpdaterTest.assertTrue((boolean)ret);
        comp.dispose();
    }

    public void testGetResourceData() {
        Object data = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getResourceData", (Object[])new Object[]{"strgValue"});
        LnFUpdaterTest.assertEquals((Object)"strgValue", (Object)data);
        Color red = new Color(null, 200, 10, 10);
        data = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getResourceData", (Object[])new Object[]{red});
        LnFUpdaterTest.assertEquals((Object)red.getRGB(), (Object)data);
        red.dispose();
        data = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getResourceData", (Object[])new Object[]{red});
        LnFUpdaterTest.assertSame((Object)red, (Object)data);
        Font font = new Font(null, "Arial", 12, 1);
        data = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getResourceData", (Object[])new Object[]{font});
        LnFUpdaterTest.assertTrue((boolean)(data instanceof FontData[]));
        FontData[] fontData = (FontData[])data;
        LnFUpdaterTest.assertEquals((Object)font.getFontData()[0], (Object)fontData[0]);
        font.dispose();
        data = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getResourceData", (Object[])new Object[]{font});
        LnFUpdaterTest.assertSame((Object)font, (Object)data);
    }

    public void testGenerateLnfKey() throws IntrospectionException {
        PropertyDescriptor property = new PropertyDescriptor("foreground", Label.class);
        String ret = (String)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"generateLnfKey", (Object[])new Object[]{Label.class, property});
        LnFUpdaterTest.assertEquals((String)"Label.foreground", (String)ret);
    }

    public void testValuesEquals() {
        FontData[] value1 = new Integer(1);
        FontData[] value2 = new Integer(1);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{value1, value2});
        LnFUpdaterTest.assertTrue((boolean)ret);
        value2 = new Integer(4711);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{value1, value2});
        LnFUpdaterTest.assertFalse((boolean)ret);
        Color color1 = new Color(null, 200, 10, 10);
        Color color2 = new Color(null, 200, 10, 10);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{color1, color2});
        LnFUpdaterTest.assertTrue((boolean)ret);
        Color color3 = new Color(null, 1, 20, 30);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{color1, color3});
        LnFUpdaterTest.assertFalse((boolean)ret);
        value2 = new RGB(200, 10, 10);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{color1, value2});
        LnFUpdaterTest.assertTrue((boolean)ret);
        value1 = new RGB(200, 10, 10);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{value1, value2});
        LnFUpdaterTest.assertTrue((boolean)ret);
        value1 = new RGB(1, 20, 30);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{value1, value2});
        LnFUpdaterTest.assertFalse((boolean)ret);
        value1 = new RGB(1, 20, 30);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{color3, value1});
        LnFUpdaterTest.assertTrue((boolean)ret);
        color1.dispose();
        color2.dispose();
        color3.dispose();
        Font font1 = new Font(null, "arial", 12, 1);
        Font font2 = new Font(null, "arial", 12, 1);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{font1, font2});
        LnFUpdaterTest.assertTrue((boolean)ret);
        Font font3 = new Font(null, "arial", 72, 1);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{font1, font3});
        LnFUpdaterTest.assertFalse((boolean)ret);
        value2 = new FontData[]{new FontData("arial", 12, 1)};
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{font1, value2});
        LnFUpdaterTest.assertTrue((boolean)ret);
        value2 = new FontData[]{new FontData("arial", 12, 1)};
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{font3, value2});
        LnFUpdaterTest.assertFalse((boolean)ret);
        value1 = new FontData[]{new FontData("helvetica", 12, 1)};
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{value1, value2});
        LnFUpdaterTest.assertFalse((boolean)ret);
        value1 = new FontData[]{new FontData("arial", 12, 1)};
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"valuesEquals", (Object[])new Object[]{value1, value2});
        LnFUpdaterTest.assertTrue((boolean)ret);
        font1.dispose();
        font2.dispose();
        font3.dispose();
    }

    @IgnoreLnFUpdater(value={"background"})
    private static class MyComposite
    extends Composite {
        public MyComposite(Composite parent, int style) {
            super(parent, style);
        }
    }

    @IgnoreLnFUpdater(value={"*"})
    private static class MyIgnoreComposite
    extends Composite {
        public MyIgnoreComposite(Composite parent, int style) {
            super(parent, style);
        }
    }

    private static class MyTheme
    implements ILnfTheme {
        private MyTheme() {
        }

        public void customizeLnf(ILnfCustomizer lnf) {
            lnf.putLnfResource("Composite.background", (ILnfResource)new ColorLnfResource(47, 11, 15));
            lnf.putLnfResource("Label.foreground", (ILnfResource)new ColorLnfResource(1, 2, 3));
            lnf.putLnfResource("section.foreground", (ILnfResource)new ColorLnfResource(111, 22, 3));
        }
    }
}

