/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtBindingDelegate;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;

@UITestCase
public class SubModuleViewTest
extends RienaTestCase {
    private SubModuleView subModuleNodeView;
    private SubModuleNode node;
    private SubModuleNode anotherNode;
    private SubModuleNode anotherNodeSameView;
    private List<ISubModuleNode> nodesBoundToView;
    private ApplicationNode appNode;
    private IModuleNode moduleNode;
    private ArrayList<ISubModuleNode> nodesBoundToSharedView;
    private Shell shell;
    private Composite parentComposite;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.parentComposite = new Composite((Composite)this.shell, 0);
        this.addPluginXml(SubModuleViewTest.class, "SubModuleViewTest.xml");
        this.appNode = new ApplicationNode();
        new ApplicationController((IApplicationNode)this.appNode);
        SubApplicationNode subAppNode = new SubApplicationNode();
        this.appNode.addChild((INavigationNode)subAppNode);
        subAppNode.setParent((INavigationNode)this.appNode);
        ModuleGroupNode mgNode = new ModuleGroupNode(null);
        subAppNode.addChild((INavigationNode)mgNode);
        mgNode.setParent((INavigationNode)subAppNode);
        this.moduleNode = new ModuleNode(null, "TestModuleLabel");
        mgNode.addChild((INavigationNode)this.moduleNode);
        this.moduleNode.setParent((INavigationNode)mgNode);
        this.anotherNode = new SubModuleNode(new NavigationNodeId("testId2", "2"), "TestSubModuleLabel2");
        this.moduleNode.addChild((INavigationNode)this.anotherNode);
        this.anotherNode.setParent((INavigationNode)this.moduleNode);
        this.anotherNodeSameView = new SubModuleNode(new NavigationNodeId("testId", "1"), "TestSubModuleLabel3");
        this.moduleNode.addChild((INavigationNode)this.anotherNodeSameView);
        this.anotherNodeSameView.setParent((INavigationNode)this.moduleNode);
        this.nodesBoundToView = new ArrayList<ISubModuleNode>();
        this.nodesBoundToSharedView = new ArrayList();
        this.subModuleNodeView = new TestView();
        this.node = new SubModuleNode(new NavigationNodeId("testId", "0"), "TestSubModuleLabel");
        this.moduleNode.setNavigationNodeController((INavigationNodeController)new ModuleController(this.moduleNode));
        this.moduleNode.addChild((INavigationNode)this.node);
        this.node.setParent((INavigationNode)this.moduleNode);
        this.subModuleNodeView.createPartControl((Composite)new Shell());
        this.node.activate();
    }

    protected void tearDown() throws Exception {
        this.node.deactivate(null);
        this.removeExtension("sub.module.view.test");
        this.shell.dispose();
        super.tearDown();
    }

    public void testBlocking() {
        Composite parentComposite = (Composite)ReflectionUtils.invokeHidden((Object)this.subModuleNodeView, (String)"getParentComposite", (Object[])new Object[0]);
        Composite contentComposite = (Composite)ReflectionUtils.invokeHidden((Object)this.subModuleNodeView, (String)"getContentComposite", (Object[])new Object[0]);
        Cursor oldCursor = parentComposite.getCursor();
        Cursor waitCursor = parentComposite.getDisplay().getSystemCursor(1);
        this.node.setBlocked(true);
        SubModuleViewTest.assertFalse((boolean)contentComposite.isEnabled());
        SubModuleViewTest.assertSame((Object)waitCursor, (Object)parentComposite.getCursor());
        this.node.setBlocked(false);
        SubModuleViewTest.assertTrue((boolean)contentComposite.isEnabled());
        SubModuleViewTest.assertSame((Object)oldCursor, (Object)parentComposite.getCursor());
        this.node.setBlocked(true);
        this.node.setBlocked(true);
        SubModuleViewTest.assertFalse((boolean)contentComposite.isEnabled());
        SubModuleViewTest.assertSame((Object)waitCursor, (Object)parentComposite.getCursor());
        this.node.setBlocked(false);
        SubModuleViewTest.assertTrue((boolean)contentComposite.isEnabled());
        SubModuleViewTest.assertSame((Object)oldCursor, (Object)parentComposite.getCursor());
    }

    public void testCreateController() throws Exception {
        SubModuleViewTest.assertNotNull((Object)this.subModuleNodeView.getController());
        SubModuleViewTest.assertEquals((Object)this.node, (Object)this.subModuleNodeView.getController().getNavigationNode());
    }

    public void testShared() {
        this.subModuleNodeView.dispose();
        SubModuleNode s1 = new SubModuleNode(new NavigationNodeId("s", "1"));
        SubModuleNode s2 = new SubModuleNode(new NavigationNodeId("s", "2"));
        this.moduleNode.addChild((INavigationNode)s1);
        this.moduleNode.addChild((INavigationNode)s2);
        TestSharedView subModuleNodeSharedView = new TestSharedView();
        subModuleNodeSharedView.s1 = s1;
        subModuleNodeSharedView.s2 = s2;
        subModuleNodeSharedView.createPartControl((Composite)new Shell());
        SubModuleViewTest.assertNotNull((Object)s1.getNavigationNodeController());
        s1.activate();
        SubModuleController s1c = (SubModuleController)s1.getNavigationNodeController();
        SubModuleViewTest.assertNotNull((Object)s1c.getRidget("button"));
        SubModuleViewTest.assertEquals((Object)this.nodesBoundToSharedView.get(0), (Object)s1);
        s2.activate();
        SubModuleViewTest.assertEquals((Object)this.nodesBoundToSharedView.get(2), (Object)s2);
        s1.dispose();
        SubModuleViewTest.assertFalse((boolean)subModuleNodeSharedView.unbindActiveCalled);
        s2.dispose();
        SubModuleViewTest.assertTrue((boolean)subModuleNodeSharedView.unbindActiveCalled);
    }

    public void testBindOnActivate() throws Exception {
        this.nodesBoundToView.clear();
        this.anotherNode.activate();
        SubModuleViewTest.assertTrue((boolean)this.nodesBoundToView.isEmpty());
        this.anotherNodeSameView.activate();
        SubModuleViewTest.assertTrue((boolean)this.nodesBoundToView.isEmpty());
        this.node.activate();
        SubModuleViewTest.assertEquals((int)1, (int)this.nodesBoundToView.size());
        SubModuleViewTest.assertSame((Object)this.node, (Object)this.nodesBoundToView.get(0));
    }

    public void testBlockOnBind() throws Exception {
        this.node.setBlocked(true);
        TestView2 view2 = new TestView2();
        view2.bind((ISubModuleNode)this.node);
        SubModuleViewTest.assertNotNull((Object)view2.blockViewCalled[0]);
        SubModuleViewTest.assertTrue((boolean)view2.blockViewCalled[0]);
        this.node.setBlocked(false);
        view2 = new TestView2();
        view2.bind((ISubModuleNode)this.node);
        SubModuleViewTest.assertNotNull((Object)view2.blockViewCalled[0]);
        SubModuleViewTest.assertFalse((boolean)view2.blockViewCalled[0]);
    }

    public void testShared2() {
        SubModuleNode node = new SubModuleNode(new NavigationNodeId("testId", "shared"));
        node.setParent((INavigationNode)this.moduleNode);
        TestSharedView2 smv = new TestSharedView2(node);
        smv.bind((ISubModuleNode)node);
        SubModuleViewTest.assertTrue((boolean)smv.bindCalled);
    }

    private final class TestSharedView
    extends SubModuleView {
        private SubModuleNode s1;
        private SubModuleNode s2;
        private Button button;
        private boolean unbindActiveCalled;

        private TestSharedView() {
        }

        public void bind(ISubModuleNode node) {
            if (node.getNavigationNodeController() == null) {
                node.setNavigationNodeController((INavigationNodeController)this.createController(node));
            }
            ReflectionUtils.setHidden((Object)((Object)this), (String)"currentController", (Object)node.getNavigationNodeController());
            SubModuleViewTest.this.nodesBoundToSharedView.add(node);
        }

        public SubModuleNode getNavigationNode() {
            return this.s1.isActivated() ? this.s1 : (this.s2.isActivated() ? this.s2 : this.s1);
        }

        protected void basicCreatePartControl(Composite parent) {
            this.button = new Button(parent, 0);
            this.addUIControl(this.button, "button");
        }

        public IViewSite getViewSite() {
            return (IViewSite)EasyMock.createNiceMock(IViewSite.class);
        }

        protected void unbindActiveController() {
            this.unbindActiveCalled = true;
        }

        protected SubModuleController createController(ISubModuleNode node) {
            return new SubModuleController(node);
        }

        protected String getSecondaryId() {
            return "shared";
        }

        protected IApplicationNode getAppNode() {
            return SubModuleViewTest.this.appNode;
        }
    }

    private final class TestSharedView2
    extends SubModuleView {
        private final SubModuleNode node;
        protected boolean bindCalled = false;

        public TestSharedView2(SubModuleNode node) {
            this.node = node;
            ReflectionUtils.setHidden((Object)((Object)this), (String)"contentComposite", (Object)SubModuleViewTest.this.parentComposite);
            Object blockHelper = ReflectionUtils.getHidden((Object)((Object)this), (String)"blockHelper");
            ReflectionUtils.setHidden((Object)blockHelper, (String)"contentComposite", (Object)SubModuleViewTest.this.parentComposite);
        }

        protected void basicCreatePartControl(Composite parent) {
        }

        protected AbstractViewBindingDelegate createBinding() {
            return new DefaultSwtBindingDelegate(){

                public void bind(IController controller) {
                    super.bind(controller);
                    TestSharedView2.this.bindCalled = true;
                }
            };
        }

        protected Composite getParentComposite() {
            return SubModuleViewTest.this.parentComposite;
        }

        protected void addUIControls(Composite composite) {
        }

        public SubModuleNode getNavigationNode() {
            return this.node;
        }
    }

    private final class TestView
    extends SubModuleView {
        private TestView() {
        }

        public void bind(ISubModuleNode node) {
            SubModuleViewTest.this.nodesBoundToView.add(node);
        }

        public SubModuleNode getNavigationNode() {
            return SubModuleViewTest.this.node;
        }

        protected void basicCreatePartControl(Composite parent) {
        }

        protected IApplicationNode getAppNode() {
            return SubModuleViewTest.this.appNode;
        }

        protected void registerView() {
        }

        protected void destroyView() {
        }
    }

    private final class TestView2
    extends SubModuleView {
        private final Composite cp;
        private final boolean[] blockViewCalled = new boolean[1];

        TestView2() {
            this.cp = new Composite((Composite)new Shell(), 0);
        }

        protected void basicCreatePartControl(Composite parent) {
        }

        protected Composite getParentComposite() {
            return this.cp;
        }

        protected Composite getContentComposite() {
            return this.cp;
        }

        protected void blockView(boolean block) {
            this.blockViewCalled[0] = block;
        }
    }
}

