/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.ui.filter;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.security.common.authorization.ISentinelService;
import org.eclipse.riena.security.ui.filter.IPermissionFilterMappingExtension;
import org.eclipse.riena.security.ui.filter.PermissionUIFilterApplier;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterContainer;
import org.eclipse.riena.ui.filter.IUIFilterProvider;
import org.eclipse.riena.ui.filter.impl.UIFilter;

@NonUITestCase
public class PermissionUIFilterApplierTest
extends TestCase {
    public void testApplyFilters() throws Exception {
        ApplicationNode app = new ApplicationNode();
        SubApplicationNode subApp1 = new SubApplicationNode(new NavigationNodeId("subapp1"));
        app.addChild((INavigationNode)subApp1);
        SubApplicationNode subApp2 = new SubApplicationNode(new NavigationNodeId("subapp2"));
        app.addChild((INavigationNode)subApp2);
        ModuleGroupNode mg1 = new ModuleGroupNode(new NavigationNodeId("mg1"));
        subApp1.addChild((INavigationNode)mg1);
        ModuleGroupNode mg2 = new ModuleGroupNode(new NavigationNodeId("mg2"));
        subApp2.addChild((INavigationNode)mg2);
        ModuleNode m1 = new ModuleNode(new NavigationNodeId("m1"));
        mg1.addChild((INavigationNode)m1);
        ModuleNode m2 = new ModuleNode(new NavigationNodeId("m2"));
        mg2.addChild((INavigationNode)m2);
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("sm1"));
        m1.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        m2.addChild((INavigationNode)sm2);
        app.activate();
        UIFilter filter = new UIFilter("filter1");
        TestUIFilterContainer filterContainer = new TestUIFilterContainer((IUIFilter)filter, "/application/subapp1/mg1/m1/sm1");
        TestUIFilterProvider filterProvider = new TestUIFilterProvider();
        filterProvider.filterContainers.put("filter_sm1", filterContainer);
        TestPermissionFilterManager filterManager = new TestPermissionFilterManager();
        filterManager.filterProvider = filterProvider;
        FilterMappingExtension filterMapping = new FilterMappingExtension(null, "somePName", "somePAction", "filter_sm1");
        filterManager.update(new IPermissionFilterMappingExtension[]{filterMapping});
        TestSentinalService sentinalService = new TestSentinalService();
        sentinalService.valid = false;
        filterManager.bind(sentinalService);
        filterManager.applyFilter((INavigationNode)app);
        PermissionUIFilterApplierTest.assertTrue((sm1.getFilters().size() == 1 ? 1 : 0) != 0);
        PermissionUIFilterApplierTest.assertEquals(sm1.getFilters().iterator().next(), (Object)filter);
        filterManager.applyFilter((INavigationNode)app);
        PermissionUIFilterApplierTest.assertTrue((sm1.getFilters().size() == 1 ? 1 : 0) != 0);
        sm1.removeAllFilters();
        sentinalService.valid = true;
        filterManager.applyFilter((INavigationNode)app);
        PermissionUIFilterApplierTest.assertTrue((boolean)sm1.getFilters().isEmpty());
    }

    private class FilterMappingExtension
    implements IPermissionFilterMappingExtension {
        Class<? extends Permission> permissionClass;
        String permissionName;
        String permissionAction;
        String filterId;

        public FilterMappingExtension(Class<? extends Permission> permissionClass, String permissionName, String permissionAction, String filterId) {
            this.permissionClass = permissionClass;
            this.permissionName = permissionName;
            this.permissionAction = permissionAction;
            this.filterId = filterId;
        }

        public Class<? extends Permission> getPermissionClass() {
            return this.permissionClass;
        }

        public String getPermissionName() {
            return this.permissionName;
        }

        public String getPermissionAction() {
            return this.permissionName;
        }

        public String getFilterID() {
            return this.filterId;
        }
    }

    private final class TestPermissionFilterManager
    extends PermissionUIFilterApplier {
        IUIFilterProvider filterProvider;

        private TestPermissionFilterManager() {
        }

        protected IUIFilterProvider getUIFilterProvider() {
            return this.filterProvider;
        }

        protected void observeNavigationModel() {
        }
    }

    private class TestSentinalService
    implements ISentinelService {
        boolean valid = true;

        private TestSentinalService() {
        }

        public boolean checkAccess(Permission permission) {
            return this.valid;
        }
    }

    private class TestUIFilterContainer
    implements IUIFilterContainer {
        IUIFilter filter;
        String targetNodeId;

        public TestUIFilterContainer(IUIFilter filter, String targetNodeId) {
            this.filter = filter;
            this.targetNodeId = targetNodeId;
        }

        public IUIFilter getFilter() {
            return this.filter;
        }

        public Collection<String> getFilterTargetNodeIds() {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(this.targetNodeId);
            return ids;
        }
    }

    private class TestUIFilterProvider
    implements IUIFilterProvider {
        Map<String, IUIFilterContainer> filterContainers = new HashMap<String, IUIFilterContainer>();

        private TestUIFilterProvider() {
        }

        public IUIFilterContainer provideFilter(String filterID) {
            return this.filterContainers.get(filterID);
        }
    }
}

