/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.annotation.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.annotationprocessor.AnnotatedOverriddenMethodsGuard;
import org.eclipse.riena.core.annotationprocessor.AnnotationProcessor;
import org.eclipse.riena.core.annotationprocessor.IAnnotatedMethodHandler;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.annotationprocessor.IAnnotatedMethodHandlerExtension;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.annotation.OnClick;
import org.eclipse.riena.ui.ridgets.annotation.handler.AbstractRidgetContainerAnnotationHandler;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.swt.widgets.Display;

@NonUITestCase
public class RidgetContainerAnnotationProcessorTest
extends RienaTestCase {
    private AnnotationProcessor processor;

    protected void setUp() throws Exception {
        super.setUp();
        this.processor = AnnotationProcessor.getInstance();
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        RidgetContainerAnnotationProcessorTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddListenerToRidgetWithAbstractRidgetContainerAnnotationHandler() {
        Handler onClick = new Handler(OnClick.class);
        this.processor.update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, (IAnnotatedMethodHandler)onClick)});
        B container = new B();
        TextRidget ridget1 = new TextRidget();
        TextRidget ridget2 = new TextRidget();
        TextRidget ridget3 = new TextRidget();
        container.addRidget("RidgetA1", (IRidget)ridget1);
        container.addRidget("RidgetA2", (IRidget)ridget2);
        container.addRidget("RidgetB1", (IRidget)ridget3);
        AnnotationProcessor.getInstance().processMethods((Object)container);
        RidgetContainerAnnotationProcessorTest.assertEquals((int)2, (int)onClick.getHandled().size());
        RidgetContainerAnnotationProcessorTest.assertTrue((boolean)(onClick.getHandled().get(0) instanceof OnClick));
        RidgetContainerAnnotationProcessorTest.assertTrue((boolean)(onClick.getHandled().get(1) instanceof OnClick));
        RidgetContainerAnnotationProcessorTest.assertEquals((String)"RidgetA1", (String)((OnClick)onClick.getHandled().get(0)).ridgetId());
        RidgetContainerAnnotationProcessorTest.assertEquals((String)"RidgetA2", (String)((OnClick)onClick.getHandled().get(1)).ridgetId());
        RidgetContainerAnnotationProcessorTest.assertEquals((Object)ridget1, container.getRidget("RidgetA1"));
        RidgetContainerAnnotationProcessorTest.assertEquals((Object)ridget2, container.getRidget("RidgetA2"));
        RidgetContainerAnnotationProcessorTest.assertEquals((Object)ridget3, container.getRidget("RidgetB1"));
        ListenerList focusListeners = (ListenerList)ReflectionUtils.getHidden((Object)ridget1, (String)"focusListeners");
        RidgetContainerAnnotationProcessorTest.assertTrue((focusListeners.size() == 1 ? 1 : 0) != 0);
        focusListeners = (ListenerList)ReflectionUtils.getHidden((Object)ridget2, (String)"focusListeners");
        RidgetContainerAnnotationProcessorTest.assertTrue((focusListeners.size() == 1 ? 1 : 0) != 0);
        focusListeners = (ListenerList)ReflectionUtils.getHidden((Object)ridget3, (String)"focusListeners");
        RidgetContainerAnnotationProcessorTest.assertTrue((focusListeners.size() == 0 ? 1 : 0) != 0);
    }

    public void testAddListenerToRidgetFromAnotherClass() {
        Handler onClick = new Handler(OnClick.class);
        this.processor.update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, (IAnnotatedMethodHandler)onClick)});
        B container = new B();
        TextRidget ridget1 = new TextRidget();
        TextRidget ridget2 = new TextRidget();
        container.addRidget("RidgetA1", (IRidget)ridget1);
        container.addRidget("RidgetA2", (IRidget)ridget2);
        AnnotationProcessor.getInstance().processMethods((Object)container, (Object)new C());
        RidgetContainerAnnotationProcessorTest.assertEquals((int)1, (int)onClick.getHandled().size());
        RidgetContainerAnnotationProcessorTest.assertTrue((boolean)(onClick.getHandled().get(0) instanceof OnClick));
        RidgetContainerAnnotationProcessorTest.assertEquals((String)"RidgetA2", (String)((OnClick)onClick.getHandled().get(0)).ridgetId());
        RidgetContainerAnnotationProcessorTest.assertEquals((Object)ridget1, container.getRidget("RidgetA1"));
        RidgetContainerAnnotationProcessorTest.assertEquals((Object)ridget2, container.getRidget("RidgetA2"));
        ListenerList focusListeners = (ListenerList)ReflectionUtils.getHidden((Object)ridget1, (String)"focusListeners");
        RidgetContainerAnnotationProcessorTest.assertTrue((focusListeners.size() == 0 ? 1 : 0) != 0);
        focusListeners = (ListenerList)ReflectionUtils.getHidden((Object)ridget2, (String)"focusListeners");
        RidgetContainerAnnotationProcessorTest.assertTrue((focusListeners.size() == 1 ? 1 : 0) != 0);
    }

    private IAnnotatedMethodHandlerExtension create(final Class<? extends Annotation> annotationClass, final IAnnotatedMethodHandler handler) {
        return new IAnnotatedMethodHandlerExtension(){

            public Class<? extends Annotation> getAnnotation() {
                return annotationClass;
            }

            public IAnnotatedMethodHandler createHandler() {
                return handler;
            }
        };
    }

    private static class A
    extends DummyContainer {
        private A() {
        }

        @OnClick(ridgetId="RidgetA1")
        public void onClick() {
        }
    }

    private static class B
    extends A {
        private B() {
        }

        @Override
        @OnClick(ridgetId="RidgetA2")
        public void onClick() {
        }
    }

    private static class C {
        private C() {
        }

        @OnClick(ridgetId="RidgetA2")
        public void onClick() {
        }
    }

    private static class DummyContainer
    implements IRidgetContainer {
        private final Map<String, IRidget> ridgets = new HashMap<String, IRidget>();

        private DummyContainer() {
        }

        public void addRidget(String id, IRidget ridget) {
            this.ridgets.put(id, ridget);
        }

        public boolean removeRidget(String id) {
            return false;
        }

        public void configureRidgets() {
        }

        public <R extends IRidget> R getRidget(String id) {
            return (R)this.ridgets.get(id);
        }

        public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
            return this.getRidget(id);
        }

        public Collection<? extends IRidget> getRidgets() {
            return this.ridgets.values();
        }

        public boolean isConfigured() {
            return false;
        }

        public void setConfigured(boolean configured) {
        }

        public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        }
    }

    private static class Handler
    extends AbstractRidgetContainerAnnotationHandler {
        private final Class<? extends Annotation> annotationClass;
        private final List<Annotation> handled = new ArrayList<Annotation>();

        public Handler(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        public void handleAnnotation(Annotation annotation, IRidgetContainer ridgetContainer, Object target, Method targetMethod, AnnotatedOverriddenMethodsGuard guard) {
            RidgetContainerAnnotationProcessorTest.assertTrue((boolean)this.annotationClass.isInstance(annotation));
            this.handled.add(annotation);
            IRidget ridget = this.getRidget(annotation, targetMethod, ridgetContainer, ((OnClick)annotation).ridgetId());
            ridget.addFocusListener(new IFocusListener(){

                public void focusLost(FocusEvent event) {
                }

                public void focusGained(FocusEvent event) {
                }
            });
        }

        public List<Annotation> getHandled() {
            return this.handled;
        }
    }
}

