/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.marker.StatuslineMessageMarkerViewer;

@NonUITestCase
public class StatuslineMessageMarkerViewerTest2
extends RienaTestCase {
    private static final String MESSAGE = "message";
    private StatuslineMessageMarkerViewerUnderTest viewer;
    private IStatuslineRidget statuslineRidget;
    private boolean hasRidgetFocus = true;
    private IMarkableRidget markableRidget;

    protected void setUp() throws Exception {
        super.setUp();
        this.statuslineRidget = (IStatuslineRidget)EasyMock.createNiceMock(IStatuslineRidget.class);
        this.viewer = new StatuslineMessageMarkerViewerUnderTest(this.statuslineRidget);
        this.markableRidget = (IMarkableRidget)EasyMock.createNiceMock(IMarkableRidget.class);
        ArrayList<ErrorMessageMarker> marker = new ArrayList<ErrorMessageMarker>();
        marker.add(new ErrorMessageMarker(MESSAGE));
        EasyMock.expect((Object)this.markableRidget.hasFocus()).andReturn((Object)this.hasRidgetFocus).anyTimes();
        EasyMock.expect((Object)this.markableRidget.getMarkersOfType(ErrorMessageMarker.class)).andReturn(marker).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.markableRidget});
    }

    public void testShowMessagesWithFocus() throws Exception {
        this.statuslineRidget.error(MESSAGE);
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.viewer.showMessages((IBasicMarkableRidget)this.markableRidget);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }

    public void testShowMessagesWithoutFocus() throws Exception {
        this.hasRidgetFocus = false;
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.viewer.showMessages((IBasicMarkableRidget)this.markableRidget);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }

    private class StatuslineMessageMarkerViewerUnderTest
    extends StatuslineMessageMarkerViewer {
        public StatuslineMessageMarkerViewerUnderTest(IStatuslineRidget statuslineRidget) {
            super(statuslineRidget);
        }

        public void showMessages(IBasicMarkableRidget markableRidget) {
            super.showMessages(markableRidget);
        }
    }
}

