/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.DisabledMarkerVisualizer;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class BasicMarkerSupportTest
extends TestCase {
    private Display display;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
    }

    protected void tearDown() {
        SwtUtilities.dispose((Widget)this.shell);
        this.display = null;
    }

    public void testInit() {
        DefaultRealm realm = new DefaultRealm();
        try {
            Text control = new Text((Composite)this.shell, 0);
            TextRidget ridget = new TextRidget();
            ridget.setUIControl((Object)control);
            ridget.addMarker((IMarker)new ErrorMarker());
            ridget.addMarker((IMarker)new MandatoryMarker());
            MyBasicMarkerSupport markerSupport = new MyBasicMarkerSupport();
            markerSupport.setClearAllMarkersCalled(false);
            markerSupport.init((IBasicMarkableRidget)ridget, null);
            BasicMarkerSupportTest.assertEquals((int)2, (int)ridget.getMarkers().size());
            control.dispose();
            BasicMarkerSupportTest.assertEquals((int)2, (int)ridget.getMarkers().size());
            BasicMarkerSupportTest.assertTrue((boolean)markerSupport.isClearAllMarkersCalled());
        }
        finally {
            realm.dispose();
        }
    }

    public void testBind() throws Exception {
        Shell shell = new Shell();
        final Text txt = new Text((Composite)shell, 0);
        BasicMarkerSupport support = new BasicMarkerSupport(){

            protected Control getUIControl() {
                return txt;
            }
        };
        support.bind();
        BasicMarkerSupportTest.assertTrue((boolean)support.isInitialEnabled());
        txt.setEnabled(false);
        support.bind();
        BasicMarkerSupportTest.assertFalse((boolean)support.isInitialEnabled());
        shell.setEnabled(false);
        txt.setEnabled(true);
        BasicMarkerSupportTest.assertFalse((boolean)txt.isEnabled());
        BasicMarkerSupportTest.assertTrue((boolean)txt.getEnabled());
        support.bind();
        BasicMarkerSupportTest.assertTrue((boolean)support.isInitialEnabled());
        shell.setEnabled(true);
    }

    public void testUnbind() throws Exception {
        final Boolean[] x = new Boolean[2];
        DisabledMarkerVisualizer vMock = new DisabledMarkerVisualizer(null){
            private int i;
            {
                super($anonymous0);
                this.i = 0;
            }

            public void updateDisabled(Control control, boolean enabled) {
                x[this.i++] = enabled;
            }
        };
        Shell shell = new Shell();
        final Text txt = new Text((Composite)shell, 0);
        BasicMarkerSupport support = new BasicMarkerSupport(){

            protected Control getUIControl() {
                return txt;
            }
        };
        ReflectionUtils.setHidden((Object)support, (String)"disabledMarkerVisualizer", (Object)vMock);
        support.bind();
        support.unbind();
        BasicMarkerSupportTest.assertTrue((boolean)x[0]);
        txt.setEnabled(false);
        support.bind();
        support.unbind();
        BasicMarkerSupportTest.assertFalse((boolean)x[1]);
    }

    public void testClearVisible() {
        DefaultRealm realm = new DefaultRealm();
        try {
            Label control = new Label((Composite)this.shell, 0);
            LabelRidget ridget = new LabelRidget();
            ridget.setUIControl((Object)control);
            boolean isVisible = control.getVisible();
            BasicMarkerSupportTest.assertTrue((boolean)control.getVisible());
            ridget.setVisible(false);
            BasicMarkerSupportTest.assertFalse((boolean)control.getVisible());
            AbstractMarkerSupport markerSupport = (AbstractMarkerSupport)ReflectionUtils.getHidden((Object)ridget, (String)"markerSupport");
            BasicMarkerSupportTest.assertTrue((boolean)(markerSupport instanceof BasicMarkerSupport));
            ReflectionUtils.invokeHidden((Object)markerSupport, (String)"clearVisible", (Object[])new Object[]{control});
            BasicMarkerSupportTest.assertEquals((boolean)isVisible, (boolean)control.getVisible());
        }
        finally {
            realm.dispose();
        }
    }

    private static class MyBasicMarkerSupport
    extends BasicMarkerSupport {
        private boolean clearAllMarkersCalled;

        private MyBasicMarkerSupport() {
        }

        protected void clearAllMarkers(Control control) {
            super.clearAllMarkers(control);
            this.setClearAllMarkersCalled(true);
        }

        public void setClearAllMarkersCalled(boolean clearAllMarkersCalled) {
            this.clearAllMarkersCalled = clearAllMarkersCalled;
        }

        public boolean isClearAllMarkersCalled() {
            return this.clearAllMarkersCalled;
        }
    }
}

