/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.text.DecimalFormat;
import java.util.Locale;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidInteger;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class ValidIntegerTest
extends RienaTestCase {
    public final void testUSlocale() throws Exception {
        ValidInteger rule = new ValidInteger(Locale.US);
        try {
            rule.validate(new Object());
            ValidIntegerTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        ValidIntegerTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1,000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1,000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1,000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1,000,200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1,000,200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1,000,200").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1,000.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1,000.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1,000.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.23A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
    }

    public final void testGermanLocale() throws Exception {
        ValidInteger rule = new ValidInteger(Locale.GERMANY);
        try {
            rule.validate(new Object());
            ValidIntegerTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        ValidIntegerTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1.000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1.000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1.000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1.000.200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1.000.200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1.000.200").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.000,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1.000,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1.000,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1,234.31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1,234.31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1,234.31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.23A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
    }

    public final void testSwissLocale() throws Exception {
        ValidInteger rule = new ValidInteger(new Locale("de", "CH"));
        try {
            rule.validate(new Object());
            ValidIntegerTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        ValidIntegerTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1'000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1'000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1'000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1'000'200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1'000'200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1'000'200").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1'000.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1'000.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1'000.0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.23A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
    }

    public final void testFrenchLocale() throws Exception {
        ValidInteger rule = new ValidInteger(Locale.FRANCE);
        try {
            rule.validate(new Object());
            ValidIntegerTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        ValidIntegerTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 2").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1 000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1 000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1 000").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"1 000 200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"-1 000 200").isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)"- 1 000 200").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1 000,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1 000,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1 000,0").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"-1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"- 1.234,31").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"1.23A").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
    }

    public final void testHindiLocale() throws Exception {
        Locale hindi = new Locale("hi", "IN");
        ValidInteger rule = new ValidInteger(hindi);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(hindi);
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(12L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(12345L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(-12L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(-12345L)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(12.5)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(12345.6)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(-12.3)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(-12345.6)).isOK());
    }

    public final void testThailandLocale() throws Exception {
        Locale thailand = new Locale("th", "TH");
        ValidInteger rule = new ValidInteger(thailand);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(thailand);
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(12L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(12345L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(-12L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(-12345L)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(12.5)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(12345.6)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(-12.3)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(-12345.6)).isOK());
    }

    public final void testArabLocale() throws Exception {
        Locale arabEmirates = new Locale("ar", "AE");
        ValidInteger rule = new ValidInteger(arabEmirates);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(arabEmirates);
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(12L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(12345L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(-12L)).isOK());
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(-12345L)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(12.5)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(12345.6)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(-12.3)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(-12345.6)).isOK());
    }

    public final void testUnsigned() throws Exception {
        Locale locale = Locale.US;
        ValidInteger rule = new ValidInteger(false, locale);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(locale);
        ValidIntegerTest.assertTrue((boolean)rule.validate((Object)format.format(12L)).isOK());
        ValidIntegerTest.assertFalse((boolean)rule.validate((Object)format.format(-12L)).isOK());
    }

    public void testSetInitializationData() throws Exception {
        ValidInteger validator = new ValidInteger();
        validator.setInitializationData(null, null, (Object)"true");
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"2").isOK());
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"-2").isOK());
        validator = new ValidInteger();
        validator.setInitializationData(null, null, (Object)"false");
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"2").isOK());
        ValidIntegerTest.assertFalse((boolean)validator.validate((Object)"-2").isOK());
        validator = new ValidInteger();
        String localString = String.valueOf(Locale.GERMANY.getLanguage()) + "," + Locale.GERMANY.getCountry();
        validator.setInitializationData(null, null, (Object)localString);
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"2.000").isOK());
        ValidIntegerTest.assertFalse((boolean)validator.validate((Object)"2,000").isOK());
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"-2").isOK());
        validator = new ValidInteger();
        localString = String.valueOf(Locale.US.getLanguage()) + "," + Locale.US.getCountry();
        validator.setInitializationData(null, null, (Object)localString);
        ValidIntegerTest.assertFalse((boolean)validator.validate((Object)"2.000").isOK());
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"2,000").isOK());
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"-2").isOK());
        validator = new ValidInteger();
        localString = String.valueOf(Locale.US.getLanguage()) + "," + Locale.US.getCountry();
        validator.setInitializationData(null, null, (Object)("false," + localString));
        ValidIntegerTest.assertFalse((boolean)validator.validate((Object)"2.000").isOK());
        ValidIntegerTest.assertTrue((boolean)validator.validate((Object)"2,000").isOK());
        ValidIntegerTest.assertFalse((boolean)validator.validate((Object)"-2").isOK());
    }
}

