/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades;

import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.facades.FacadeFactory;
import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.riena.ui.swt.facades.TestBadCastFacade;
import org.eclipse.riena.ui.swt.facades.TestInstantiationBugFacade;
import org.eclipse.swt.SWT;

@NonUITestCase
public class FacadeFactoryTest
extends RienaTestCase {
    public void testBadCast() throws Throwable {
        SWT.getPlatform();
        try {
            this.newFacade(TestBadCastFacade.class);
            FacadeFactoryTest.fail();
        }
        catch (RuntimeException e) {
            FacadeFactoryTest.assertTrue((boolean)(e.getCause() instanceof ClassCastException));
        }
    }

    public void testInstantiationBug() throws Throwable {
        try {
            this.newFacade(TestInstantiationBugFacade.class);
            FacadeFactoryTest.fail();
        }
        catch (RuntimeException e) {
            FacadeFactoryTest.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
        }
    }

    public void testSpecificFacadeNotFound() throws Throwable {
        try {
            this.newFacade(FacadeFactoryTest.class);
            FacadeFactoryTest.fail();
        }
        catch (RuntimeException e) {
            FacadeFactoryTest.assertTrue((boolean)(e.getCause() instanceof ClassNotFoundException));
        }
    }

    public void testSomethingGood() throws Throwable {
        GCFacade gcFacade = (GCFacade)this.newFacade(GCFacade.class);
        FacadeFactoryTest.assertTrue((gcFacade.getClass() != GCFacade.class ? 1 : 0) != 0);
        FacadeFactoryTest.assertTrue((boolean)(gcFacade instanceof GCFacade));
    }

    private Object newFacade(Class<?> clazz) throws Throwable {
        try {
            return ReflectionUtils.invokeHidden(FacadeFactory.class, (String)"newFacade", (Object[])new Object[]{clazz});
        }
        catch (InvocationTargetFailure itaf) {
            throw itaf.getCause();
        }
    }
}

