/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.IEditableRidget;
import org.eclipse.riena.ui.ridgets.IValueRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.swt.widgets.Composite;

public class TableRidgetEditingSupport
extends EditingSupport {
    private final AbstractTableRidget tableRidget;
    private final PropertyDescriptor property;
    private final ColumnViewerEditorActivationListenerHelper activationListener;
    private final CellEditor cellEditor;
    private IValueRidget valueRidget;

    public TableRidgetEditingSupport(AbstractTableRidget tableRidget, PropertyDescriptor property, int columnStyle) {
        super((ColumnViewer)tableRidget.getTableViewer());
        this.tableRidget = tableRidget;
        this.property = property;
        this.activationListener = new ColumnViewerEditorActivationListenerHelper();
        this.cellEditor = this.createCellEditort(property, columnStyle);
    }

    private CellEditor createCellEditort(PropertyDescriptor property, int style) {
        if (property == null) {
            return null;
        }
        Class<?> type = property.getPropertyType();
        Composite table = (Composite)this.getViewer().getControl();
        int editorStyle = this.getAlignment(style);
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return null;
        }
        TextCellEditor editor = new TextCellEditor(table, editorStyle);
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            editor.getControl().setData("type", (Object)"numeric");
        } else if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            editor.getControl().setData("type", (Object)"numeric");
        } else if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            editor.getControl().setData("type", (Object)"numeric");
        } else if (BigInteger.class.equals(type)) {
            editor.getControl().setData("type", (Object)"numeric");
        } else if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            editor.getControl().setData("type", (Object)"decimal");
        } else if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            editor.getControl().setData("type", (Object)"decimal");
        } else if (BigDecimal.class.equals(type)) {
            editor.getControl().setData("type", (Object)"decimal");
        } else if (Date.class.equals(type)) {
            editor.getControl().setData("type", (Object)"date");
        }
        return editor;
    }

    private int getAlignment(int style) {
        if ((style & 0x4000) == 16384) {
            return 16384;
        }
        if ((style & 0x20000) == 131072) {
            return 131072;
        }
        if ((style & 0x1000000) == 0x1000000) {
            return 0x1000000;
        }
        return -1;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        this.valueRidget = (IValueRidget)SwtRidgetFactory.createRidget(cellEditor.getControl());
        Object valueHolder = cell.getElement();
        this.valueRidget.bindToModel(valueHolder, this.property.getName());
        this.valueRidget.updateFromModel();
        this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
    }

    protected void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        if (this.valueRidget instanceof IEditableRidget) {
            ((IEditableRidget)this.valueRidget).revalidate();
        } else if (this.valueRidget instanceof ToggleButtonRidget) {
            ((ToggleButtonRidget)this.valueRidget).getValueBindingSupport().updateFromTarget();
        }
    }

    protected boolean canEdit(Object element) {
        return this.getCellEditor(element) != null;
    }

    protected Object getValue(Object element) {
        return null;
    }

    protected void setValue(Object element, Object value) {
    }

    private class ColumnViewerEditorActivationListenerHelper
    extends ColumnViewerEditorActivationListener {
        private ColumnViewerEditorActivationListenerHelper() {
        }

        public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
        }

        public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
        }

        public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
        }

        public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            TableRidgetEditingSupport.this.tableRidget.updateFromModel();
            if (TableRidgetEditingSupport.this.valueRidget != null) {
                TableRidgetEditingSupport.this.valueRidget.setUIControl(null);
            }
            TableRidgetEditingSupport.this.valueRidget = null;
        }
    }
}

