/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.annotation.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.eclipse.riena.core.annotationprocessor.AnnotatedOverriddenMethodsGuard;
import org.eclipse.riena.core.annotationprocessor.DisposerList;
import org.eclipse.riena.core.annotationprocessor.IAnnotatedMethodHandler;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;

public abstract class AbstractRidgetContainerAnnotationHandler
implements IAnnotatedMethodHandler {
    protected ThreadLocal<DisposerList> disposers = new ThreadLocal();
    protected ThreadLocal<Map<?, ?>> optionalArgs = new ThreadLocal();

    protected IRidget getRidget(Annotation annotation, Method method, IRidgetContainer ridgetContainer, String ridgetId) {
        Object ridget = ridgetContainer.getRidget(ridgetId);
        if (ridget != null) {
            return ridget;
        }
        throw new IllegalStateException(annotation + " defined unknown ridget id on method '" + method + "'.");
    }

    public void handleAnnotation(Annotation annotation, Object object, Method method, Map<?, ?> optionalArgs, AnnotatedOverriddenMethodsGuard guard, DisposerList disposers) {
        if (!optionalArgs.containsKey("process.target") || !(optionalArgs.get("process.target") instanceof IRidgetContainer)) {
            throw new IllegalArgumentException("Argument 'process.target' must be set.");
        }
        IRidgetContainer ridgetContainer = (IRidgetContainer)optionalArgs.get("process.target");
        this.disposers.set(disposers);
        this.optionalArgs.set(optionalArgs);
        this.handleAnnotation(annotation, ridgetContainer, object, method, guard);
        this.disposers.remove();
        this.optionalArgs.remove();
    }

    public abstract void handleAnnotation(Annotation var1, IRidgetContainer var2, Object var3, Method var4, AnnotatedOverriddenMethodsGuard var5);

    protected void errorUnsupportedRidgetType(Annotation annotation, IRidget ridget) {
        throw new IllegalStateException(annotation + " defined for incompatible ridget type '" + ridget.getClass().getName() + "' with id '" + ridget.getID() + "'.");
    }

    protected <L> L createListener(Class<L> listenerClazz, String listenerMethodName, Object target, Method targetMethod) {
        return (L)Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{listenerClazz}, (InvocationHandler)new ListenerHandler(target, listenerClazz, listenerMethodName, targetMethod));
    }

    public DisposerList getDisposers() {
        return this.disposers.get();
    }

    public Map<?, ?> getOptionalArgs() {
        return this.optionalArgs.get();
    }

    private static class ListenerHandler
    implements InvocationHandler {
        private final Object target;
        private final Class<?> listenerClazz;
        private final String listenerMethodName;
        private final Method targetMethod;

        public ListenerHandler(Object target, Class<?> listenerClazz, String listenerMethodName, Method targetMethod) {
            this.target = target;
            this.listenerClazz = listenerClazz;
            this.listenerMethodName = listenerMethodName;
            this.targetMethod = targetMethod;
            if (!targetMethod.isAccessible()) {
                targetMethod.setAccessible(true);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (methodName.equals("equals")) {
                    if (proxy == args[0]) {
                        return true;
                    }
                    return false;
                }
                if (methodName.equals("toString")) {
                    return "Proxy for " + this.listenerClazz.getName() + " " + proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
                }
            }
            if (methodName.equals(this.listenerMethodName)) {
                try {
                    if (this.targetMethod.getParameterTypes().length == 0) {
                        return this.targetMethod.invoke(this.target, new Object[0]);
                    }
                    return this.targetMethod.invoke(this.target, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return null;
        }
    }
}

