/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationSwitcherWidget;
import org.eclipse.riena.ui.swt.facades.internal.AbstractNavigationToolTip;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class SubApplicationToolTip
extends AbstractNavigationToolTip {
    private static final int DEFAULT_TOOLTIP_SHIFT_X = SwtUtilities.convertXToDpi((int)10);
    private static final int DEFAULT_TOOLTIP_SHIFT_Y = SwtUtilities.convertYToDpi((int)10);
    private final SubApplicationSwitcherWidget control;

    public SubApplicationToolTip(SubApplicationSwitcherWidget control) {
        super((Control)control);
        Assert.isNotNull((Object)control);
        this.control = control;
        this.setShift(new Point(DEFAULT_TOOLTIP_SHIFT_X, DEFAULT_TOOLTIP_SHIFT_Y));
    }

    @Override
    protected String getToolTipText(Event event) {
        SubApplicationItem item = this.control.getItem(new Point(event.x, event.y));
        return item != null ? item.getToolTipText() : null;
    }

    @Override
    protected boolean shouldCreateToolTip(Event event) {
        if (super.shouldCreateToolTip(event)) {
            return StringUtils.isGiven((CharSequence)this.getToolTipText(event));
        }
        return false;
    }

    @Override
    protected Integer getLnfDelay(RienaDefaultLnf lnf) {
        return lnf.getIntegerSetting("SubAppicationItemToolTip.popupDelay");
    }

    @Override
    protected Font getLnfFont(RienaDefaultLnf lnf) {
        return lnf.getFont("SubApplicationItemToolTip.font");
    }

    @Override
    protected Color getLnfBackground(RienaDefaultLnf lnf) {
        return lnf.getColor("SubApplicationItemToolTip.background");
    }

    @Override
    protected Color getLnfForeground(RienaDefaultLnf lnf) {
        return lnf.getColor("SubApplicationItemToolTip.foreground");
    }
}

