/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import org.eclipse.sapphire.util.EqualsFactory;
import org.eclipse.sapphire.util.HashCodeFactory;

public final class Color {
    public static final Color WHITE = new Color(255, 255, 255);
    private final int red;
    private final int green;
    private final int blue;

    public Color(int red, int green, int blue) {
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException();
        }
        this.red = red;
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException();
        }
        this.green = green;
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException();
        }
        this.blue = blue;
    }

    public Color(String color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        if (!color.startsWith("#") || color.length() != 7) {
            throw new IllegalArgumentException(color);
        }
        this.red = Integer.valueOf(color.substring(1, 3), 16);
        this.green = Integer.valueOf(color.substring(3, 5), 16);
        this.blue = Integer.valueOf(color.substring(5, 7), 16);
    }

    public int red() {
        return this.red;
    }

    public int green() {
        return this.green;
    }

    public int blue() {
        return this.blue;
    }

    public boolean equals(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            return EqualsFactory.start().add(this.red, color.red).add(this.green, color.green).add(this.blue, color.blue).result();
        }
        return false;
    }

    public int hashCode() {
        return HashCodeFactory.start().add(this.red).add(this.green).add(this.blue).result();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('#');
        String temp = Integer.toHexString(this.red).toUpperCase();
        if (temp.length() < 2) {
            buf.append('0');
        }
        buf.append(temp);
        temp = Integer.toHexString(this.green).toUpperCase();
        if (temp.length() < 2) {
            buf.append('0');
        }
        buf.append(temp);
        temp = Integer.toHexString(this.blue).toUpperCase();
        if (temp.length() < 2) {
            buf.append('0');
        }
        buf.append(temp);
        return buf.toString();
    }
}

